/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.introspect;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.module.scala.introspect.BeanDescriptor;
import com.fasterxml.jackson.module.scala.introspect.ConstructorParameter;
import com.fasterxml.jackson.module.scala.introspect.PropertyDescriptor;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class BeanIntrospector$ {
    public static BeanIntrospector$ MODULE$;
    private final CachingParanamer paranamer;
    private final Class<Product> productClass;

    static {
        new BeanIntrospector$();
    }

    private Class<Product> productClass() {
        return this.productClass;
    }

    private String[] getCtorParams(Constructor<?> ctor) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.paranamer.lookupParameterNames(ctor, false))).map((Function1 & Serializable & scala.Serializable)name0 -> NameTransformer$.MODULE$.decode(name0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public <T> BeanDescriptor apply(Manifest<?> mf) {
        return this.apply(mf.runtimeClass());
    }

    public <T> BeanDescriptor apply(Class<?> cls2) {
        List hierarchy = this.next$1(cls2, (List)Nil$.MODULE$);
        Regex privateRegex = new StringOps(Predef$.MODULE$.augmentString("(.*)\\$\\$(.*)")).r();
        Seq fields = (Seq)hierarchy.flatMap(arg_0 -> BeanIntrospector$.$anonfun$apply$14$adapted(this, (Seq)hierarchy, privateRegex, arg_0), Seq$.MODULE$.canBuildFrom());
        Seq methods = (Seq)hierarchy.flatMap((Function1 & Serializable & scala.Serializable)cls -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredMethods())).map((Function1 & Serializable & scala.Serializable)getter -> {
            String name = NameTransformer$.MODULE$.decode(getter.getName());
            return new Tuple2(getter, (Object)name);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$22(x$10))).withFilter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$23(cls, x$11))).withFilter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$24(x$12))).withFilter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$25(fields$1, x$13))).map((Function1 & Serializable & scala.Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Method getter = (Method)tuple2._1();
            String name = (String)tuple2._2();
            JsonProperty getterProperty = getter.getAnnotation(JsonProperty.class);
            Option setter = BeanIntrospector$.findSetter$1(cls, name);
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)getterProperty, (Object)setter);
            return tuple3;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).withFilter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$28(x$16))).map((Function1 & Serializable & scala.Serializable)x$18 -> {
            Tuple2 tuple2;
            Tuple3 tuple3 = x$18;
            if (tuple3 == null || (tuple2 = (Tuple2)tuple3._1()) == null) {
                throw new MatchError((Object)tuple3);
            }
            String name = (String)tuple2._2();
            Option beanGetter = BeanIntrospector$.findBeanGetter$1(cls, name);
            Option beanSetter = BeanIntrospector$.findBeanSetter$1(cls, name);
            Tuple3 tuple32 = new Tuple3((Object)tuple3, (Object)beanGetter, (Object)beanSetter);
            return tuple32;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).map((Function1 & Serializable & scala.Serializable)x$19 -> {
            Option setter;
            Tuple2 tuple2;
            Option beanSetter;
            Option beanGetter;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$19;
                    if (tuple3 == null) break block2;
                    Tuple3 tuple32 = (Tuple3)tuple3._1();
                    beanGetter = (Option)tuple3._2();
                    beanSetter = (Option)tuple3._3();
                    if (tuple32 == null) break block2;
                    tuple2 = (Tuple2)tuple32._1();
                    setter = (Option)tuple32._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            Method getter = (Method)tuple2._1();
            String name = (String)tuple2._2();
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, (Option<ConstructorParameter>)None$.MODULE$, (Option<Field>)None$.MODULE$, (Option<Method>)new Some((Object)getter), (Option<Method>)setter, (Option<Method>)beanGetter, (Option<Method>)beanSetter);
            return propertyDescriptor;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PropertyDescriptor.class))))), Seq$.MODULE$.canBuildFrom());
        return new BeanDescriptor(cls2, (Seq<PropertyDescriptor>)((Seq)fields.$plus$plus((GenTraversableOnce)methods, Seq$.MODULE$.canBuildFrom())));
    }

    private final Option findConstructorParam$1(Class c, String name) {
        int index;
        Option primaryConstructor;
        while (true) {
            block4: {
                block3: {
                    if (c == null) break block3;
                    Class clazz = c;
                    Class<Object> clazz2 = Object.class;
                    if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block4;
                }
                return None$.MODULE$;
            }
            primaryConstructor = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])c.getConstructors())).headOption();
            IndexedSeq debugCtorParamNames = (IndexedSeq)Option$.MODULE$.option2Iterable(primaryConstructor).toIndexedSeq().flatMap((Function1 & Serializable & scala.Serializable)ctor -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])BeanIntrospector$.MODULE$.getCtorParams(ctor))), IndexedSeq$.MODULE$.canBuildFrom());
            index = debugCtorParamNames.indexOf((Object)name);
            if (index >= 0) break;
            c = c.getSuperclass();
        }
        return new Some((Object)new ConstructorParameter((Constructor)primaryConstructor.get(), index, (Option<Method>)None$.MODULE$));
    }

    private final List next$1(Class c, List acc) {
        while (c != null) {
            Class clazz = c;
            Class<Object> clazz2 = Object.class;
            if (clazz == null) {
                if (clazz2 == null) break;
            } else if (clazz.equals(clazz2)) break;
            acc = (List)acc.$colon$plus((Object)c, List$.MODULE$.canBuildFrom());
            c = c.getSuperclass();
        }
        return acc;
    }

    private static final Stream listMethods$1(Class cls) {
        Stream stream;
        Class clazz = cls;
        if (clazz == null) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            Class clazz2 = clazz;
            Class<Object> clazz3 = Object.class;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                stream = package$.MODULE$.Stream().empty();
            } else {
                Stream stream2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clazz.getDeclaredMethods())).toStream();
                stream = Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> BeanIntrospector$.listMethods$1(clazz.getSuperclass())).$hash$colon$colon$colon(stream2);
            }
        }
        return stream;
    }

    private static final boolean isNotSyntheticOrBridge$1(Method m3) {
        return !m3.isBridge() && !m3.isSynthetic();
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(String name$1, Method m3) {
        String string = NameTransformer$.MODULE$.decode(m3.getName());
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Seq findMethod$1(Class cls, String name) {
        return (Seq)((TraversableLike)BeanIntrospector$.listMethods$1(cls).filter((Function1 & Serializable & scala.Serializable)m3 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isNotSyntheticOrBridge$1(m3)))).filter((Function1 & Serializable & scala.Serializable)m3 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$4(name, m3)));
    }

    private static final Stream listFields$1(Class cls) {
        Stream stream;
        Class clazz = cls;
        if (clazz == null) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            Class clazz2 = clazz;
            Class<Object> clazz3 = Object.class;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                stream = package$.MODULE$.Stream().empty();
            } else {
                Stream stream2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clazz.getDeclaredFields())).toStream();
                stream = Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> BeanIntrospector$.listFields$1(clazz.getSuperclass())).$hash$colon$colon$colon(stream2);
            }
        }
        return stream;
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(Field x$3) {
        return !x$3.isSynthetic();
    }

    public static final /* synthetic */ boolean $anonfun$apply$7(String fieldName$1, Field f) {
        String string = NameTransformer$.MODULE$.decode(f.getName());
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Option findField$1(Class cls, String fieldName) {
        return Option$.MODULE$.option2Iterable(((LinearSeqOptimized)BeanIntrospector$.listFields$1(cls).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$6(x$3)))).find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$7(fieldName, f)))).headOption();
    }

    private static final boolean isAcceptableField$1(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isVolatile(modifiers) && !Modifier.isTransient(modifiers) && !field.isSynthetic();
    }

    private static final boolean isAcceptableMethod$1(Method method) {
        return !Modifier.isStatic(method.getModifiers()) && BeanIntrospector$.isNotSyntheticOrBridge$1(method);
    }

    private static final Option findGetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, propertyName).find((Function1 & Serializable & scala.Serializable)m3 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isAcceptableGetter$1(m3)));
    }

    private static final Option findBeanGetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, new StringBuilder(3).append("get").append(new StringOps(Predef$.MODULE$.augmentString(propertyName)).capitalize()).toString()).find((Function1 & Serializable & scala.Serializable)m3 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isAcceptableGetter$1(m3)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAcceptableGetter$1(Method m3) {
        if (!BeanIntrospector$.isAcceptableMethod$1(m3)) return false;
        if (m3.getParameterTypes().length != 0) return false;
        Class<?> clazz = m3.getReturnType();
        Class<Void> clazz2 = Void.TYPE;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    private static final Option findSetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, new StringBuilder(2).append(propertyName).append("_=").toString()).find((Function1 & Serializable & scala.Serializable)m3 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isAcceptableSetter$1(m3)));
    }

    private static final Option findBeanSetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, new StringBuilder(3).append("set").append(new StringOps(Predef$.MODULE$.augmentString(propertyName)).capitalize()).toString()).find((Function1 & Serializable & scala.Serializable)m3 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isAcceptableSetter$1(m3)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAcceptableSetter$1(Method m3) {
        if (!BeanIntrospector$.isAcceptableMethod$1(m3)) return false;
        if (m3.getParameterTypes().length != 1) return false;
        Class<?> clazz = m3.getReturnType();
        Class<Void> clazz2 = Void.TYPE;
        if (clazz != null) {
            if (!clazz.equals(clazz2)) return false;
            return true;
        }
        if (clazz2 == null) return true;
        return false;
    }

    private static final String maybePrivateName$1(Field field, Regex privateRegex$1) {
        None$ none$;
        String definedName = NameTransformer$.MODULE$.decode(field.getName());
        try {
            none$ = Option$.MODULE$.apply((Object)field.getDeclaringClass().getCanonicalName());
        }
        catch (InternalError e) {
            none$ = None$.MODULE$;
        }
        None$ canonicalName = none$;
        return (String)canonicalName.flatMap((Function1 & Serializable & scala.Serializable)cn -> {
            String PrivateName = cn.replace('.', '$');
            String string = definedName;
            Option option2 = privateRegex$1.unapplySeq((CharSequence)string);
            if (option2.isEmpty()) return None$.MODULE$;
            if (option2.get() == null) return None$.MODULE$;
            if (((LinearSeqOptimized)option2.get()).lengthCompare(2) != 0) return None$.MODULE$;
            String string2 = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String rest = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String string3 = PrivateName;
            String string4 = string2;
            if (string3 != null) {
                if (!string3.equals(string4)) return None$.MODULE$;
                return new Some((Object)rest);
            }
            if (string4 == null) return new Some((Object)rest);
            return None$.MODULE$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> definedName);
    }

    private final boolean isScalaCaseObject$1(Class cls) {
        return this.productClass().isAssignableFrom(cls) && cls.getName().endsWith("$");
    }

    public static final /* synthetic */ boolean $anonfun$apply$16(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = !new StringOps(Predef$.MODULE$.augmentString(name)).contains((Object)BoxesRunTime.boxToCharacter((char)'$'));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$17(BeanIntrospector$ $this, Class cls$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Field field = (Field)tuple2._1();
        boolean bl = $this.isScalaCaseObject$1(cls$1) || BeanIntrospector$.isAcceptableField$1(field);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$22(Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Method getter = (Method)tuple2._1();
        boolean bl = BeanIntrospector$.isAcceptableGetter$1(getter);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$23(Class cls$2, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = BeanIntrospector$.findField$1(cls$2, name).isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$24(Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = !new StringOps(Predef$.MODULE$.augmentString(name)).contains((Object)BoxesRunTime.boxToCharacter((char)'$'));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$26(String name$2, PropertyDescriptor x$9) {
        String string = x$9.name();
        String string2 = name$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$25(Seq fields$1, Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = !fields$1.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$26(name, x$9)));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$apply$28(Tuple3 x$16) {
        Tuple3 tuple3 = x$16;
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        Tuple2 tuple2 = (Tuple2)tuple3._1();
        JsonProperty getterProperty = (JsonProperty)tuple3._2();
        Option setter = (Option)tuple3._3();
        if (tuple2 == null) throw new MatchError((Object)tuple3);
        if (setter.isDefined()) return true;
        if (getterProperty == null) return false;
        String string = getterProperty.value();
        String string2 = "";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    private BeanIntrospector$() {
        MODULE$ = this;
        this.paranamer = new CachingParanamer(new BytecodeReadingParanamer());
        this.productClass = Product.class;
    }

    public static final /* synthetic */ Object $anonfun$apply$14$adapted(BeanIntrospector$ $this, Seq hierarchy$1, Regex privateRegex$1, Class cls) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredFields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String name = BeanIntrospector$.maybePrivateName$1(field, privateRegex$1);
            return new Tuple2(field, (Object)name);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$16(x$4))).withFilter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$17($this, cls, x$5))).map((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._2();
            Option beanGetter = BeanIntrospector$.findBeanGetter$1(cls, name);
            Option beanSetter = BeanIntrospector$.findBeanSetter$1(cls, name);
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)beanGetter, (Object)beanSetter);
            return tuple3;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            Option beanSetter;
            Option beanGetter;
            Tuple2 tuple2;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$8;
                    if (tuple3 == null) break block2;
                    tuple2 = (Tuple2)tuple3._1();
                    beanGetter = (Option)tuple3._2();
                    beanSetter = (Option)tuple3._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            Field field = (Field)tuple2._1();
            String name = (String)tuple2._2();
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, (Option<ConstructorParameter>)$this.findConstructorParam$1((Class)hierarchy$1.head(), name), (Option<Field>)new Some((Object)field), (Option<Method>)BeanIntrospector$.findGetter$1(cls, name), (Option<Method>)BeanIntrospector$.findSetter$1(cls, name), (Option<Method>)beanGetter, (Option<Method>)beanSetter);
            return propertyDescriptor;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PropertyDescriptor.class)))));
    }
}

