/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.treasuredata.client.TDHttpMethod;
import com.treasuredata.spark.thirdparty.com.google.common.base.Optional;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.base.Throwables;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableMap;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableMultimap;
import com.treasuredata.spark.thirdparty.com.google.common.collect.Multimap;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDApiRequest {
    private static Logger logger = LoggerFactory.getLogger(TDApiRequest.class);
    private final TDHttpMethod method;
    private final String path;
    private final Map<String, String> queryParams;
    private final Multimap<String, String> headerParams;
    private final Optional<String> postJson;
    private final Optional<File> putFile;
    private final Optional<byte[]> content;
    private final Optional<Boolean> followRedirects;
    private final int contentOffset;
    private final int contentLength;

    TDApiRequest(TDHttpMethod method, String path, Map<String, String> queryParams, Multimap<String, String> headerParams, Optional<String> postJson, Optional<File> putFile, Optional<byte[]> content, int contentOffset, int contentLength, Optional<Boolean> followRedirects) {
        this.method = Preconditions.checkNotNull(method, "method is null");
        this.path = Preconditions.checkNotNull(path, "uri is null");
        this.queryParams = Preconditions.checkNotNull(queryParams, "queryParms is null");
        this.headerParams = Preconditions.checkNotNull(headerParams, "headerParams is null");
        this.postJson = Preconditions.checkNotNull(postJson, "postJson is null");
        this.putFile = Preconditions.checkNotNull(putFile, "putFile is null");
        this.content = Preconditions.checkNotNull(content, "content is null");
        this.contentOffset = contentOffset;
        this.contentLength = contentLength;
        this.followRedirects = Preconditions.checkNotNull(followRedirects, "followRedirects is null");
    }

    public TDApiRequest withUri(String uri) {
        return new TDApiRequest(this.method, uri, ImmutableMap.copyOf(this.queryParams), ImmutableMultimap.copyOf(this.headerParams), this.postJson, this.putFile, this.content, this.contentOffset, this.contentLength, this.followRedirects);
    }

    public String getPath() {
        return this.path;
    }

    public TDHttpMethod getMethod() {
        return this.method;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Multimap<String, String> getHeaderParams() {
        return this.headerParams;
    }

    public Optional<String> getPostJson() {
        return this.postJson;
    }

    public Optional<File> getPutFile() {
        return this.putFile;
    }

    public Optional<byte[]> getContent() {
        return this.content;
    }

    public int getContentOffset() {
        return this.contentOffset;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Optional<Boolean> getFollowRedirects() {
        return this.followRedirects;
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate(e);
        }
    }

    public static class Builder {
        private static final Map<String, String> EMPTY_MAP = ImmutableMap.of();
        private static final Multimap<String, String> EMPTY_HEADERS = ImmutableMultimap.of();
        private TDHttpMethod method;
        private String path;
        private Map<String, String> queryParams;
        private ImmutableMultimap.Builder<String, String> headerParams;
        private Optional<String> postJson = Optional.absent();
        private Optional<File> file = Optional.absent();
        private Optional<byte[]> content = Optional.absent();
        private int contentOffset;
        private int contentLength;
        private Optional<Boolean> followRedirects = Optional.absent();

        Builder(TDHttpMethod method, String path) {
            this.method = method;
            this.path = path;
        }

        public static Builder GET(String uri) {
            return new Builder(TDHttpMethod.GET, uri);
        }

        public static Builder POST(String uri) {
            return new Builder(TDHttpMethod.POST, uri);
        }

        public static Builder PUT(String uri) {
            return new Builder(TDHttpMethod.PUT, uri);
        }

        public static Builder DELETE(String uri) {
            return new Builder(TDHttpMethod.DELETE, uri);
        }

        public Builder addHeader(String key, String value) {
            if (this.headerParams == null) {
                this.headerParams = ImmutableMultimap.builder();
            }
            this.headerParams.put(key, value);
            return this;
        }

        public Builder addHeaders(Multimap<String, String> headers) {
            if (this.headerParams == null) {
                this.headerParams = ImmutableMultimap.builder();
            }
            this.headerParams.putAll(headers);
            return this;
        }

        public Builder addQueryParam(String key, String value) {
            if (this.queryParams == null) {
                this.queryParams = new HashMap<String, String>();
            }
            this.queryParams.put(key, value);
            return this;
        }

        public Builder setPostJson(String json) {
            this.postJson = Optional.of(json);
            return this;
        }

        public Builder setFile(File file) {
            this.file = Optional.of(file);
            return this;
        }

        public Builder setContent(byte[] content, int offset, int length) {
            this.content = Optional.of(content);
            this.contentOffset = offset;
            this.contentLength = length;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = Optional.of(followRedirects);
            return this;
        }

        public TDApiRequest build() {
            return new TDApiRequest(this.method, this.path, this.queryParams != null ? this.queryParams : EMPTY_MAP, this.headerParams != null ? this.headerParams.build() : EMPTY_HEADERS, this.postJson, this.file, this.content, this.contentOffset, this.contentLength, this.followRedirects);
        }
    }
}

