/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.treasuredata.client.ExponentialBackOff;
import com.treasuredata.client.HttpStatus;
import com.treasuredata.client.ProxyConfig;
import com.treasuredata.client.TDApiRequest;
import com.treasuredata.client.TDClient;
import com.treasuredata.client.TDClientConfig;
import com.treasuredata.client.TDClientException;
import com.treasuredata.client.TDClientHttpException;
import com.treasuredata.client.TDClientInterruptedException;
import com.treasuredata.client.TDHttpMethod;
import com.treasuredata.client.TDHttpRequestHandler;
import com.treasuredata.client.TDHttpRequestHandlers;
import com.treasuredata.client.impl.ProxyAuthenticator;
import com.treasuredata.client.model.JsonCollectionRootName;
import com.treasuredata.spark.thirdparty.com.google.common.annotations.VisibleForTesting;
import com.treasuredata.spark.thirdparty.com.google.common.base.Function;
import com.treasuredata.spark.thirdparty.com.google.common.base.Joiner;
import com.treasuredata.spark.thirdparty.com.google.common.base.Optional;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableMultimap;
import com.treasuredata.spark.thirdparty.com.google.common.collect.Multimap;
import com.treasuredata.spark.thirdparty.okhttp3.ConnectionPool;
import com.treasuredata.spark.thirdparty.okhttp3.MediaType;
import com.treasuredata.spark.thirdparty.okhttp3.OkHttpClient;
import com.treasuredata.spark.thirdparty.okhttp3.Request;
import com.treasuredata.spark.thirdparty.okhttp3.RequestBody;
import com.treasuredata.spark.thirdparty.okhttp3.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDHttpClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TDHttpClient.class);
    static ObjectMapper defaultObjectMapper = new ObjectMapper().registerModule((Module)new JsonOrgModule()).registerModule((Module)new GuavaModule()).configure(DeserializationFeature.UNWRAP_ROOT_VALUE, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Pattern NAKED_TD1_KEY_PATTERN = Pattern.compile("^(?:[1-9][0-9]*/)?[a-f0-9]{40}$");
    protected final TDClientConfig config;
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;
    @VisibleForTesting
    final Multimap<String, String> headers;
    private static final ThreadLocal<SimpleDateFormat> RFC2822_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        }
    };
    private static MediaType mediaTypeJson = MediaType.parse("application/json");
    private static MediaType mediaTypeXwwwFormUrlencoded = MediaType.parse("application/x-www-form-urlencoded");
    private static MediaType mediaTypeOctetStream = MediaType.parse("application/octet-stream");

    public TDHttpClient(TDClientConfig config) {
        this.config = config;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(config.connectTimeoutMillis, TimeUnit.MILLISECONDS);
        builder.readTimeout(config.readTimeoutMillis, TimeUnit.MILLISECONDS);
        if (config.proxy.isPresent()) {
            ProxyConfig proxyConfig = config.proxy.get();
            logger.trace("proxy configuration: " + proxyConfig);
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort())));
            if (proxyConfig.requireAuthentication()) {
                builder.proxyAuthenticator(new ProxyAuthenticator(proxyConfig));
            }
        }
        ConnectionPool connectionPool = new ConnectionPool(config.connectionPoolSize, 5L, TimeUnit.MINUTES);
        builder.connectionPool(connectionPool);
        this.httpClient = builder.build();
        this.headers = ImmutableMultimap.copyOf(config.headers);
        this.objectMapper = defaultObjectMapper;
    }

    protected TDHttpClient(TDHttpClient reference) {
        this(reference.config, reference.httpClient, reference.objectMapper, reference.headers);
    }

    private TDHttpClient(TDClientConfig config, OkHttpClient httpClient, ObjectMapper objectMapper, Multimap<String, String> headers) {
        this.config = config;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.headers = headers;
    }

    public TDHttpClient withHeaders(Multimap<String, String> headers) {
        ImmutableMultimap<String, String> mergedHeaders = ImmutableMultimap.builder().putAll(this.headers).putAll(headers).build();
        return new TDHttpClient(this.config, this.httpClient, this.objectMapper, mergedHeaders);
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    protected Request.Builder setTDAuthHeaders(Request.Builder request, String dateHeader) {
        return request;
    }

    protected String getClientName() {
        return "td-client-java " + TDClient.getVersion();
    }

    public Request prepareRequest(TDApiRequest apiRequest, Optional<String> apiKeyCache) {
        String requestUri;
        String queryStr = "";
        String portStr = this.config.port.transform(new Function<Integer, String>(){

            @Override
            public String apply(Integer input) {
                return ":" + input.toString();
            }
        }).or("");
        String string = apiRequest.getPath().startsWith("http") ? apiRequest.getPath() : (requestUri = String.format("%s://%s%s%s", this.config.useSSL ? "https" : "http", this.config.endpoint, portStr, apiRequest.getPath()));
        if (!apiRequest.getQueryParams().isEmpty()) {
            ArrayList<String> queryParamList = new ArrayList<String>(apiRequest.getQueryParams().size());
            for (Map.Entry<String, String> queryParam : apiRequest.getQueryParams().entrySet()) {
                queryParamList.add(String.format("%s=%s", TDApiRequest.urlEncode(queryParam.getKey()), TDApiRequest.urlEncode(queryParam.getValue())));
            }
            queryStr = Joiner.on("&").join(queryParamList);
            if (apiRequest.getMethod() == TDHttpMethod.GET || apiRequest.getMethod() == TDHttpMethod.POST && apiRequest.getPostJson().isPresent()) {
                requestUri = requestUri + "?" + queryStr;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sending API request to {}", (Object)requestUri);
        }
        String dateHeader = RFC2822_FORMAT.get().format(new Date());
        String userAgent = this.getClientName();
        Iterator<String> i = this.headers.get("User-Agent").iterator();
        while (i.hasNext()) {
            userAgent = userAgent + "," + i.next();
        }
        Request.Builder request = new Request.Builder().url(requestUri).header("User-Agent", userAgent).header("Date", dateHeader);
        request = this.setTDAuthHeaders(request, dateHeader);
        for (Map.Entry<String, String> entry : this.headers.entries()) {
            if (entry.getKey().equals("User-Agent")) continue;
            request = request.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : apiRequest.getHeaderParams().entries()) {
            request = request.addHeader(entry.getKey(), entry.getValue());
        }
        Optional<String> apiKey = apiKeyCache.or(this.config.apiKey);
        if (apiKey.isPresent()) {
            String auth = TDHttpClient.isNakedTD1Key(apiKey.get()) ? "TD1 " + apiKey.get() : apiKey.get();
            request = request.header("Authorization", auth);
        }
        switch (apiRequest.getMethod()) {
            case GET: {
                request = request.get();
                break;
            }
            case DELETE: {
                request = request.delete();
                break;
            }
            case POST: {
                if (apiRequest.getPostJson().isPresent()) {
                    request = request.post(TDHttpClient.createRequestBodyWithoutCharset(mediaTypeJson, apiRequest.getPostJson().get()));
                    break;
                }
                if (queryStr.length() > 0) {
                    request = request.post(TDHttpClient.createRequestBodyWithoutCharset(mediaTypeXwwwFormUrlencoded, queryStr));
                    break;
                }
                request = request.header("Content-Length", "0").post(RequestBody.create(null, ""));
                break;
            }
            case PUT: {
                if (apiRequest.getPutFile().isPresent()) {
                    try {
                        request = request.put(RequestBody.create(mediaTypeOctetStream, apiRequest.getPutFile().get()));
                        break;
                    }
                    catch (NullPointerException e) {
                        throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, "Failed to read input file: " + apiRequest.getPutFile().get());
                    }
                }
                if (apiRequest.getContent().isPresent()) {
                    try {
                        request = request.put(RequestBody.create(mediaTypeOctetStream, apiRequest.getContent().get(), apiRequest.getContentOffset(), apiRequest.getContentLength()));
                        break;
                    }
                    catch (Throwable e) {
                        throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, "Failed to get Content");
                    }
                }
                request = queryStr.length() > 0 ? request.put(TDHttpClient.createRequestBodyWithoutCharset(mediaTypeXwwwFormUrlencoded, queryStr)) : request.header("Content-Length", "0").put(RequestBody.create(null, ""));
            }
        }
        return request.build();
    }

    private static RequestBody createRequestBodyWithoutCharset(MediaType contentType, String content) {
        Charset charset = StandardCharsets.UTF_8;
        if (contentType != null && (charset = contentType.charset()) == null) {
            charset = StandardCharsets.UTF_8;
        }
        byte[] bytes = content.getBytes(charset);
        return RequestBody.create(contentType, bytes);
    }

    private static boolean isNakedTD1Key(String s2) {
        return NAKED_TD1_KEY_PATTERN.matcher(s2).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <Result> Result submitRequest(RequestContext context, TDHttpRequestHandler<Result> handler) throws TDClientException, InterruptedException {
        int executionCount = context.backoff.getExecutionCount();
        if (executionCount > this.config.retryLimit) {
            logger.warn("API request retry limit exceeded: ({}/{})", (Object)this.config.retryLimit, (Object)this.config.retryLimit);
            Preconditions.checkState(context.rootCause.isPresent(), "rootCause must be present here");
            throw context.rootCause.get();
        }
        if (executionCount == 0) {
            context.backoff.incrementExecutionCount();
        } else {
            long waitTimeMillis = this.calculateWaitTimeMillis(context.backoff.nextWaitTimeMillis(), context.rootCause);
            logger.warn(String.format("Retrying request to %s (%d/%d) in %.2f sec.", context.apiRequest.getPath(), executionCount, this.config.retryLimit, (double)waitTimeMillis / 1000.0));
            Thread.sleep(waitTimeMillis);
        }
        try {
            Request request = this.prepareRequest(context.apiRequest, context.apiKeyCache);
            request = handler.prepareRequest(request);
            try (Response response = handler.send(this.httpClient, request);){
                String location;
                int code = response.code();
                if ((code == 307 || code == 308) && (location = response.header("Location")) != null) {
                    context = context.withTDApiRequest(context.apiRequest.withUri(location));
                    Result Result2 = this.submitRequest(context, handler);
                    return Result2;
                }
                TDHttpRequestHandler.ResponseContext responseContext = new TDHttpRequestHandler.ResponseContext(context.apiRequest, response);
                if (handler.isSuccess(responseContext)) {
                    logger.debug(String.format("[%d:%s] API request to %s has succeeded", code, HttpStatus.getMessage(code), context.apiRequest.getPath()));
                    Result Result3 = handler.onSuccess(response);
                    return Result3;
                }
                context = context.withRootCause(handler.resolveHttpResponseError(responseContext));
                return this.submitRequest(context, handler);
            }
        }
        catch (Exception e) {
            if (!TDClientHttpException.class.isAssignableFrom(e.getClass())) {
                logger.warn(String.format("API request to %s failed: %s, cause: %s", context.apiRequest.getPath(), e.getClass(), e.getCause() == null ? e.getMessage() : e.getCause().getClass()), e);
            }
            context = context.withRootCause(handler.resolveError(e));
        }
        return this.submitRequest(context, handler);
    }

    private long calculateWaitTimeMillis(long nextWaitTimeMillis, Optional<TDClientException> rootCause) {
        TDClientHttpException httpException;
        Optional<Date> retryAfter;
        if (rootCause.isPresent() && rootCause.get() instanceof TDClientHttpException && (retryAfter = (httpException = (TDClientHttpException)rootCause.get()).getRetryAfter()).isPresent()) {
            long maxWaitMillis = this.config.retryLimit * this.config.retryMaxIntervalMillis;
            long now = System.currentTimeMillis();
            long retryAfterMillis = retryAfter.get().getTime() - now;
            if (retryAfterMillis > maxWaitMillis) {
                throw httpException;
            }
            nextWaitTimeMillis = Math.max(nextWaitTimeMillis, retryAfterMillis);
        }
        return nextWaitTimeMillis;
    }

    public <Result> Result submitRequest(TDApiRequest apiRequest, Optional<String> apiKeyCache, TDHttpRequestHandler<Result> handler) throws TDClientException {
        RequestContext requestContext = new RequestContext(this.config, apiRequest, apiKeyCache);
        try {
            return this.submitRequest(requestContext, handler);
        }
        catch (InterruptedException e) {
            logger.warn("API request interrupted", e);
            throw new TDClientInterruptedException(e);
        }
        catch (TDClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_JSON_RESPONSE, e);
        }
    }

    public String call(TDApiRequest apiRequest, Optional<String> apiKeyCache) {
        String content = this.submitRequest(apiRequest, apiKeyCache, TDHttpRequestHandlers.stringContentHandler);
        if (logger.isTraceEnabled()) {
            logger.trace("response:\n{}", (Object)content);
        }
        return content;
    }

    public <Result> Result call(TDApiRequest apiRequest, Optional<String> apiKeyCache, Function<InputStream, Result> contentStreamHandler) {
        return this.submitRequest(apiRequest, apiKeyCache, TDHttpRequestHandlers.newByteStreamHandler(contentStreamHandler));
    }

    public <Result> Result call(TDApiRequest apiRequest, Optional<String> apiKeyCache, Class<Result> resultType) throws TDClientException {
        return this.call(apiRequest, apiKeyCache, this.objectMapper.getTypeFactory().constructType(resultType));
    }

    public <Result> Result call(TDApiRequest apiRequest, Optional<String> apiKeyCache, TypeReference<Result> resultType) throws TDClientException {
        return this.call(apiRequest, apiKeyCache, this.objectMapper.getTypeFactory().constructType(resultType));
    }

    public <Result> Result call(TDApiRequest apiRequest, Optional<String> apiKeyCache, JavaType resultType) throws TDClientException {
        try {
            byte[] content = this.submitRequest(apiRequest, apiKeyCache, TDHttpRequestHandlers.byteArrayContentHandler);
            if (logger.isTraceEnabled()) {
                logger.trace("response:\n{}", (Object)new String(content, StandardCharsets.UTF_8));
            }
            if (resultType.getRawClass() == String.class) {
                return (Result)new String(content, StandardCharsets.UTF_8);
            }
            return (Result)this.getJsonReader(resultType).readValue(content);
        }
        catch (JsonMappingException e) {
            logger.error("Jackson mapping error", e);
            throw new TDClientException(TDClientException.ErrorType.INVALID_JSON_RESPONSE, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_JSON_RESPONSE, e);
        }
    }

    private ObjectReader getJsonReader(JavaType type) {
        ObjectReader reader = this.objectMapper.readerFor(type);
        if (type.getContentType() != null) {
            JsonCollectionRootName rootName = type.getContentType().getRawClass().getAnnotation(JsonCollectionRootName.class);
            if (rootName != null) {
                reader = reader.withRootName(rootName.value());
            }
        } else {
            JsonRootName rootName = type.getRawClass().getAnnotation(JsonRootName.class);
            if (rootName != null) {
                reader = reader.withRootName(rootName.value());
            }
        }
        return reader;
    }

    protected static class RequestContext {
        private final ExponentialBackOff backoff;
        public final TDApiRequest apiRequest;
        public final Optional<String> apiKeyCache;
        public final Optional<TDClientException> rootCause;

        public RequestContext(TDClientConfig config, TDApiRequest apiRequest, Optional<String> apiKeyCache) {
            this(new ExponentialBackOff(config.retryInitialIntervalMillis, config.retryMaxIntervalMillis, config.retryMultiplier), apiRequest, apiKeyCache, Optional.absent());
        }

        public RequestContext(ExponentialBackOff backoff, TDApiRequest apiRequest, Optional<String> apiKeyCache, Optional<TDClientException> rootCause) {
            this.backoff = backoff;
            this.apiRequest = apiRequest;
            this.apiKeyCache = apiKeyCache;
            this.rootCause = rootCause;
        }

        public RequestContext withTDApiRequest(TDApiRequest newApiRequest) {
            return new RequestContext(this.backoff, newApiRequest, this.apiKeyCache, this.rootCause);
        }

        public RequestContext withRootCause(TDClientException e) {
            return new RequestContext(this.backoff, this.apiRequest, this.apiKeyCache, Optional.of(e));
        }
    }
}

