/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.bucket;

import com.treasuredata.partition.bucket.BucketColumnType;
import com.treasuredata.partition.bucket.BucketRow;
import com.treasuredata.partition.bucket.RowBucketFunction;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.util.List;

public class RowHashBucketFunction
implements RowBucketFunction {
    private final HashFunction[] functions;
    private final int bucketCount;

    public RowHashBucketFunction(int n, List<BucketColumnType> list) {
        if (n <= 0) {
            throw new IllegalArgumentException("bucketCount must be at least one");
        }
        this.bucketCount = n;
        this.functions = new HashFunction[list.size()];
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i] = RowHashBucketFunction.getHashFunction(list.get(i));
        }
    }

    private static HashFunction getHashFunction(BucketColumnType bucketColumnType) {
        switch (bucketColumnType) {
            case INTEGER: {
                return RowHashBucketFunction.longHashFunction();
            }
            case STRING: {
                return RowHashBucketFunction.bytesHashFunction();
            }
            case STRING_SLICE: {
                return RowHashBucketFunction.sliceHashFunction();
            }
        }
        throw new UnsupportedOperationException("Bucketing is supported for integer and string type " + (Object)((Object)bucketColumnType));
    }

    @Override
    public int getBucket(BucketRow bucketRow, int[] nArray) {
        int n;
        if (this.functions.length != nArray.length) {
            throw new RuntimeException(String.format("Column count (%s) does not match the number of hash function (%s).", nArray.length, this.functions.length));
        }
        long l = 0L;
        for (n = 0; n < nArray.length; ++n) {
            long l2 = this.functions[n].hash(bucketRow, nArray[n]);
            l = l * 31L + l2;
        }
        n = (int)(l & Integer.MAX_VALUE);
        return n % this.bucketCount;
    }

    private static HashFunction longHashFunction() {
        return (bucketRow, n) -> bucketRow.isNull(n) ? 0L : XxHash64.hash(bucketRow.getLong(n));
    }

    private static HashFunction bytesHashFunction() {
        return (bucketRow, n) -> bucketRow.isNull(n) ? 0L : XxHash64.hash(Slices.wrappedBuffer(bucketRow.getBytes(n), 0, bucketRow.getBytes(n).length));
    }

    private static HashFunction sliceHashFunction() {
        return (bucketRow, n) -> bucketRow.isNull(n) ? 0L : XxHash64.hash(bucketRow.getSlice(n));
    }

    private static interface HashFunction {
        public long hash(BucketRow var1, int var2);
    }
}

