/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io;

public class RetryContext {
    private final int retryCount;
    private final int maxRetry;
    private final boolean skippable;
    private final boolean slowDown;

    public RetryContext() {
        this(0, -1, false, false);
    }

    public RetryContext(int n, int n2, boolean bl, boolean bl2) {
        this.retryCount = n;
        this.maxRetry = n2;
        this.skippable = bl;
        this.slowDown = bl2;
    }

    public RetryContext(RetryContext retryContext) {
        this.retryCount = retryContext.retryCount;
        this.maxRetry = retryContext.maxRetry;
        this.skippable = retryContext.skippable;
        this.slowDown = retryContext.slowDown;
    }

    public RetryContext retry() {
        return new RetryContext(this.retryCount + 1, this.maxRetry, this.skippable, this.slowDown);
    }

    public RetryContext reset(boolean bl) {
        if (bl) {
            return new RetryContext(this.retryCount, this.maxRetry + this.retryCount, this.skippable, this.slowDown);
        }
        return this;
    }

    public RetryContext skippable(int n, boolean bl) {
        return new RetryContext(this.retryCount, this.maxRetry > n ? this.maxRetry : n, this.skippable || bl, this.slowDown);
    }

    public RetryContext slowDown(boolean bl) {
        return new RetryContext(this.retryCount, this.maxRetry, this.skippable, bl);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean isSkippable() {
        return this.skippable;
    }

    public boolean isLimitExceeds() {
        return this.retryCount >= this.maxRetry;
    }

    public boolean isSlowDown() {
        return this.slowDown;
    }
}

