/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc;

import com.treasuredata.partition.mpc.writer.BlockBuilder;
import java.io.File;
import java.util.Comparator;
import org.msgpack.value.Value;

public class Column {
    private Value name;
    private int colIndex;
    private File file;
    private BlockBuilder builder;
    private long counter;

    private static void validateNameValue(Value value) {
        if (value == null || value.isNilValue()) {
            throw new NullPointerException("name is null or NilValue object");
        }
    }

    private static void validateColIndex(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(String.format("colIndex: %d", n));
        }
    }

    public Column(Value value, int n) {
        Column.validateNameValue(value);
        Column.validateColIndex(n);
        this.name = value;
        this.colIndex = n;
    }

    public Value getName() {
        return this.name;
    }

    public int getIndex() {
        return this.colIndex;
    }

    public void setBuilder(File file, BlockBuilder blockBuilder) {
        this.file = file;
        this.builder = blockBuilder;
    }

    public BlockBuilder getBuilder() {
        return this.builder;
    }

    public boolean builderIsSet() {
        return this.builder != null;
    }

    public File getFile() {
        return this.file;
    }

    public void incrementCounter() {
        ++this.counter;
    }

    public long getCounter() {
        return this.counter;
    }

    public static class FileSizeComparator
    implements Comparator<Column> {
        @Override
        public int compare(Column column, Column column2) {
            long l;
            long l2 = this.getFileLength(column);
            if (l2 == (l = this.getFileLength(column2))) {
                return 0;
            }
            if (l2 < l) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Column column, Column column2) {
            long l;
            long l2 = this.getFileLength(column);
            return l2 == (l = this.getFileLength(column2));
        }

        private long getFileLength(Column column) {
            long l = column.getFile() == null ? -1L : column.getFile().length();
            return l;
        }
    }
}

