/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc;

import com.treasuredata.partition.mpc.CompressionType;
import com.treasuredata.partition.mpc.Packable;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public class SimpleBlockData
implements Packable {
    private final CompressionType compressionType;

    public SimpleBlockData(CompressionType compressionType) {
        this.compressionType = Preconditions.checkNotNull(compressionType, "compressionType is null");
    }

    public CompressionType getCompressionCodec() {
        return this.compressionType;
    }

    @Override
    public void packTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packArrayHeader(1);
        if (this.compressionType == CompressionType.NONE) {
            messagePacker.packNil();
        } else {
            messagePacker.packString(this.compressionType.getCode());
        }
    }

    public static SimpleBlockData readFrom(MessageUnpacker messageUnpacker) throws IOException {
        return SimpleBlockData.readFrom(messageUnpacker.unpackValue());
    }

    public static SimpleBlockData readFrom(Value value) throws IOException {
        ArrayValue arrayValue = value.asArrayValue();
        if (arrayValue.size() != 1) {
            throw new IOException("invalid SimpleBlockData format: " + arrayValue.toString());
        }
        Value value2 = arrayValue.get(0);
        if (value2.isNilValue()) {
            return new SimpleBlockData(CompressionType.NONE);
        }
        return new SimpleBlockData(CompressionType.getType(value2.asStringValue().toString()));
    }
}

