/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.buffer;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.BufferAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

public class AligningCachedBufferAllocator
implements BufferAllocator {
    protected BufferAllocator parentAllocator;
    private final int alignSize;
    private final Deque<AlignedBuffer> cache;

    public AligningCachedBufferAllocator(BufferAllocator bufferAllocator, int n) {
        this.parentAllocator = bufferAllocator;
        this.alignSize = n;
        this.cache = new ArrayDeque<AlignedBuffer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer allocate(int n) {
        if (n > this.alignSize) {
            return this.parentAllocator.allocate(n);
        }
        Deque<AlignedBuffer> deque = this.cache;
        synchronized (deque) {
            AlignedBuffer alignedBuffer = this.cache.pollLast();
            if (alignedBuffer != null) {
                alignedBuffer.reset(n);
                return alignedBuffer;
            }
        }
        return new AlignedBuffer(this.parentAllocator.allocate(this.alignSize), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(AlignedBuffer alignedBuffer) {
        Deque<AlignedBuffer> deque = this.cache;
        synchronized (deque) {
            this.cache.addLast(alignedBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Deque<AlignedBuffer> deque = this.cache;
        synchronized (deque) {
            while (!this.cache.isEmpty()) {
                this.cache.getLast().buffer.release();
                this.cache.pollLast();
            }
        }
    }

    private class AlignedBuffer
    implements Buffer {
        private Buffer buffer;
        private ByteBuffer byteBuffer;

        public AlignedBuffer(Buffer buffer, int n) {
            this.buffer = buffer;
            this.reset(n);
        }

        public void reset(int n) {
            ByteBuffer byteBuffer = this.buffer.getByteBuffer();
            byteBuffer.position(0);
            byteBuffer.limit(n);
            this.byteBuffer = byteBuffer.slice();
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        @Override
        public void release() {
            AligningCachedBufferAllocator.this.release(this);
        }
    }
}

