/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.buffer;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public abstract class BufferUtil {
    private static Method cleanerMethod = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int transferByteBuffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = byteBuffer2.position();
        int n2 = byteBuffer.remaining();
        int n3 = byteBuffer2.remaining();
        if (n3 < n2) {
            int n4 = byteBuffer.limit();
            try {
                byteBuffer.limit(byteBuffer.position() + n3);
                byteBuffer2.put(byteBuffer);
            }
            finally {
                byteBuffer.limit(n4);
            }
        } else {
            byteBuffer2.put(byteBuffer);
        }
        return byteBuffer2.position() - n;
    }

    public static void transferFile(File file, WritableByteChannel writableByteChannel) throws IOException {
        long l = file.length();
        try (FileChannel fileChannel = (FileChannel)Files.newByteChannel(file.toPath(), new OpenOption[0]);){
            long l2;
            for (long i = 0L; i < l; i += l2) {
                l2 = fileChannel.transferTo(i, l - i, writableByteChannel);
                if (l2 >= 0L) continue;
                throw new EOFException();
            }
        }
    }

    public static boolean releaseDirectBuffer(ByteBuffer byteBuffer) {
        if (cleanerMethod != null) {
            try {
                Object object = cleanerMethod.invoke((Object)byteBuffer, new Object[0]);
                object.getClass().getMethod("clean", new Class[0]).invoke(object, new Object[0]);
                return true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    static {
        try {
            cleanerMethod = Class.forName("sun.nio.ch.DirectBuffer").getMethod("cleaner", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

