/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.AbstractColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueHolder;
import java.io.IOException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;

public class BytesColumnReader
extends AbstractColumnReader {
    private final BytesHolder holder = new BytesHolder();

    public BytesColumnReader(MessageUnpacker messageUnpacker) {
        super(messageUnpacker);
    }

    @Override
    protected BytesHolder current() {
        return this.holder;
    }

    @Override
    public byte[] getByteArray() throws IOException {
        return this.holder.getOrElseUpdate().toByteArray();
    }

    @Override
    public MessageBuffer getMemoryReference() throws IOException {
        return this.holder.getOrElseUpdate();
    }

    @Override
    public Value getValue() throws IOException {
        if (this.isNull()) {
            return ValueFactory.newNil();
        }
        return ValueFactory.newBinary(this.getByteArray());
    }

    private class BytesHolder
    extends ColumnValueHolder {
        private MessageBuffer value;

        private BytesHolder() {
        }

        @Override
        protected boolean update() throws IOException {
            if (!this.isRead) {
                ValueType valueType = BytesColumnReader.this.unpacker.getNextFormat().getValueType();
                switch (valueType) {
                    case STRING: 
                    case BINARY: {
                        int n = BytesColumnReader.this.unpacker.unpackBinaryHeader();
                        this.value = BytesColumnReader.this.unpacker.readPayloadAsReference(n);
                        break;
                    }
                    case NIL: {
                        this.isValid = false;
                        BytesColumnReader.this.unpacker.skipValue();
                        break;
                    }
                    default: {
                        this.isValid = false;
                        BytesColumnReader.this.unpacker.skipValue();
                    }
                }
                this.isRead = true;
            }
            return this.isValid;
        }

        public MessageBuffer getOrElseUpdate() throws IOException {
            this.update();
            return this.value;
        }
    }
}

