/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.spark;

import com.treasuredata.client.TDClient;
import com.treasuredata.client.model.TDJob;
import com.treasuredata.client.model.TDJobSummary;
import com.treasuredata.client.model.TDResultFormat;
import com.treasuredata.spark.TDJobRelation$;
import com.treasuredata.spark.TDJobResultPartiion;
import com.treasuredata.spark.TDSparkContext;
import com.treasuredata.spark.mpc.MessagePackGZReader;
import com.treasuredata.spark.thirdparty.com.google.common.base.Function;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.TaskCompletionListener;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel$DEBUG$;
import wvlet.log.LogLevel$INFO$;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0001I4A\u0001C\u0005\u0001!!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!A\u0004A!A!\u0002\u0013I\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000bY\u0003A\u0011I,\t\u000b1\u0004A\u0011K7\u0003!Q#%j\u001c2SK2\fG/[8o%\u0012#%B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0007ue\u0016\f7/\u001e:fI\u0006$\u0018MC\u0001\u000f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011\u0003\n\t\u0004%iaR\"A\n\u000b\u0005Q)\u0012a\u0001:eI*\u0011!B\u0006\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014x-\u0003\u0002\u001c'\t\u0019!\u000b\u0012#\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0005*\u0012aA:rY&\u00111E\b\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0005\u0002&U5\taE\u0003\u0002(Q\u0005\u0019An\\4\u000b\u0003%\nQa\u001e<mKRL!a\u000b\u0014\u0003\u00151{wmU;qa>\u0014H/\u0001\u0002uIB\u0011afL\u0007\u0002\u0013%\u0011\u0001'\u0003\u0002\u000f)\u0012\u001b\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0019\u00198\r[3nCB\u00111GN\u0007\u0002i)\u0011Q\u0007I\u0001\u0006if\u0004Xm]\u0005\u0003oQ\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003\u0015QwNY%e!\tQ4I\u0004\u0002<\u0003B\u0011AhP\u0007\u0002{)\u0011ahD\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005~\na\u0001^7q\t&\u0014\bC\u0001%N\u001b\u0005I%B\u0001&L\u0003\tIwNC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%\u0001\u0002$jY\u0016\fa\u0001P5oSRtD#B)S'R+\u0006C\u0001\u0018\u0001\u0011\u0015aS\u00011\u0001.\u0011\u0015\tT\u00011\u00013\u0011\u0015AT\u00011\u0001:\u0011\u00151U\u00011\u0001H\u0003\u001d\u0019w.\u001c9vi\u0016$2\u0001W1h!\rIf\f\b\b\u00035rs!\u0001P.\n\u0003\u0001K!!X \u0002\u000fA\f7m[1hK&\u0011q\f\u0019\u0002\t\u0013R,'/\u0019;pe*\u0011Ql\u0010\u0005\u0006E\u001a\u0001\raY\u0001\u0006gBd\u0017\u000e\u001e\t\u0003I\u0016l\u0011!F\u0005\u0003MV\u0011\u0011\u0002U1si&$\u0018n\u001c8\t\u000b!4\u0001\u0019A5\u0002\u000f\r|g\u000e^3yiB\u0011AM[\u0005\u0003WV\u00111\u0002V1tW\u000e{g\u000e^3yi\u0006iq-\u001a;QCJ$\u0018\u000e^5p]N,\u0012A\u001c\t\u0004_B\u001cW\"A \n\u0005E|$!B!se\u0006L\b")
public class TDJobRelationRDD
extends RDD<InternalRow>
implements LogSupport {
    private final TDSparkContext td;
    private final StructType schema;
    private final String jobId;
    private final File tmpDir;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TDJobRelationRDD tDJobRelationRDD = this;
        synchronized (tDJobRelationRDD) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        File jobResultFile;
        TDClient tdClient = this.td.service().tdClient(this.td.overrideConfig());
        TDJobSummary jobSummary = TDJobRelation$.MODULE$.RichTDClient(tdClient).waitJobCompletion(this.jobId);
        TDJob.Status status = jobSummary.getStatus();
        if (((Object)((Object)TDJob.Status.SUCCESS)).equals((Object)status)) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.logger().isEnabled(LogLevel$INFO$.MODULE$)) {
                this.logger().log(LogLevel$INFO$.MODULE$, new LogSource("/Users/leo/work/git/td-spark/td-spark/src/main/scala/com/treasuredata/spark/TDJobRelation.scala", "TDJobRelation.scala", 171, 13), new StringBuilder(19).append("Reading job ").append(this.jobId).append(" result").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.tmpDir.mkdirs();
            jobResultFile = new File(this.tmpDir, new StringBuilder(15).append("job-").append(this.jobId).append(".msgpack.gz").toString());
            if (this.logger().isEnabled(LogLevel$DEBUG$.MODULE$)) {
                this.logger().log(LogLevel$DEBUG$.MODULE$, new LogSource("/Users/leo/work/git/td-spark/td-spark/src/main/scala/com/treasuredata/spark/TDJobRelation.scala", "TDJobRelation.scala", 174, 14), new StringBuilder(25).append("Saving the job result to ").append(jobResultFile).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            TDJob info = tdClient.jobInfo(this.jobId);
            throw new IllegalArgumentException(new StringBuilder(17).append("job ").append(this.jobId).append(" was failed:\n").append(info.getStdErr()).toString());
        }
        tdClient.jobResult(this.jobId, TDResultFormat.MESSAGE_PACK_GZ, new Function<InputStream, BoxedUnit>(null, jobResultFile){
            private final File jobResultFile$1;

            public void apply(InputStream in) {
                Files.copy(in, this.jobResultFile$1.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            {
                this.jobResultFile$1 = jobResultFile$1;
            }
        });
        MessagePackGZReader r = new MessagePackGZReader(new FileInputStream(jobResultFile), this.schema);
        context.addTaskCompletionListener(new TaskCompletionListener(null, r){
            private final MessagePackGZReader r$1;

            public void onTaskCompletion(TaskContext context) {
                this.r$1.close();
            }
            {
                this.r$1 = r$1;
            }
        });
        context.addTaskCompletionListener(new TaskCompletionListener(null, jobResultFile){
            private final File jobResultFile$1;

            public void onTaskCompletion(TaskContext context) {
                this.jobResultFile$1.delete();
            }
            {
                this.jobResultFile$1 = jobResultFile$1;
            }
        });
        MessagePackGZReader messagePackGZReader = r;
        return messagePackGZReader;
    }

    public Partition[] getPartitions() {
        return (Partition[])((Object[])new Partition[]{new TDJobResultPartiion(this.jobId)});
    }

    public TDJobRelationRDD(TDSparkContext td, StructType schema, String jobId, File tmpDir) {
        this.td = td;
        this.schema = schema;
        this.jobId = jobId;
        this.tmpDir = tmpDir;
        super(td.sqlContext().sparkContext(), (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalRow.class));
        LoggingMethods.$init$(this);
        LazyLogger.$init$(this);
    }
}

