/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.airlift.json;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import io.prestosql.jdbc.$internal.airlift.json.JsonCodec;
import io.prestosql.jdbc.$internal.airlift.json.JsonCodecProvider;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonCodecBinder {
    private final Binder binder;

    public static JsonCodecBinder jsonCodecBinder(Binder binder) {
        return new JsonCodecBinder(binder);
    }

    private JsonCodecBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(this.getClass());
    }

    public void bindJsonCodec(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        this.binder.bind(this.getJsonCodecKey(type)).toProvider(new JsonCodecProvider(type)).in(Scopes.SINGLETON);
    }

    public void bindJsonCodec(TypeLiteral<?> type) {
        Objects.requireNonNull(type, "type is null");
        this.binder.bind(this.getJsonCodecKey(type.getType())).toProvider(new JsonCodecProvider(type.getType())).in(Scopes.SINGLETON);
    }

    public void bindListJsonCodec(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        MoreTypes.ParameterizedTypeImpl listType = new MoreTypes.ParameterizedTypeImpl(null, (Type)((Object)List.class), type);
        this.binder.bind(this.getJsonCodecKey(listType)).toProvider(new JsonCodecProvider(listType)).in(Scopes.SINGLETON);
    }

    public void bindListJsonCodec(JsonCodec<?> type) {
        Objects.requireNonNull(type, "type is null");
        MoreTypes.ParameterizedTypeImpl listType = new MoreTypes.ParameterizedTypeImpl(null, (Type)((Object)List.class), type.getType());
        this.binder.bind(this.getJsonCodecKey(listType)).toProvider(new JsonCodecProvider(listType)).in(Scopes.SINGLETON);
    }

    public void bindMapJsonCodec(Class<?> keyType, Class<?> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        MoreTypes.ParameterizedTypeImpl mapType = new MoreTypes.ParameterizedTypeImpl(null, (Type)((Object)Map.class), keyType, valueType);
        this.binder.bind(this.getJsonCodecKey(mapType)).toProvider(new JsonCodecProvider(mapType)).in(Scopes.SINGLETON);
    }

    public void bindMapJsonCodec(Class<?> keyType, JsonCodec<?> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        MoreTypes.ParameterizedTypeImpl mapType = new MoreTypes.ParameterizedTypeImpl(null, (Type)((Object)Map.class), keyType, valueType.getType());
        this.binder.bind(this.getJsonCodecKey(mapType)).toProvider(new JsonCodecProvider(mapType)).in(Scopes.SINGLETON);
    }

    private Key<JsonCodec<?>> getJsonCodecKey(Type type) {
        return Key.get(new MoreTypes.ParameterizedTypeImpl(null, (Type)((Object)JsonCodec.class), type));
    }
}

