/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import io.prestosql.jdbc.$internal.guava.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

enum ClientInfoProperty {
    APPLICATION_NAME("ApplicationName"),
    CLIENT_INFO("ClientInfo"),
    CLIENT_TAGS("ClientTags"),
    TRACE_TOKEN("TraceToken");

    private static final Map<String, ClientInfoProperty> BY_NAME;
    private final String propertyName;

    private ClientInfoProperty(String propertyName) {
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName is null");
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public static Optional<ClientInfoProperty> forName(String propertyName) {
        Objects.requireNonNull(propertyName, "propertyName is null");
        return Optional.ofNullable(BY_NAME.get(propertyName));
    }

    static {
        BY_NAME = Stream.of(ClientInfoProperty.values()).collect(ImmutableMap.toImmutableMap(ClientInfoProperty::getPropertyName, Function.identity()));
    }
}

