/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.time.ZonedDateTime;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.matching.Regex;
import wvlet.airframe.metrics.TimeVector;
import wvlet.airframe.metrics.TimeWindow;
import wvlet.airframe.metrics.TimeWindow$;
import wvlet.airframe.metrics.TimeWindowUnit;
import wvlet.airframe.metrics.TimeWindowUnit$;
import wvlet.airframe.metrics.TimeWindowUnit$Day$;
import wvlet.airframe.metrics.TimeWindowUnit$Hour$;
import wvlet.airframe.metrics.TimeWindowUnit$Month$;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.TimeWindowUnit$Week$;
import wvlet.airframe.metrics.TimeWindowUnit$Year$;

public final class TimeVector$
implements Serializable {
    public static TimeVector$ MODULE$;
    private final Regex durationPattern;

    static {
        new TimeVector$();
    }

    private Regex durationPattern() {
        return this.durationPattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimeVector apply(String s2) {
        TimeVector timeVector;
        String string = s2;
        if ("thisHour".equals(string)) {
            return new TimeVector(-1L, 1L, TimeWindowUnit$Hour$.MODULE$);
        }
        if ("today".equals(string)) {
            return new TimeVector(-1L, 1L, TimeWindowUnit$Day$.MODULE$);
        }
        if ("thisWeek".equals(string)) {
            return new TimeVector(-1L, 1L, TimeWindowUnit$Week$.MODULE$);
        }
        if ("thisMonth".equals(string)) {
            return new TimeVector(-1L, 1L, TimeWindowUnit$Month$.MODULE$);
        }
        if ("thisYear".equals(string)) {
            return new TimeVector(-1L, 1L, TimeWindowUnit$Year$.MODULE$);
        }
        if ("lastHour".equals(string)) {
            return new TimeVector(-1L, 0L, TimeWindowUnit$Hour$.MODULE$);
        }
        if ("yesterday".equals(string)) {
            return new TimeVector(-1L, 0L, TimeWindowUnit$Day$.MODULE$);
        }
        if ("lastWeek".equals(string)) {
            return new TimeVector(-1L, 0L, TimeWindowUnit$Week$.MODULE$);
        }
        if ("lastMonth".equals(string)) {
            return new TimeVector(-1L, 0L, TimeWindowUnit$Month$.MODULE$);
        }
        if ("lastYear".equals(string)) {
            return new TimeVector(-1L, 0L, TimeWindowUnit$Year$.MODULE$);
        }
        if ("nextHour".equals(string)) {
            return new TimeVector(1L, 1L, TimeWindowUnit$Hour$.MODULE$);
        }
        if ("tomorrow".equals(string)) {
            return new TimeVector(1L, 1L, TimeWindowUnit$Day$.MODULE$);
        }
        if ("nextWeek".equals(string)) {
            return new TimeVector(1L, 1L, TimeWindowUnit$Week$.MODULE$);
        }
        if ("nextMonth".equals(string)) {
            return new TimeVector(1L, 1L, TimeWindowUnit$Month$.MODULE$);
        }
        if ("nextYear".equals(string)) {
            return new TimeVector(1L, 1L, TimeWindowUnit$Year$.MODULE$);
        }
        Option option2 = this.durationPattern().findFirstMatchIn((CharSequence)s2);
        if (None$.MODULE$.equals(option2)) {
            throw new IllegalArgumentException(new StringBuilder(18).append("Invalid duration: ").append(s2).toString());
        }
        if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
        Some some = (Some)option2;
        Regex.Match m3 = (Regex.Match)some.value();
        int length = new StringOps(Predef$.MODULE$.augmentString(m3.group("num"))).toInt();
        TimeWindowUnit unit = TimeWindowUnit$.MODULE$.of(m3.group("unit"));
        String string2 = m3.group("prefix");
        boolean bl = "-".equals(string2) ? true : "last".equals(string2);
        if (bl) {
            timeVector = new TimeVector(-length, 0L, unit);
        } else {
            boolean bl2 = string2 == null ? true : ("+".equals(string2) ? true : "next".equals(string2));
            if (!bl2) throw new IllegalArgumentException(new StringBuilder(25).append("Unknown duration prefix: ").append(string2).toString());
            timeVector = new TimeVector(length, 0L, unit);
        }
        TimeVector timeVector2 = timeVector;
        return timeVector2;
    }

    public TimeVector succinctTimeVector(long startUnixTime, long endUnixTime) {
        TimeWindow r = TimeWindow$.MODULE$.withUTC().fromRange(startUnixTime, endUnixTime);
        double secondDiff = endUnixTime - startUnixTime;
        return this.loop$1(TimeWindowUnit$.MODULE$.units().reverse(), endUnixTime, startUnixTime, r, secondDiff);
    }

    public TimeVector apply(long x, long offset, TimeWindowUnit unit) {
        return new TimeVector(x, offset, unit);
    }

    public Option<Tuple3<Object, Object, TimeWindowUnit>> unapply(TimeVector x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)x$0.x()), (Object)BoxesRunTime.boxToLong((long)x$0.offset()), (Object)x$0.unit()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final TimeVector loop$1(List unitsToUse, long endUnixTime$1, long startUnixTime$1, TimeWindow r$1, double secondDiff$1) {
        TimeVector timeVector;
        while (true) {
            if (unitsToUse.isEmpty()) {
                timeVector = new TimeVector(endUnixTime$1 - startUnixTime$1, 0L, TimeWindowUnit$Second$.MODULE$);
                break;
            }
            TimeWindowUnit unit = (TimeWindowUnit)unitsToUse.head();
            long numUnits = r$1.howMany(unit);
            ZonedDateTime startTruncated = unit.truncate(r$1.start());
            ZonedDateTime endTruncated = unit.truncate(r$1.end());
            TimeWindow truncated = new TimeWindow(startTruncated, endTruncated);
            long truncatedSecondDiff = truncated.secondDiff();
            if (numUnits > 0L && RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper((secondDiff$1 - (double)truncatedSecondDiff) / (double)(numUnits * (long)unit.secondsInUnit()))) <= 0.001) {
                timeVector = new TimeVector(numUnits, 0L, unit);
                break;
            }
            unitsToUse = (List)unitsToUse.tail();
        }
        return timeVector;
    }

    private TimeVector$() {
        MODULE$ = this;
        this.durationPattern = new StringOps(Predef$.MODULE$.augmentString("^([+-]|last|next)?([0-9]+)(s|m|d|h|w|M|q|y)")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prefix", "num", "unit"}));
    }
}

