import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::QuickSight::Analysis`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export interface CfnAnalysisProps {
    /**
     * `AWS::QuickSight::Analysis.AnalysisId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-analysisid
     */
    readonly analysisId: string;
    /**
     * `AWS::QuickSight::Analysis.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Analysis.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-sourceentity
     */
    readonly sourceEntity: CfnAnalysis.AnalysisSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Errors`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-errors
     */
    readonly errors?: Array<CfnAnalysis.AnalysisErrorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Analysis.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-parameters
     */
    readonly parameters?: CfnAnalysis.ParametersProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-permissions
     */
    readonly permissions?: Array<CfnAnalysis.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Analysis.ThemeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-themearn
     */
    readonly themeArn?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare class CfnAnalysis extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Analysis";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAnalysis;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute DataSetArns
     */
    readonly attrDataSetArns: string[];
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * @external
     * @cloudformationAttribute Sheets
     */
    readonly attrSheets: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::QuickSight::Analysis.AnalysisId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-analysisid
     */
    analysisId: string;
    /**
     * `AWS::QuickSight::Analysis.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Analysis.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-sourceentity
     */
    sourceEntity: CfnAnalysis.AnalysisSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Errors`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-errors
     */
    errors: Array<CfnAnalysis.AnalysisErrorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Analysis.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-parameters
     */
    parameters: CfnAnalysis.ParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-permissions
     */
    permissions: Array<CfnAnalysis.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Analysis.ThemeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-themearn
     */
    themeArn: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Analysis`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAnalysisProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html
     */
    interface AnalysisErrorProperty {
        /**
         * `CfnAnalysis.AnalysisErrorProperty.Message`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-message
         */
        readonly message?: string;
        /**
         * `CfnAnalysis.AnalysisErrorProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html
     */
    interface AnalysisSourceEntityProperty {
        /**
         * `CfnAnalysis.AnalysisSourceEntityProperty.SourceTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html#cfn-quicksight-analysis-analysissourceentity-sourcetemplate
         */
        readonly sourceTemplate?: CfnAnalysis.AnalysisSourceTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html
     */
    interface AnalysisSourceTemplateProperty {
        /**
         * `CfnAnalysis.AnalysisSourceTemplateProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-arn
         */
        readonly arn: string;
        /**
         * `CfnAnalysis.AnalysisSourceTemplateProperty.DataSetReferences`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-datasetreferences
         */
        readonly dataSetReferences: Array<CfnAnalysis.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html
     */
    interface DataSetReferenceProperty {
        /**
         * `CfnAnalysis.DataSetReferenceProperty.DataSetArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetarn
         */
        readonly dataSetArn: string;
        /**
         * `CfnAnalysis.DataSetReferenceProperty.DataSetPlaceholder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetplaceholder
         */
        readonly dataSetPlaceholder: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html
     */
    interface DateTimeParameterProperty {
        /**
         * `CfnAnalysis.DateTimeParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-name
         */
        readonly name: string;
        /**
         * `CfnAnalysis.DateTimeParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-values
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html
     */
    interface DecimalParameterProperty {
        /**
         * `CfnAnalysis.DecimalParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-name
         */
        readonly name: string;
        /**
         * `CfnAnalysis.DecimalParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-values
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html
     */
    interface IntegerParameterProperty {
        /**
         * `CfnAnalysis.IntegerParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html#cfn-quicksight-analysis-integerparameter-name
         */
        readonly name: string;
        /**
         * `CfnAnalysis.IntegerParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html#cfn-quicksight-analysis-integerparameter-values
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html
     */
    interface ParametersProperty {
        /**
         * `CfnAnalysis.ParametersProperty.DateTimeParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-datetimeparameters
         */
        readonly dateTimeParameters?: Array<CfnAnalysis.DateTimeParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnalysis.ParametersProperty.DecimalParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-decimalparameters
         */
        readonly decimalParameters?: Array<CfnAnalysis.DecimalParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnalysis.ParametersProperty.IntegerParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-integerparameters
         */
        readonly integerParameters?: Array<CfnAnalysis.IntegerParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnalysis.ParametersProperty.StringParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-stringparameters
         */
        readonly stringParameters?: Array<CfnAnalysis.StringParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnAnalysis.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html#cfn-quicksight-analysis-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnAnalysis.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html#cfn-quicksight-analysis-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html
     */
    interface SheetProperty {
        /**
         * `CfnAnalysis.SheetProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html#cfn-quicksight-analysis-sheet-name
         */
        readonly name?: string;
        /**
         * `CfnAnalysis.SheetProperty.SheetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html#cfn-quicksight-analysis-sheet-sheetid
         */
        readonly sheetId?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html
     */
    interface StringParameterProperty {
        /**
         * `CfnAnalysis.StringParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html#cfn-quicksight-analysis-stringparameter-name
         */
        readonly name: string;
        /**
         * `CfnAnalysis.StringParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html#cfn-quicksight-analysis-stringparameter-values
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export interface CfnDashboardProps {
    /**
     * `AWS::QuickSight::Dashboard.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardid
     */
    readonly dashboardId: string;
    /**
     * `AWS::QuickSight::Dashboard.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-sourceentity
     */
    readonly sourceEntity: CfnDashboard.DashboardSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.DashboardPublishOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardpublishoptions
     */
    readonly dashboardPublishOptions?: CfnDashboard.DashboardPublishOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Dashboard.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-parameters
     */
    readonly parameters?: CfnDashboard.ParametersProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-permissions
     */
    readonly permissions?: Array<CfnDashboard.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Dashboard.ThemeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-themearn
     */
    readonly themeArn?: string;
    /**
     * `AWS::QuickSight::Dashboard.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-versiondescription
     */
    readonly versionDescription?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare class CfnDashboard extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Dashboard";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDashboard;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastPublishedTime
     */
    readonly attrLastPublishedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * `AWS::QuickSight::Dashboard.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardid
     */
    dashboardId: string;
    /**
     * `AWS::QuickSight::Dashboard.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-sourceentity
     */
    sourceEntity: CfnDashboard.DashboardSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.DashboardPublishOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardpublishoptions
     */
    dashboardPublishOptions: CfnDashboard.DashboardPublishOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-parameters
     */
    parameters: CfnDashboard.ParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-permissions
     */
    permissions: Array<CfnDashboard.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Dashboard.ThemeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-themearn
     */
    themeArn: string | undefined;
    /**
     * `AWS::QuickSight::Dashboard.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-versiondescription
     */
    versionDescription: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Dashboard`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDashboardProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-adhocfilteringoption.html
     */
    interface AdHocFilteringOptionProperty {
        /**
         * `CfnDashboard.AdHocFilteringOptionProperty.AvailabilityStatus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-adhocfilteringoption.html#cfn-quicksight-dashboard-adhocfilteringoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html
     */
    interface DashboardPublishOptionsProperty {
        /**
         * `CfnDashboard.DashboardPublishOptionsProperty.AdHocFilteringOption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-adhocfilteringoption
         */
        readonly adHocFilteringOption?: CfnDashboard.AdHocFilteringOptionProperty | cdk.IResolvable;
        /**
         * `CfnDashboard.DashboardPublishOptionsProperty.ExportToCSVOption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-exporttocsvoption
         */
        readonly exportToCsvOption?: CfnDashboard.ExportToCSVOptionProperty | cdk.IResolvable;
        /**
         * `CfnDashboard.DashboardPublishOptionsProperty.SheetControlsOption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-sheetcontrolsoption
         */
        readonly sheetControlsOption?: CfnDashboard.SheetControlsOptionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourceentity.html
     */
    interface DashboardSourceEntityProperty {
        /**
         * `CfnDashboard.DashboardSourceEntityProperty.SourceTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourceentity.html#cfn-quicksight-dashboard-dashboardsourceentity-sourcetemplate
         */
        readonly sourceTemplate?: CfnDashboard.DashboardSourceTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html
     */
    interface DashboardSourceTemplateProperty {
        /**
         * `CfnDashboard.DashboardSourceTemplateProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html#cfn-quicksight-dashboard-dashboardsourcetemplate-arn
         */
        readonly arn: string;
        /**
         * `CfnDashboard.DashboardSourceTemplateProperty.DataSetReferences`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html#cfn-quicksight-dashboard-dashboardsourcetemplate-datasetreferences
         */
        readonly dataSetReferences: Array<CfnDashboard.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html
     */
    interface DataSetReferenceProperty {
        /**
         * `CfnDashboard.DataSetReferenceProperty.DataSetArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html#cfn-quicksight-dashboard-datasetreference-datasetarn
         */
        readonly dataSetArn: string;
        /**
         * `CfnDashboard.DataSetReferenceProperty.DataSetPlaceholder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html#cfn-quicksight-dashboard-datasetreference-datasetplaceholder
         */
        readonly dataSetPlaceholder: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html
     */
    interface DateTimeParameterProperty {
        /**
         * `CfnDashboard.DateTimeParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html#cfn-quicksight-dashboard-datetimeparameter-name
         */
        readonly name: string;
        /**
         * `CfnDashboard.DateTimeParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html#cfn-quicksight-dashboard-datetimeparameter-values
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html
     */
    interface DecimalParameterProperty {
        /**
         * `CfnDashboard.DecimalParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html#cfn-quicksight-dashboard-decimalparameter-name
         */
        readonly name: string;
        /**
         * `CfnDashboard.DecimalParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html#cfn-quicksight-dashboard-decimalparameter-values
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporttocsvoption.html
     */
    interface ExportToCSVOptionProperty {
        /**
         * `CfnDashboard.ExportToCSVOptionProperty.AvailabilityStatus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporttocsvoption.html#cfn-quicksight-dashboard-exporttocsvoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html
     */
    interface IntegerParameterProperty {
        /**
         * `CfnDashboard.IntegerParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html#cfn-quicksight-dashboard-integerparameter-name
         */
        readonly name: string;
        /**
         * `CfnDashboard.IntegerParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html#cfn-quicksight-dashboard-integerparameter-values
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html
     */
    interface ParametersProperty {
        /**
         * `CfnDashboard.ParametersProperty.DateTimeParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-datetimeparameters
         */
        readonly dateTimeParameters?: Array<CfnDashboard.DateTimeParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.ParametersProperty.DecimalParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-decimalparameters
         */
        readonly decimalParameters?: Array<CfnDashboard.DecimalParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.ParametersProperty.IntegerParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-integerparameters
         */
        readonly integerParameters?: Array<CfnDashboard.IntegerParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.ParametersProperty.StringParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-stringparameters
         */
        readonly stringParameters?: Array<CfnDashboard.StringParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnDashboard.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-resourcepermission.html#cfn-quicksight-dashboard-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnDashboard.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-resourcepermission.html#cfn-quicksight-dashboard-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolsoption.html
     */
    interface SheetControlsOptionProperty {
        /**
         * `CfnDashboard.SheetControlsOptionProperty.VisibilityState`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolsoption.html#cfn-quicksight-dashboard-sheetcontrolsoption-visibilitystate
         */
        readonly visibilityState?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html
     */
    interface StringParameterProperty {
        /**
         * `CfnDashboard.StringParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html#cfn-quicksight-dashboard-stringparameter-name
         */
        readonly name: string;
        /**
         * `CfnDashboard.StringParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html#cfn-quicksight-dashboard-stringparameter-values
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `AWS::QuickSight::DataSet`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export interface CfnDataSetProps {
    /**
     * `AWS::QuickSight::DataSet.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-awsaccountid
     */
    readonly awsAccountId?: string;
    /**
     * `AWS::QuickSight::DataSet.ColumnGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columngroups
     */
    readonly columnGroups?: Array<CfnDataSet.ColumnGroupProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSet.ColumnLevelPermissionRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columnlevelpermissionrules
     */
    readonly columnLevelPermissionRules?: Array<CfnDataSet.ColumnLevelPermissionRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSet.DataSetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetid
     */
    readonly dataSetId?: string;
    /**
     * `AWS::QuickSight::DataSet.FieldFolders`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-fieldfolders
     */
    readonly fieldFolders?: {
        [key: string]: (CfnDataSet.FieldFolderProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSet.ImportMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-importmode
     */
    readonly importMode?: string;
    /**
     * `AWS::QuickSight::DataSet.IngestionWaitPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-ingestionwaitpolicy
     */
    readonly ingestionWaitPolicy?: CfnDataSet.IngestionWaitPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSet.LogicalTableMap`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-logicaltablemap
     */
    readonly logicalTableMap?: {
        [key: string]: (CfnDataSet.LogicalTableProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSet.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::DataSet.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-permissions
     */
    readonly permissions?: Array<CfnDataSet.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSet.PhysicalTableMap`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-physicaltablemap
     */
    readonly physicalTableMap?: {
        [key: string]: (CfnDataSet.PhysicalTableProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSet.RowLevelPermissionDataSet`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset
     */
    readonly rowLevelPermissionDataSet?: CfnDataSet.RowLevelPermissionDataSetProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSet.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare class CfnDataSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::DataSet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataSet;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ConsumedSpiceCapacityInBytes
     */
    readonly attrConsumedSpiceCapacityInBytes: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * @external
     * @cloudformationAttribute OutputColumns
     */
    readonly attrOutputColumns: cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSet.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-awsaccountid
     */
    awsAccountId: string | undefined;
    /**
     * `AWS::QuickSight::DataSet.ColumnGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columngroups
     */
    columnGroups: Array<CfnDataSet.ColumnGroupProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSet.ColumnLevelPermissionRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columnlevelpermissionrules
     */
    columnLevelPermissionRules: Array<CfnDataSet.ColumnLevelPermissionRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSet.DataSetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetid
     */
    dataSetId: string | undefined;
    /**
     * `AWS::QuickSight::DataSet.FieldFolders`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-fieldfolders
     */
    fieldFolders: {
        [key: string]: (CfnDataSet.FieldFolderProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSet.ImportMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-importmode
     */
    importMode: string | undefined;
    /**
     * `AWS::QuickSight::DataSet.IngestionWaitPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-ingestionwaitpolicy
     */
    ingestionWaitPolicy: CfnDataSet.IngestionWaitPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSet.LogicalTableMap`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-logicaltablemap
     */
    logicalTableMap: {
        [key: string]: (CfnDataSet.LogicalTableProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSet.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::DataSet.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-permissions
     */
    permissions: Array<CfnDataSet.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSet.PhysicalTableMap`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-physicaltablemap
     */
    physicalTableMap: {
        [key: string]: (CfnDataSet.PhysicalTableProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSet.RowLevelPermissionDataSet`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset
     */
    rowLevelPermissionDataSet: CfnDataSet.RowLevelPermissionDataSetProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSet.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::QuickSight::DataSet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDataSetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html
     */
    interface CalculatedColumnProperty {
        /**
         * `CfnDataSet.CalculatedColumnProperty.ColumnId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnid
         */
        readonly columnId: string;
        /**
         * `CfnDataSet.CalculatedColumnProperty.ColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnname
         */
        readonly columnName: string;
        /**
         * `CfnDataSet.CalculatedColumnProperty.Expression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-expression
         */
        readonly expression: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html
     */
    interface CastColumnTypeOperationProperty {
        /**
         * `CfnDataSet.CastColumnTypeOperationProperty.ColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-columnname
         */
        readonly columnName: string;
        /**
         * `CfnDataSet.CastColumnTypeOperationProperty.Format`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-format
         */
        readonly format?: string;
        /**
         * `CfnDataSet.CastColumnTypeOperationProperty.NewColumnType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-newcolumntype
         */
        readonly newColumnType: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html
     */
    interface ColumnDescriptionProperty {
        /**
         * `CfnDataSet.ColumnDescriptionProperty.Text`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html#cfn-quicksight-dataset-columndescription-text
         */
        readonly text?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html
     */
    interface ColumnGroupProperty {
        /**
         * `CfnDataSet.ColumnGroupProperty.GeoSpatialColumnGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html#cfn-quicksight-dataset-columngroup-geospatialcolumngroup
         */
        readonly geoSpatialColumnGroup?: CfnDataSet.GeoSpatialColumnGroupProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html
     */
    interface ColumnLevelPermissionRuleProperty {
        /**
         * `CfnDataSet.ColumnLevelPermissionRuleProperty.ColumnNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-columnnames
         */
        readonly columnNames?: string[];
        /**
         * `CfnDataSet.ColumnLevelPermissionRuleProperty.Principals`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-principals
         */
        readonly principals?: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html
     */
    interface ColumnTagProperty {
        /**
         * `CfnDataSet.ColumnTagProperty.ColumnDescription`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columndescription
         */
        readonly columnDescription?: CfnDataSet.ColumnDescriptionProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.ColumnTagProperty.ColumnGeographicRole`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columngeographicrole
         */
        readonly columnGeographicRole?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html
     */
    interface CreateColumnsOperationProperty {
        /**
         * `CfnDataSet.CreateColumnsOperationProperty.Columns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html#cfn-quicksight-dataset-createcolumnsoperation-columns
         */
        readonly columns: Array<CfnDataSet.CalculatedColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html
     */
    interface CustomSqlProperty {
        /**
         * `CfnDataSet.CustomSqlProperty.Columns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-columns
         */
        readonly columns: Array<CfnDataSet.InputColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSet.CustomSqlProperty.DataSourceArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-datasourcearn
         */
        readonly dataSourceArn: string;
        /**
         * `CfnDataSet.CustomSqlProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-name
         */
        readonly name: string;
        /**
         * `CfnDataSet.CustomSqlProperty.SqlQuery`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-sqlquery
         */
        readonly sqlQuery: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html
     */
    interface FieldFolderProperty {
        /**
         * `CfnDataSet.FieldFolderProperty.Columns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-columns
         */
        readonly columns?: string[];
        /**
         * `CfnDataSet.FieldFolderProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-description
         */
        readonly description?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html
     */
    interface FilterOperationProperty {
        /**
         * `CfnDataSet.FilterOperationProperty.ConditionExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-conditionexpression
         */
        readonly conditionExpression: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html
     */
    interface GeoSpatialColumnGroupProperty {
        /**
         * `CfnDataSet.GeoSpatialColumnGroupProperty.Columns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-columns
         */
        readonly columns: string[];
        /**
         * `CfnDataSet.GeoSpatialColumnGroupProperty.CountryCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-countrycode
         */
        readonly countryCode?: string;
        /**
         * `CfnDataSet.GeoSpatialColumnGroupProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html
     */
    interface IngestionWaitPolicyProperty {
        /**
         * `CfnDataSet.IngestionWaitPolicyProperty.IngestionWaitTimeInHours`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-ingestionwaittimeinhours
         */
        readonly ingestionWaitTimeInHours?: number;
        /**
         * `CfnDataSet.IngestionWaitPolicyProperty.WaitForSpiceIngestion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-waitforspiceingestion
         */
        readonly waitForSpiceIngestion?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html
     */
    interface InputColumnProperty {
        /**
         * `CfnDataSet.InputColumnProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-name
         */
        readonly name: string;
        /**
         * `CfnDataSet.InputColumnProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html
     */
    interface JoinInstructionProperty {
        /**
         * `CfnDataSet.JoinInstructionProperty.LeftJoinKeyProperties`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftjoinkeyproperties
         */
        readonly leftJoinKeyProperties?: CfnDataSet.JoinKeyPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.JoinInstructionProperty.LeftOperand`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftoperand
         */
        readonly leftOperand: string;
        /**
         * `CfnDataSet.JoinInstructionProperty.OnClause`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-onclause
         */
        readonly onClause: string;
        /**
         * `CfnDataSet.JoinInstructionProperty.RightJoinKeyProperties`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightjoinkeyproperties
         */
        readonly rightJoinKeyProperties?: CfnDataSet.JoinKeyPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.JoinInstructionProperty.RightOperand`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightoperand
         */
        readonly rightOperand: string;
        /**
         * `CfnDataSet.JoinInstructionProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html
     */
    interface JoinKeyPropertiesProperty {
        /**
         * `CfnDataSet.JoinKeyPropertiesProperty.UniqueKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html#cfn-quicksight-dataset-joinkeyproperties-uniquekey
         */
        readonly uniqueKey?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html
     */
    interface LogicalTableProperty {
        /**
         * `CfnDataSet.LogicalTableProperty.Alias`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-alias
         */
        readonly alias: string;
        /**
         * `CfnDataSet.LogicalTableProperty.DataTransforms`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-datatransforms
         */
        readonly dataTransforms?: Array<CfnDataSet.TransformOperationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSet.LogicalTableProperty.Source`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-source
         */
        readonly source: CfnDataSet.LogicalTableSourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html
     */
    interface LogicalTableSourceProperty {
        /**
         * `CfnDataSet.LogicalTableSourceProperty.JoinInstruction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-joininstruction
         */
        readonly joinInstruction?: CfnDataSet.JoinInstructionProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.LogicalTableSourceProperty.PhysicalTableId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-physicaltableid
         */
        readonly physicalTableId?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html
     */
    interface OutputColumnProperty {
        /**
         * `CfnDataSet.OutputColumnProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-description
         */
        readonly description?: string;
        /**
         * `CfnDataSet.OutputColumnProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-name
         */
        readonly name?: string;
        /**
         * `CfnDataSet.OutputColumnProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html
     */
    interface PhysicalTableProperty {
        /**
         * `CfnDataSet.PhysicalTableProperty.CustomSql`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-customsql
         */
        readonly customSql?: CfnDataSet.CustomSqlProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.PhysicalTableProperty.RelationalTable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-relationaltable
         */
        readonly relationalTable?: CfnDataSet.RelationalTableProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.PhysicalTableProperty.S3Source`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-s3source
         */
        readonly s3Source?: CfnDataSet.S3SourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html
     */
    interface ProjectOperationProperty {
        /**
         * `CfnDataSet.ProjectOperationProperty.ProjectedColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-projectedcolumns
         */
        readonly projectedColumns: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html
     */
    interface RelationalTableProperty {
        /**
         * `CfnDataSet.RelationalTableProperty.Catalog`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-catalog
         */
        readonly catalog?: string;
        /**
         * `CfnDataSet.RelationalTableProperty.DataSourceArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-datasourcearn
         */
        readonly dataSourceArn: string;
        /**
         * `CfnDataSet.RelationalTableProperty.InputColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-inputcolumns
         */
        readonly inputColumns: Array<CfnDataSet.InputColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSet.RelationalTableProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-name
         */
        readonly name: string;
        /**
         * `CfnDataSet.RelationalTableProperty.Schema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-schema
         */
        readonly schema?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html
     */
    interface RenameColumnOperationProperty {
        /**
         * `CfnDataSet.RenameColumnOperationProperty.ColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-columnname
         */
        readonly columnName: string;
        /**
         * `CfnDataSet.RenameColumnOperationProperty.NewColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-newcolumnname
         */
        readonly newColumnName: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnDataSet.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnDataSet.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html
     */
    interface RowLevelPermissionDataSetProperty {
        /**
         * `CfnDataSet.RowLevelPermissionDataSetProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-arn
         */
        readonly arn: string;
        /**
         * `CfnDataSet.RowLevelPermissionDataSetProperty.FormatVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-formatversion
         */
        readonly formatVersion?: string;
        /**
         * `CfnDataSet.RowLevelPermissionDataSetProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-namespace
         */
        readonly namespace?: string;
        /**
         * `CfnDataSet.RowLevelPermissionDataSetProperty.PermissionPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-permissionpolicy
         */
        readonly permissionPolicy: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html
     */
    interface S3SourceProperty {
        /**
         * `CfnDataSet.S3SourceProperty.DataSourceArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html#cfn-quicksight-dataset-s3source-datasourcearn
         */
        readonly dataSourceArn: string;
        /**
         * `CfnDataSet.S3SourceProperty.InputColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html#cfn-quicksight-dataset-s3source-inputcolumns
         */
        readonly inputColumns: Array<CfnDataSet.InputColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSet.S3SourceProperty.UploadSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html#cfn-quicksight-dataset-s3source-uploadsettings
         */
        readonly uploadSettings?: CfnDataSet.UploadSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html
     */
    interface TagColumnOperationProperty {
        /**
         * `CfnDataSet.TagColumnOperationProperty.ColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html#cfn-quicksight-dataset-tagcolumnoperation-columnname
         */
        readonly columnName: string;
        /**
         * `CfnDataSet.TagColumnOperationProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html#cfn-quicksight-dataset-tagcolumnoperation-tags
         */
        readonly tags: CfnDataSet.ColumnTagProperty[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html
     */
    interface TransformOperationProperty {
        /**
         * `CfnDataSet.TransformOperationProperty.CastColumnTypeOperation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-castcolumntypeoperation
         */
        readonly castColumnTypeOperation?: CfnDataSet.CastColumnTypeOperationProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.TransformOperationProperty.CreateColumnsOperation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-createcolumnsoperation
         */
        readonly createColumnsOperation?: CfnDataSet.CreateColumnsOperationProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.TransformOperationProperty.FilterOperation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-filteroperation
         */
        readonly filterOperation?: CfnDataSet.FilterOperationProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.TransformOperationProperty.ProjectOperation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-projectoperation
         */
        readonly projectOperation?: CfnDataSet.ProjectOperationProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.TransformOperationProperty.RenameColumnOperation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-renamecolumnoperation
         */
        readonly renameColumnOperation?: CfnDataSet.RenameColumnOperationProperty | cdk.IResolvable;
        /**
         * `CfnDataSet.TransformOperationProperty.TagColumnOperation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-tagcolumnoperation
         */
        readonly tagColumnOperation?: CfnDataSet.TagColumnOperationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html
 */
export declare namespace CfnDataSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html
     */
    interface UploadSettingsProperty {
        /**
         * `CfnDataSet.UploadSettingsProperty.ContainsHeader`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-containsheader
         */
        readonly containsHeader?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSet.UploadSettingsProperty.Delimiter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-delimiter
         */
        readonly delimiter?: string;
        /**
         * `CfnDataSet.UploadSettingsProperty.Format`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-format
         */
        readonly format?: string;
        /**
         * `CfnDataSet.UploadSettingsProperty.StartFromRow`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-startfromrow
         */
        readonly startFromRow?: number;
        /**
         * `CfnDataSet.UploadSettingsProperty.TextQualifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-textqualifier
         */
        readonly textQualifier?: string;
    }
}
/**
 * Properties for defining a `AWS::QuickSight::DataSource`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export interface CfnDataSourceProps {
    /**
     * `AWS::QuickSight::DataSource.AlternateDataSourceParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-alternatedatasourceparameters
     */
    readonly alternateDataSourceParameters?: Array<CfnDataSource.DataSourceParametersProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSource.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-awsaccountid
     */
    readonly awsAccountId?: string;
    /**
     * `AWS::QuickSight::DataSource.Credentials`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-credentials
     */
    readonly credentials?: CfnDataSource.DataSourceCredentialsProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSource.DataSourceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceid
     */
    readonly dataSourceId?: string;
    /**
     * `AWS::QuickSight::DataSource.DataSourceParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceparameters
     */
    readonly dataSourceParameters?: CfnDataSource.DataSourceParametersProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSource.ErrorInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-errorinfo
     */
    readonly errorInfo?: CfnDataSource.DataSourceErrorInfoProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSource.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::DataSource.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-permissions
     */
    readonly permissions?: Array<CfnDataSource.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSource.SslProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-sslproperties
     */
    readonly sslProperties?: CfnDataSource.SslPropertiesProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::DataSource.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::DataSource.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-type
     */
    readonly type?: string;
    /**
     * `AWS::QuickSight::DataSource.VpcConnectionProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-vpcconnectionproperties
     */
    readonly vpcConnectionProperties?: CfnDataSource.VpcConnectionPropertiesProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare class CfnDataSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::DataSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataSource;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::QuickSight::DataSource.AlternateDataSourceParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-alternatedatasourceparameters
     */
    alternateDataSourceParameters: Array<CfnDataSource.DataSourceParametersProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSource.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-awsaccountid
     */
    awsAccountId: string | undefined;
    /**
     * `AWS::QuickSight::DataSource.Credentials`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-credentials
     */
    credentials: CfnDataSource.DataSourceCredentialsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSource.DataSourceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceid
     */
    dataSourceId: string | undefined;
    /**
     * `AWS::QuickSight::DataSource.DataSourceParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceparameters
     */
    dataSourceParameters: CfnDataSource.DataSourceParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSource.ErrorInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-errorinfo
     */
    errorInfo: CfnDataSource.DataSourceErrorInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSource.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::DataSource.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-permissions
     */
    permissions: Array<CfnDataSource.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSource.SslProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-sslproperties
     */
    sslProperties: CfnDataSource.SslPropertiesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::DataSource.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::DataSource.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-type
     */
    type: string | undefined;
    /**
     * `AWS::QuickSight::DataSource.VpcConnectionProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-vpcconnectionproperties
     */
    vpcConnectionProperties: CfnDataSource.VpcConnectionPropertiesProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::QuickSight::DataSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDataSourceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonelasticsearchparameters.html
     */
    interface AmazonElasticsearchParametersProperty {
        /**
         * `CfnDataSource.AmazonElasticsearchParametersProperty.Domain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonelasticsearchparameters.html#cfn-quicksight-datasource-amazonelasticsearchparameters-domain
         */
        readonly domain: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonopensearchparameters.html
     */
    interface AmazonOpenSearchParametersProperty {
        /**
         * `CfnDataSource.AmazonOpenSearchParametersProperty.Domain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonopensearchparameters.html#cfn-quicksight-datasource-amazonopensearchparameters-domain
         */
        readonly domain: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-athenaparameters.html
     */
    interface AthenaParametersProperty {
        /**
         * `CfnDataSource.AthenaParametersProperty.WorkGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-athenaparameters.html#cfn-quicksight-datasource-athenaparameters-workgroup
         */
        readonly workGroup?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html
     */
    interface AuroraParametersProperty {
        /**
         * `CfnDataSource.AuroraParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html#cfn-quicksight-datasource-auroraparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.AuroraParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html#cfn-quicksight-datasource-auroraparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.AuroraParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html#cfn-quicksight-datasource-auroraparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html
     */
    interface AuroraPostgreSqlParametersProperty {
        /**
         * `CfnDataSource.AuroraPostgreSqlParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html#cfn-quicksight-datasource-aurorapostgresqlparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.AuroraPostgreSqlParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html#cfn-quicksight-datasource-aurorapostgresqlparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.AuroraPostgreSqlParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html#cfn-quicksight-datasource-aurorapostgresqlparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html
     */
    interface CredentialPairProperty {
        /**
         * `CfnDataSource.CredentialPairProperty.AlternateDataSourceParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html#cfn-quicksight-datasource-credentialpair-alternatedatasourceparameters
         */
        readonly alternateDataSourceParameters?: Array<CfnDataSource.DataSourceParametersProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.CredentialPairProperty.Password`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html#cfn-quicksight-datasource-credentialpair-password
         */
        readonly password: string;
        /**
         * `CfnDataSource.CredentialPairProperty.Username`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html#cfn-quicksight-datasource-credentialpair-username
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html
     */
    interface DataSourceCredentialsProperty {
        /**
         * `CfnDataSource.DataSourceCredentialsProperty.CopySourceArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html#cfn-quicksight-datasource-datasourcecredentials-copysourcearn
         */
        readonly copySourceArn?: string;
        /**
         * `CfnDataSource.DataSourceCredentialsProperty.CredentialPair`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html#cfn-quicksight-datasource-datasourcecredentials-credentialpair
         */
        readonly credentialPair?: CfnDataSource.CredentialPairProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html
     */
    interface DataSourceErrorInfoProperty {
        /**
         * `CfnDataSource.DataSourceErrorInfoProperty.Message`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html#cfn-quicksight-datasource-datasourceerrorinfo-message
         */
        readonly message?: string;
        /**
         * `CfnDataSource.DataSourceErrorInfoProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html#cfn-quicksight-datasource-datasourceerrorinfo-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html
     */
    interface DataSourceParametersProperty {
        /**
         * `CfnDataSource.DataSourceParametersProperty.AmazonElasticsearchParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-amazonelasticsearchparameters
         */
        readonly amazonElasticsearchParameters?: CfnDataSource.AmazonElasticsearchParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.AmazonOpenSearchParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-amazonopensearchparameters
         */
        readonly amazonOpenSearchParameters?: CfnDataSource.AmazonOpenSearchParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.AthenaParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-athenaparameters
         */
        readonly athenaParameters?: CfnDataSource.AthenaParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.AuroraParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-auroraparameters
         */
        readonly auroraParameters?: CfnDataSource.AuroraParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.AuroraPostgreSqlParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-aurorapostgresqlparameters
         */
        readonly auroraPostgreSqlParameters?: CfnDataSource.AuroraPostgreSqlParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.MariaDbParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-mariadbparameters
         */
        readonly mariaDbParameters?: CfnDataSource.MariaDbParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.MySqlParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-mysqlparameters
         */
        readonly mySqlParameters?: CfnDataSource.MySqlParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.OracleParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-oracleparameters
         */
        readonly oracleParameters?: CfnDataSource.OracleParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.PostgreSqlParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-postgresqlparameters
         */
        readonly postgreSqlParameters?: CfnDataSource.PostgreSqlParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.PrestoParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-prestoparameters
         */
        readonly prestoParameters?: CfnDataSource.PrestoParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.RdsParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-rdsparameters
         */
        readonly rdsParameters?: CfnDataSource.RdsParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.RedshiftParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-redshiftparameters
         */
        readonly redshiftParameters?: CfnDataSource.RedshiftParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.S3Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-s3parameters
         */
        readonly s3Parameters?: CfnDataSource.S3ParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.SnowflakeParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-snowflakeparameters
         */
        readonly snowflakeParameters?: CfnDataSource.SnowflakeParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.SparkParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-sparkparameters
         */
        readonly sparkParameters?: CfnDataSource.SparkParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.SqlServerParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-sqlserverparameters
         */
        readonly sqlServerParameters?: CfnDataSource.SqlServerParametersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceParametersProperty.TeradataParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-teradataparameters
         */
        readonly teradataParameters?: CfnDataSource.TeradataParametersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html
     */
    interface ManifestFileLocationProperty {
        /**
         * `CfnDataSource.ManifestFileLocationProperty.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html#cfn-quicksight-datasource-manifestfilelocation-bucket
         */
        readonly bucket: string;
        /**
         * `CfnDataSource.ManifestFileLocationProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html#cfn-quicksight-datasource-manifestfilelocation-key
         */
        readonly key: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html
     */
    interface MariaDbParametersProperty {
        /**
         * `CfnDataSource.MariaDbParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html#cfn-quicksight-datasource-mariadbparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.MariaDbParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html#cfn-quicksight-datasource-mariadbparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.MariaDbParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html#cfn-quicksight-datasource-mariadbparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html
     */
    interface MySqlParametersProperty {
        /**
         * `CfnDataSource.MySqlParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html#cfn-quicksight-datasource-mysqlparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.MySqlParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html#cfn-quicksight-datasource-mysqlparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.MySqlParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html#cfn-quicksight-datasource-mysqlparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html
     */
    interface OracleParametersProperty {
        /**
         * `CfnDataSource.OracleParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.OracleParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.OracleParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html
     */
    interface PostgreSqlParametersProperty {
        /**
         * `CfnDataSource.PostgreSqlParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html#cfn-quicksight-datasource-postgresqlparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.PostgreSqlParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html#cfn-quicksight-datasource-postgresqlparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.PostgreSqlParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html#cfn-quicksight-datasource-postgresqlparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html
     */
    interface PrestoParametersProperty {
        /**
         * `CfnDataSource.PrestoParametersProperty.Catalog`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html#cfn-quicksight-datasource-prestoparameters-catalog
         */
        readonly catalog: string;
        /**
         * `CfnDataSource.PrestoParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html#cfn-quicksight-datasource-prestoparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.PrestoParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html#cfn-quicksight-datasource-prestoparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html
     */
    interface RdsParametersProperty {
        /**
         * `CfnDataSource.RdsParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html#cfn-quicksight-datasource-rdsparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.RdsParametersProperty.InstanceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html#cfn-quicksight-datasource-rdsparameters-instanceid
         */
        readonly instanceId: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html
     */
    interface RedshiftParametersProperty {
        /**
         * `CfnDataSource.RedshiftParametersProperty.ClusterId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-clusterid
         */
        readonly clusterId?: string;
        /**
         * `CfnDataSource.RedshiftParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.RedshiftParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-host
         */
        readonly host?: string;
        /**
         * `CfnDataSource.RedshiftParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-port
         */
        readonly port?: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnDataSource.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html#cfn-quicksight-datasource-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnDataSource.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html#cfn-quicksight-datasource-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-s3parameters.html
     */
    interface S3ParametersProperty {
        /**
         * `CfnDataSource.S3ParametersProperty.ManifestFileLocation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-s3parameters.html#cfn-quicksight-datasource-s3parameters-manifestfilelocation
         */
        readonly manifestFileLocation: CfnDataSource.ManifestFileLocationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html
     */
    interface SnowflakeParametersProperty {
        /**
         * `CfnDataSource.SnowflakeParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.SnowflakeParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.SnowflakeParametersProperty.Warehouse`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-warehouse
         */
        readonly warehouse: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html
     */
    interface SparkParametersProperty {
        /**
         * `CfnDataSource.SparkParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html#cfn-quicksight-datasource-sparkparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.SparkParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html#cfn-quicksight-datasource-sparkparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html
     */
    interface SqlServerParametersProperty {
        /**
         * `CfnDataSource.SqlServerParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html#cfn-quicksight-datasource-sqlserverparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.SqlServerParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html#cfn-quicksight-datasource-sqlserverparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.SqlServerParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html#cfn-quicksight-datasource-sqlserverparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sslproperties.html
     */
    interface SslPropertiesProperty {
        /**
         * `CfnDataSource.SslPropertiesProperty.DisableSsl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sslproperties.html#cfn-quicksight-datasource-sslproperties-disablessl
         */
        readonly disableSsl?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html
     */
    interface TeradataParametersProperty {
        /**
         * `CfnDataSource.TeradataParametersProperty.Database`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html#cfn-quicksight-datasource-teradataparameters-database
         */
        readonly database: string;
        /**
         * `CfnDataSource.TeradataParametersProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html#cfn-quicksight-datasource-teradataparameters-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.TeradataParametersProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html#cfn-quicksight-datasource-teradataparameters-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-vpcconnectionproperties.html
     */
    interface VpcConnectionPropertiesProperty {
        /**
         * `CfnDataSource.VpcConnectionPropertiesProperty.VpcConnectionArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-vpcconnectionproperties.html#cfn-quicksight-datasource-vpcconnectionproperties-vpcconnectionarn
         */
        readonly vpcConnectionArn: string;
    }
}
/**
 * Properties for defining a `AWS::QuickSight::Template`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export interface CfnTemplateProps {
    /**
     * `AWS::QuickSight::Template.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Template.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-sourceentity
     */
    readonly sourceEntity: CfnTemplate.TemplateSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Template.TemplateId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-templateid
     */
    readonly templateId: string;
    /**
     * `AWS::QuickSight::Template.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Template.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-permissions
     */
    readonly permissions?: Array<CfnTemplate.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Template.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Template.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-versiondescription
     */
    readonly versionDescription?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare class CfnTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Template";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTemplate;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * `AWS::QuickSight::Template.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Template.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-sourceentity
     */
    sourceEntity: CfnTemplate.TemplateSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Template.TemplateId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-templateid
     */
    templateId: string;
    /**
     * `AWS::QuickSight::Template.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Template.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-permissions
     */
    permissions: Array<CfnTemplate.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Template.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Template.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-versiondescription
     */
    versionDescription: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Template`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html
     */
    interface DataSetReferenceProperty {
        /**
         * `CfnTemplate.DataSetReferenceProperty.DataSetArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html#cfn-quicksight-template-datasetreference-datasetarn
         */
        readonly dataSetArn: string;
        /**
         * `CfnTemplate.DataSetReferenceProperty.DataSetPlaceholder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html#cfn-quicksight-template-datasetreference-datasetplaceholder
         */
        readonly dataSetPlaceholder: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnTemplate.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-resourcepermission.html#cfn-quicksight-template-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnTemplate.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-resourcepermission.html#cfn-quicksight-template-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html
     */
    interface TemplateSourceAnalysisProperty {
        /**
         * `CfnTemplate.TemplateSourceAnalysisProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html#cfn-quicksight-template-templatesourceanalysis-arn
         */
        readonly arn: string;
        /**
         * `CfnTemplate.TemplateSourceAnalysisProperty.DataSetReferences`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html#cfn-quicksight-template-templatesourceanalysis-datasetreferences
         */
        readonly dataSetReferences: Array<CfnTemplate.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html
     */
    interface TemplateSourceEntityProperty {
        /**
         * `CfnTemplate.TemplateSourceEntityProperty.SourceAnalysis`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html#cfn-quicksight-template-templatesourceentity-sourceanalysis
         */
        readonly sourceAnalysis?: CfnTemplate.TemplateSourceAnalysisProperty | cdk.IResolvable;
        /**
         * `CfnTemplate.TemplateSourceEntityProperty.SourceTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html#cfn-quicksight-template-templatesourceentity-sourcetemplate
         */
        readonly sourceTemplate?: CfnTemplate.TemplateSourceTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourcetemplate.html
     */
    interface TemplateSourceTemplateProperty {
        /**
         * `CfnTemplate.TemplateSourceTemplateProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourcetemplate.html#cfn-quicksight-template-templatesourcetemplate-arn
         */
        readonly arn: string;
    }
}
/**
 * Properties for defining a `AWS::QuickSight::Theme`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export interface CfnThemeProps {
    /**
     * `AWS::QuickSight::Theme.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Theme.ThemeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-themeid
     */
    readonly themeId: string;
    /**
     * `AWS::QuickSight::Theme.BaseThemeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-basethemeid
     */
    readonly baseThemeId?: string;
    /**
     * `AWS::QuickSight::Theme.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-configuration
     */
    readonly configuration?: CfnTheme.ThemeConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Theme.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Theme.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-permissions
     */
    readonly permissions?: Array<CfnTheme.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Theme.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Theme.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-versiondescription
     */
    readonly versionDescription?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare class CfnTheme extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Theme";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTheme;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * `AWS::QuickSight::Theme.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Theme.ThemeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-themeid
     */
    themeId: string;
    /**
     * `AWS::QuickSight::Theme.BaseThemeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-basethemeid
     */
    baseThemeId: string | undefined;
    /**
     * `AWS::QuickSight::Theme.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-configuration
     */
    configuration: CfnTheme.ThemeConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Theme.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Theme.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-permissions
     */
    permissions: Array<CfnTheme.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Theme.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Theme.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-versiondescription
     */
    versionDescription: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Theme`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnThemeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-borderstyle.html
     */
    interface BorderStyleProperty {
        /**
         * `CfnTheme.BorderStyleProperty.Show`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-borderstyle.html#cfn-quicksight-theme-borderstyle-show
         */
        readonly show?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html
     */
    interface DataColorPaletteProperty {
        /**
         * `CfnTheme.DataColorPaletteProperty.Colors`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html#cfn-quicksight-theme-datacolorpalette-colors
         */
        readonly colors?: string[];
        /**
         * `CfnTheme.DataColorPaletteProperty.EmptyFillColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html#cfn-quicksight-theme-datacolorpalette-emptyfillcolor
         */
        readonly emptyFillColor?: string;
        /**
         * `CfnTheme.DataColorPaletteProperty.MinMaxGradient`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html#cfn-quicksight-theme-datacolorpalette-minmaxgradient
         */
        readonly minMaxGradient?: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-font.html
     */
    interface FontProperty {
        /**
         * `CfnTheme.FontProperty.FontFamily`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-font.html#cfn-quicksight-theme-font-fontfamily
         */
        readonly fontFamily?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-gutterstyle.html
     */
    interface GutterStyleProperty {
        /**
         * `CfnTheme.GutterStyleProperty.Show`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-gutterstyle.html#cfn-quicksight-theme-gutterstyle-show
         */
        readonly show?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-marginstyle.html
     */
    interface MarginStyleProperty {
        /**
         * `CfnTheme.MarginStyleProperty.Show`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-marginstyle.html#cfn-quicksight-theme-marginstyle-show
         */
        readonly show?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnTheme.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html#cfn-quicksight-theme-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnTheme.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html#cfn-quicksight-theme-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html
     */
    interface SheetStyleProperty {
        /**
         * `CfnTheme.SheetStyleProperty.Tile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html#cfn-quicksight-theme-sheetstyle-tile
         */
        readonly tile?: CfnTheme.TileStyleProperty | cdk.IResolvable;
        /**
         * `CfnTheme.SheetStyleProperty.TileLayout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html#cfn-quicksight-theme-sheetstyle-tilelayout
         */
        readonly tileLayout?: CfnTheme.TileLayoutStyleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html
     */
    interface ThemeConfigurationProperty {
        /**
         * `CfnTheme.ThemeConfigurationProperty.DataColorPalette`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-datacolorpalette
         */
        readonly dataColorPalette?: CfnTheme.DataColorPaletteProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeConfigurationProperty.Sheet`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-sheet
         */
        readonly sheet?: CfnTheme.SheetStyleProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeConfigurationProperty.Typography`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-typography
         */
        readonly typography?: CfnTheme.TypographyProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeConfigurationProperty.UIColorPalette`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-uicolorpalette
         */
        readonly uiColorPalette?: CfnTheme.UIColorPaletteProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html
     */
    interface TileLayoutStyleProperty {
        /**
         * `CfnTheme.TileLayoutStyleProperty.Gutter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html#cfn-quicksight-theme-tilelayoutstyle-gutter
         */
        readonly gutter?: CfnTheme.GutterStyleProperty | cdk.IResolvable;
        /**
         * `CfnTheme.TileLayoutStyleProperty.Margin`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html#cfn-quicksight-theme-tilelayoutstyle-margin
         */
        readonly margin?: CfnTheme.MarginStyleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilestyle.html
     */
    interface TileStyleProperty {
        /**
         * `CfnTheme.TileStyleProperty.Border`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilestyle.html#cfn-quicksight-theme-tilestyle-border
         */
        readonly border?: CfnTheme.BorderStyleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-typography.html
     */
    interface TypographyProperty {
        /**
         * `CfnTheme.TypographyProperty.FontFamilies`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-typography.html#cfn-quicksight-theme-typography-fontfamilies
         */
        readonly fontFamilies?: Array<CfnTheme.FontProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html
     */
    interface UIColorPaletteProperty {
        /**
         * `CfnTheme.UIColorPaletteProperty.Accent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-accent
         */
        readonly accent?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.AccentForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-accentforeground
         */
        readonly accentForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Danger`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-danger
         */
        readonly danger?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.DangerForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-dangerforeground
         */
        readonly dangerForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Dimension`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-dimension
         */
        readonly dimension?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.DimensionForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-dimensionforeground
         */
        readonly dimensionForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Measure`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-measure
         */
        readonly measure?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.MeasureForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-measureforeground
         */
        readonly measureForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.PrimaryBackground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-primarybackground
         */
        readonly primaryBackground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.PrimaryForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-primaryforeground
         */
        readonly primaryForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.SecondaryBackground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-secondarybackground
         */
        readonly secondaryBackground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.SecondaryForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-secondaryforeground
         */
        readonly secondaryForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Success`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-success
         */
        readonly success?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.SuccessForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-successforeground
         */
        readonly successForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Warning`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-warning
         */
        readonly warning?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.WarningForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-warningforeground
         */
        readonly warningForeground?: string;
    }
}
