"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const pdk_nag_1 = require("@aws-prototyping-sdk/pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
/**
 * Creates an Identity Pool with sane defaults configured.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        if (!props?.userPool) {
            this.userPool = new aws_cognito_1.UserPool(this, "UserPool", {
                passwordPolicy: {
                    minLength: 8,
                    requireLowercase: true,
                    requireUppercase: true,
                    requireDigits: true,
                    requireSymbols: true,
                },
                mfa: aws_cognito_1.Mfa.REQUIRED,
                accountRecovery: aws_cognito_1.AccountRecovery.EMAIL_ONLY,
                autoVerify: {
                    email: true,
                },
            });
            this.userPool.node.defaultChild.userPoolAddOns = {
                advancedSecurityMode: "ENFORCED",
            };
            const stack = aws_cdk_lib_1.Stack.of(this);
            ["AwsSolutions-IAM5", "AwsPrototyping-IAMNoWildcardPermissions"].forEach((RuleId) => {
                pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${id}/UserPool/smsRole/Resource`, [
                    {
                        id: RuleId,
                        reason: "MFA requires sending a text to a users phone number which cannot be known at deployment time.",
                        appliesTo: ["Resource::*"],
                    },
                ]);
            });
            this.userPoolClient = this.userPool.addClient("WebClient", {
                authFlows: {
                    userPassword: true,
                    userSrp: true,
                },
            });
        }
        else {
            this.userPool = props.userPool;
        }
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", {
            ...props?.identityPoolOptions,
            authenticationProviders: {
                ...props?.identityPoolOptions?.authenticationProviders,
                userPools: [
                    ...(props?.identityPoolOptions?.authenticationProviders?.userPools ||
                        []),
                    ...(!props?.userPool
                        ? [
                            new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({
                                userPool: this.userPool,
                                userPoolClient: this.userPoolClient,
                            }),
                        ]
                        : []),
                ],
            },
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.12.33" };
//# sourceMappingURL=data:application/json;base64,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