# coding: utf-8

"""
    Rightfoot Student Loan Repayment

    This API provides student loan repayment. You can find out more about Rightfoot at [docs.rightfoot.com](https://docs.rightfoot.com).   # noqa: E501

    OpenAPI spec version: 1.1.0
    Contact: engineering@rightfoot.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rightfoot.api_client import ApiClient


class RightfootApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_generic_loan_to_beneficiary(self, body, **kwargs):  # noqa: E501
        """Links generic loan to beneficiary.  # noqa: E501

        NOTE: ALPHA.\\nNOTE: Currently only supports data sourced from Plaid. More generic support for other sources will be added in the future.\\n Links a loan generically to a beneficiary. This is useful for API applications, which already have loan data through their own data aggregation mechanisms and don’t need to offload and isolate the processing of that data to Rightfoot using Plaid tokens. This adds the requisite data for processing a loan payment. This does not perform any validation on the loan data like Plaid does by accessing that information directly, so data cleanliness is left to the API application.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_generic_loan_to_beneficiary(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddGenericLoanToBeneficiaryRequest body: (required)
        :return: AddGenericLoanToBeneficiaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_generic_loan_to_beneficiary_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_generic_loan_to_beneficiary_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_generic_loan_to_beneficiary_with_http_info(self, body, **kwargs):  # noqa: E501
        """Links generic loan to beneficiary.  # noqa: E501

        NOTE: ALPHA.\\nNOTE: Currently only supports data sourced from Plaid. More generic support for other sources will be added in the future.\\n Links a loan generically to a beneficiary. This is useful for API applications, which already have loan data through their own data aggregation mechanisms and don’t need to offload and isolate the processing of that data to Rightfoot using Plaid tokens. This adds the requisite data for processing a loan payment. This does not perform any validation on the loan data like Plaid does by accessing that information directly, so data cleanliness is left to the API application.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_generic_loan_to_beneficiary_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddGenericLoanToBeneficiaryRequest body: (required)
        :return: AddGenericLoanToBeneficiaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_generic_loan_to_beneficiary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_generic_loan_to_beneficiary`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/beneficiaries/addGenericLoan', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddGenericLoanToBeneficiaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_plaid_token_to_beneficiary(self, body, **kwargs):  # noqa: E501
        """Links Plaid loan to beneficiary.  # noqa: E501

        This endpoint connects an authenticated Plaid account using our Plaid public key 1773c898604f2bd4d68ecbbc8504f9. Rightfoot binds the loan accounts, exchanging the public key in the background, maintaining loan records.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_plaid_token_to_beneficiary(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddPlaidTokenToBeneficiaryRequest body: (required)
        :return: AddPlaidTokenToBeneficiaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_plaid_token_to_beneficiary_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_plaid_token_to_beneficiary_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_plaid_token_to_beneficiary_with_http_info(self, body, **kwargs):  # noqa: E501
        """Links Plaid loan to beneficiary.  # noqa: E501

        This endpoint connects an authenticated Plaid account using our Plaid public key 1773c898604f2bd4d68ecbbc8504f9. Rightfoot binds the loan accounts, exchanging the public key in the background, maintaining loan records.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_plaid_token_to_beneficiary_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddPlaidTokenToBeneficiaryRequest body: (required)
        :return: AddPlaidTokenToBeneficiaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_plaid_token_to_beneficiary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_plaid_token_to_beneficiary`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/beneficiaries/addPlaidToken', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddPlaidTokenToBeneficiaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_beneficiary(self, body, **kwargs):  # noqa: E501
        """This endpoint creates a new beneficiary.  # noqa: E501

        This endpoint creates a new beneficiary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_beneficiary(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateBeneficiaryRequest body: (required)
        :return: CreateBeneficiaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_beneficiary_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_beneficiary_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_beneficiary_with_http_info(self, body, **kwargs):  # noqa: E501
        """This endpoint creates a new beneficiary.  # noqa: E501

        This endpoint creates a new beneficiary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_beneficiary_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateBeneficiaryRequest body: (required)
        :return: CreateBeneficiaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_beneficiary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_beneficiary`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/beneficiaries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateBeneficiaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_payment(self, body, **kwargs):  # noqa: E501
        """Issues a loan payment.  # noqa: E501

        This endpoint issues a request to transfer funds from the consuming application's funding source to the beneficiary's loan account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreatePaymentRequest body: (required)
        :return: CreatePaymentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_payment_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_payment_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_payment_with_http_info(self, body, **kwargs):  # noqa: E501
        """Issues a loan payment.  # noqa: E501

        This endpoint issues a request to transfer funds from the consuming application's funding source to the beneficiary's loan account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreatePaymentRequest body: (required)
        :return: CreatePaymentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/payments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreatePaymentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment(self, uuid, **kwargs):  # noqa: E501
        """Check payment status.  # noqa: E501

        This endpoint retrieves an existing payment, updated with the latest status of its processing along with error information.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: CreatePaymentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_payment_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Check payment status.  # noqa: E501

        This endpoint retrieves an existing payment, updated with the latest status of its processing along with error information.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: CreatePaymentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/payments/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreatePaymentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
