import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a Fastly service dictionary item.
 *
 * @schema CfnDictionaryItemProps
 */
export interface CfnDictionaryItemProps {
    /**
     * Item key
     *
     * @schema CfnDictionaryItemProps#ItemKey
     */
    readonly itemKey: string;
    /**
     * Item key
     *
     * @schema CfnDictionaryItemProps#ItemValue
     */
    readonly itemValue?: string;
    /**
     * Alphanumeric string identifying a Dictionary.
     *
     * @schema CfnDictionaryItemProps#DictionaryId
     */
    readonly dictionaryId: string;
    /**
     * Alphanumeric string identifying the service. Read-only.
     *
     * @schema CfnDictionaryItemProps#ServiceId
     */
    readonly serviceId: string;
}
/**
 * Converts an object of type 'CfnDictionaryItemProps' to JSON representation.
 */
export declare function toJson_CfnDictionaryItemProps(obj: CfnDictionaryItemProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Fastly::Dictionary::DictionaryItem`
 *
 * @cloudformationResource Fastly::Dictionary::DictionaryItem
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
export declare class CfnDictionaryItem extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Fastly::Dictionary::DictionaryItem";
    /**
     * Resource props.
     */
    readonly props: CfnDictionaryItemProps;
    /**
     * Attribute `Fastly::Dictionary::DictionaryItem.CreatedAt`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrCreatedAt: string;
    /**
     * Attribute `Fastly::Dictionary::DictionaryItem.DeletedAt`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrDeletedAt: string;
    /**
     * Attribute `Fastly::Dictionary::DictionaryItem.UpdatedAt`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrUpdatedAt: string;
    /**
     * Create a new `Fastly::Dictionary::DictionaryItem`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnDictionaryItemProps);
}
