import cdk = require('@aws-cdk/cdk');
import { HostedZoneAttributes, IHostedZone } from './hosted-zone-ref';
/**
 * Zone properties for looking up the Hosted Zone
 */
export interface HostedZoneProviderProps {
    /**
     * The zone domain e.g. example.com
     */
    readonly domainName: string;
    /**
     * Is this a private zone
     */
    readonly privateZone?: boolean;
    /**
     * If this is a private zone which VPC is assocaitated
     */
    readonly vpcId?: string;
}
/**
 * Context provider that will lookup the Hosted Zone ID for the given arguments
 */
export declare class HostedZoneProvider {
    private provider;
    constructor(context: cdk.Construct, props: HostedZoneProviderProps);
    /**
     * This method calls `findHostedZone` and returns the imported hosted zone
     */
    findAndImport(scope: cdk.Construct, id: string): IHostedZone;
    /**
     * Return the hosted zone meeting the filter
     */
    findHostedZone(): HostedZoneAttributes;
}
