"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const cxapi = require("@aws-cdk/cx-api");
const hosted_zone_1 = require("./hosted-zone");
const DEFAULT_HOSTED_ZONE = {
    Id: '/hostedzone/DUMMY',
    Name: 'example.com',
};
/**
 * Context provider that will lookup the Hosted Zone ID for the given arguments
 */
class HostedZoneProvider {
    constructor(context, props) {
        this.provider = new cdk.ContextProvider(context, cxapi.HOSTED_ZONE_PROVIDER, props);
    }
    /**
     * This method calls `findHostedZone` and returns the imported hosted zone
     */
    findAndImport(scope, id) {
        return hosted_zone_1.HostedZone.fromHostedZoneAttributes(scope, id, this.findHostedZone());
    }
    /**
     * Return the hosted zone meeting the filter
     */
    findHostedZone() {
        const zone = this.provider.getValue(DEFAULT_HOSTED_ZONE);
        // CDK handles the '.' at the end, so remove it here
        if (zone.Name.endsWith('.')) {
            zone.Name = zone.Name.substring(0, zone.Name.length - 1);
        }
        return {
            hostedZoneId: zone.Id,
            zoneName: zone.Name,
        };
    }
}
exports.HostedZoneProvider = HostedZoneProvider;
//# sourceMappingURL=data:application/json;base64,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