"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const route53_generated_1 = require("../route53.generated");
const _util_1 = require("./_util");
/**
 * A DNS CNAME record
 */
class CnameRecord extends cdk_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const ttl = props.ttl === undefined ? 1800 : props.ttl;
        new route53_generated_1.CfnRecordSet(this, 'Resource', {
            hostedZoneId: props.zone.hostedZoneId,
            name: _util_1.determineFullyQualifiedDomainName(props.recordName, props.zone),
            type: 'CNAME',
            resourceRecords: [props.recordValue],
            ttl: ttl.toString(),
        });
    }
}
exports.CnameRecord = CnameRecord;
//# sourceMappingURL=data:application/json;base64,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