"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const route53_generated_1 = require("../route53.generated");
const _util_1 = require("./_util");
/**
 * A DNS TXT record
 */
class TxtRecord extends cdk_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // JSON.stringify conveniently wraps strings in " and escapes ".
        const recordValue = JSON.stringify(props.recordValue);
        const ttl = props.ttl === undefined ? 1800 : props.ttl;
        new route53_generated_1.CfnRecordSet(this, 'Resource', {
            hostedZoneId: props.zone.hostedZoneId,
            name: _util_1.determineFullyQualifiedDomainName(props.recordName, props.zone),
            type: 'TXT',
            resourceRecords: [recordValue],
            ttl: ttl.toString()
        });
    }
}
exports.TxtRecord = TxtRecord;
//# sourceMappingURL=data:application/json;base64,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