import cdk = require('@aws-cdk/cdk');
import { ZoneDelegationOptions } from '../hosted-zone';
import { IHostedZone } from '../hosted-zone-ref';
export interface ZoneDelegationRecordProps extends ZoneDelegationOptions {
    /**
     * The zone in which this delegate is defined.
     */
    readonly zone: IHostedZone;
    /**
     * The name of the zone that delegation is made to.
     */
    readonly delegatedZoneName: string;
    /**
     * The name servers to report in the delegation records.
     */
    readonly nameServers: string[];
}
/**
 * A record to delegate further lookups to a different set of name servers
 */
export declare class ZoneDelegationRecord extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props: ZoneDelegationRecordProps);
}
