"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const route53 = require("../lib");
module.exports = {
    'with default ttl'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        const zone = new route53.HostedZone(stack, 'HostedZone', {
            zoneName: 'myzone'
        });
        new route53.CnameRecord(stack, 'MyCname', {
            zone,
            recordName: 'www',
            recordValue: 'zzz',
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Route53::RecordSet', {
            Name: "www.myzone.",
            Type: "CNAME",
            HostedZoneId: {
                Ref: "HostedZoneDB99F866"
            },
            ResourceRecords: [
                "zzz"
            ],
            TTL: "1800"
        }));
        test.done();
    },
    'with custom ttl'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        const zone = new route53.HostedZone(stack, 'HostedZone', {
            zoneName: 'myzone'
        });
        new route53.CnameRecord(stack, 'MyCname', {
            zone,
            recordName: 'aa',
            recordValue: 'bbb',
            ttl: 6077,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Route53::RecordSet', {
            Name: "aa.myzone.",
            Type: "CNAME",
            HostedZoneId: {
                Ref: "HostedZoneDB99F866"
            },
            ResourceRecords: [
                "bbb"
            ],
            TTL: "6077"
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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