"use strict";
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'Hosted Zone Provider': {
        'HostedZoneProvider will return context values if availble'(test) {
            // GIVEN
            const stack = new cdk.Stack(undefined, 'TestStack', { env: { account: '12345', region: 'us-east-1' } });
            const filter = { domainName: 'test.com' };
            new lib_1.HostedZoneProvider(stack, filter).findHostedZone();
            const key = Object.keys(stack.missingContext)[0];
            const fakeZone = {
                Id: "/hostedzone/11111111111111",
                Name: "example.com.",
                CallerReference: "TestLates-PublicZo-OESZPDFV7G6A",
                Config: {
                    Comment: "CDK created",
                    PrivateZone: false
                },
                ResourceRecordSetCount: 3
            };
            stack.node.setContext(key, fakeZone);
            const cdkZoneProps = {
                hostedZoneId: fakeZone.Id,
                zoneName: 'example.com',
            };
            const cdkZone = lib_1.HostedZone.fromHostedZoneAttributes(stack, 'MyZone', cdkZoneProps);
            // WHEN
            const provider = new lib_1.HostedZoneProvider(stack, filter);
            const zoneProps = stack.node.resolve(provider.findHostedZone());
            const zoneRef = provider.findAndImport(stack, 'MyZoneProvider');
            // THEN
            test.deepEqual(zoneProps, cdkZoneProps);
            test.deepEqual(zoneRef.hostedZoneId, cdkZone.hostedZoneId);
            test.done();
        },
    }
};
//# sourceMappingURL=data:application/json;base64,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