"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
class TestApp {
    constructor() {
        this.app = new cdk_1.App();
        const account = '123456789012';
        const region = 'bermuda-triangle';
        this.app.node.setContext(`availability-zones:${account}:${region}`, [`${region}-1a`]);
        this.stack = new cdk_1.Stack(this.app, 'MyStack', { env: { account, region } });
    }
    synthesizeTemplate() {
        return this.app.synthesizeStack(this.stack.name);
    }
}
module.exports = {
    'Zone Delegation records': {
        NS(test) {
            const app = new TestApp();
            const zone = new lib_1.PublicHostedZone(app.stack, 'HostedZone', { zoneName: 'test.public' });
            new lib_1.ZoneDelegationRecord(zone, 'NS', {
                zone,
                delegatedZoneName: 'foo',
                nameServers: ['ns-1777.awsdns-30.co.uk']
            });
            assert_1.expect(app.synthesizeTemplate()).to(assert_1.exactlyMatchTemplate({
                Resources: {
                    HostedZoneDB99F866: {
                        Type: 'AWS::Route53::HostedZone',
                        Properties: {
                            Name: 'test.public.'
                        }
                    },
                    HostedZoneNS1BB87CC3: {
                        Type: 'AWS::Route53::RecordSet',
                        Properties: {
                            HostedZoneId: {
                                Ref: 'HostedZoneDB99F866'
                            },
                            Name: 'foo.test.public.',
                            ResourceRecords: ['ns-1777.awsdns-30.co.uk.'],
                            Type: 'NS',
                            TTL: '172800'
                        }
                    }
                }
            }));
            test.done();
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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