STATUS_CLASSES = {
    "Suspected": "warning",
    "False Positive": "success",
    "Verified": "danger",
    "Probable": "warning",
    "False Negative": "danger",
    "Other": "warning",
    "Failed": "danger",
}

CHROM_ABNORM = ["13", "18", "21", "X0", "XXX", "XXY", "XYY"]
TRIS_CHROM_ABNORM = ["13", "18", "21"]
SEX_CHROM_ABNORM = ["X0", "XXX", "XXY", "XYY"]
STATUS_COLORS = {
    "Suspected": "#DBA901",
    "Probable": "#0000FF",
    "False Negative": "#ff6699",
    "Verified": "#00CC00",
    "Other": "#603116",
    "False Positive": "#E74C3C",
}

TRISOMI_TRESHOLDS = {
    "soft_max": {"Zscore": 2.5, "color": "orange", "text": "Warning threshold = 2.5"},
    "soft_min": {"Zscore": -4, "color": "orange", "text": "Warning threshold = -4"},
    "hard_max": {"Zscore": 4, "color": "red", "text": "Threshold = 4"},
    "hard_min": {"Zscore": -5, "color": "red", "text": "Threshold = -5"},
}

FF_TRESHOLDS = {
    "fetal_fraction_preface": 4,
    "fetal_fraction_y_max": 3,
    "fetal_fraction_y_min": 0.6,
    "fetal_fraction_XXX": -1,
    "fetal_fraction_X0": 3.4,
    "y_axis_min": -1,
    "y_axis_max": 20,
    "k_upper": 0.9809,
    "k_lower": 0.9799,
    "m_lower": -4.3987,
    "m_upper": 6.5958,
}

COLORS = [
    "#0b7b47",
    "#ff0000",
    "#000000",
    "#808000",
    "#0e58a8",
    "#800080",
    "#60fdfa",
    "#4c0000",
    "#2593ff",
    "#6785be",
    "#FF00FF",
    "#e2d9e2",
    "#aefdff",
    "#9ebbc9",
    "#471340",
    "#e1e9d1",
    "#ffa700",
    "#7478fc",
    "#9700ff",
    "#003786",
    "#4682B4",
    "#ba6657",
    "#313131",
    "#f3d573",
    "#808080",
    "#3d019d",
    "#2adef6",
    "#08ff00",
    "#800000",
    "#00ff9f",
    "#820000",
    "#9be4ef",
    "#000080",
    "#afff00",
    "#2d47f9",
    "#FFA500",
    "#ff00bf",
    "#e7b000",
    "#FF0000",
    "#97023d",
    "#217eb8",
    "#c65400",
    "#ac2301",
    "#fafd5b",
    "#f3f3f1",
    "#421257",
    "#7b0b3f",
    "#30a4ca",
    "#8e2c50",
    "#3810dc",
    "#5e43a5",
    "#008080",
    "#FFB6C1",
    "#008000",
    "#f7da29",
    "#FFFF00",
    "#00b7ff",
    "#001f4d",
    "#54c8df",
    "#C0C0C0",
    "#da8200",
    "#fffda9",
    "#ceac94",
]
