"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScaler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_autoscaling_1 = require("@aws-cdk/aws-autoscaling");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_elasticloadbalancingv2_1 = require("@aws-cdk/aws-elasticloadbalancingv2");
const iam = require("@aws-cdk/aws-iam");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class AutoScaler extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const launchTemplate = this.getLT(props.templateProps, props.asgName);
        const tgArn = this.getTG(props.tgProps, props.templateProps.vpc.vpcName);
        new aws_autoscaling_1.CfnAutoScalingGroup(this, props.asgName, {
            maxSize: props.maxSize,
            minSize: props.minSize,
            autoScalingGroupName: props.asgName,
            launchTemplate: {
                version: launchTemplate.versionNumber,
                launchTemplateId: launchTemplate.launchTemplateId,
                launchTemplateName: launchTemplate.launchTemplateName,
            },
            targetGroupArns: tgArn,
            tags: props.tags,
            availabilityZones: ['ap-south-1a', 'ap-south-1b'],
            vpcZoneIdentifier: props.subnets,
            healthCheckGracePeriod: 300,
        });
        if (tgArn.length) {
            this.targetGroupArn = tgArn[0];
        }
        this.targetGroupArn = '';
    }
    getVPC(props) {
        const stackVPC = aws_ec2_1.Vpc.fromLookup(this, props.vpcName, {
            isDefault: false,
            vpcId: props.vpcName,
        });
        return stackVPC;
    }
    getRole(props, asgName) {
        if (props.type == 'existing') {
            const role = iam.Role.fromRoleArn(this, asgName + '-stackRole', props.roleArn);
            return role;
        }
        else {
            const role = new iam.Role(this, asgName + '-stackRole', {
                assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
                roleName: asgName + '-role',
            });
            role.addManagedPolicy({
                managedPolicyArn: 'arn:aws:iam::aws:policy/service-role/AmazonEC2SpotFleetTaggingRole',
            });
            role.addManagedPolicy({
                managedPolicyArn: 'arn:aws:iam::aws:policy/ReadOnlyAccess',
            });
            role.addManagedPolicy({
                managedPolicyArn: 'arn:aws:iam::aws:policy/service-role/AmazonEC2RoleforSSM',
            });
            role.addManagedPolicy({
                managedPolicyArn: 'arn:aws:iam::aws:policy/AmazonEC2FullAccess',
            });
            role.addManagedPolicy({
                managedPolicyArn: 'arn:aws:iam::736414281642:policy/SynUsers',
            });
            role.addToPolicy(aws_iam_1.PolicyStatement.fromJson({
                Version: '2012-10-17',
                Statement: [
                    {
                        Effect: 'Allow',
                        Action: [
                            'iam:ListUsers',
                            'iam:GetGroup',
                        ],
                        Resource: '*',
                    },
                    {
                        Effect: 'Allow',
                        Action: [
                            'iam:GetSSHPublicKey',
                            'iam:ListSSHPublicKeys',
                        ],
                        Resource: [
                            'arn:aws:iam::736414281642:user/*',
                        ],
                    },
                    {
                        Effect: 'Allow',
                        Action: 'ec2:DescribeTags',
                        Resource: '*',
                    },
                ],
            }));
            role.addToPolicy(aws_iam_1.PolicyStatement.fromJson({
                Version: '2012-10-17',
                Statement: [
                    {
                        Sid: 'VisualEditor0',
                        Effect: 'Allow',
                        Action: [
                            'ec2:DescribeInstances',
                            'ec2:DescribeTags',
                        ],
                        Resource: '*',
                    },
                ],
            }));
            return role;
        }
    }
    getSG(props, vpc, asgName) {
        var _b, _c, _d;
        if (props.type == 'existing') {
            const securityGroup = aws_ec2_1.SecurityGroup.fromSecurityGroupId(this, 'stack-sg', props.sgGroupId);
            return securityGroup;
        }
        else {
            const sgProps = {
                securityGroupName: (_b = props.securityGroupName) !== null && _b !== void 0 ? _b : 'stack-sg-group',
                vpc: vpc,
                allowAllOutbound: (_c = props.allowAllOutbound) !== null && _c !== void 0 ? _c : true,
                disableInlineRules: (_d = props.disableInlineRules) !== null && _d !== void 0 ? _d : false,
            };
            const securityGroup = new aws_ec2_1.SecurityGroup(this, asgName + '-stack-sg', sgProps);
            props.ingressRules.forEach(ingress => {
                var _b;
                const ingressSG = aws_ec2_1.SecurityGroup.fromSecurityGroupId(this, ingress.sourceSG + ingress.port.toString(), ingress.sourceSG);
                securityGroup.connections.allowFrom(ingressSG, aws_ec2_1.Port.tcp(ingress.port), (_b = ingress.description) !== null && _b !== void 0 ? _b : 'Application port');
            });
            return securityGroup;
        }
    }
    getBD(props) {
        const bd = {
            deviceName: props.name,
            volume: aws_ec2_1.BlockDeviceVolume.ebs(props.size, {
                volumeType: props.type,
                deleteOnTermination: true,
            }),
        };
        return bd;
    }
    getLT(props, asgName) {
        if (props.type == 'existing') {
            const launchTemplate = aws_ec2_1.LaunchTemplate.fromLaunchTemplateAttributes(this, props.templateName, props.existingAttributes);
            return launchTemplate;
        }
        else {
            const launchTemplate = new aws_ec2_1.LaunchTemplate(this, props.templateName, {
                launchTemplateName: props.templateName,
                instanceType: new aws_ec2_1.InstanceType(props.instanceType),
                machineImage: aws_ec2_1.MachineImage.lookup({
                    name: props.amiImageId,
                }),
                securityGroup: this.getSG(props.securityGroup, this.getVPC(props.vpc), asgName),
                role: this.getRole(props.role, asgName),
                detailedMonitoring: false,
                blockDevices: [this.getBD(props.blockDevice)],
                keyName: props.sshKey,
            });
            return launchTemplate;
        }
    }
    getTG(props, vpcId) {
        if (props != undefined) {
            const tg = new aws_elasticloadbalancingv2_1.CfnTargetGroup(this, props.name, {
                name: props.name,
                healthCheckEnabled: true,
                healthCheckPath: props.healthPath,
                ...((props.protocol == 'GRPC') ? { protocol: 'HTTP' } : { protocol: props.protocol }),
                ...((props.protocol == 'GRPC') ? { protocolVersion: 'GRPC' } : {}),
                healthCheckTimeoutSeconds: props.timeout,
                healthCheckPort: String(props.port),
                port: props.port,
                vpcId: vpcId,
            });
            return [tg.ref];
        }
        else {
            return [];
        }
    }
}
exports.AutoScaler = AutoScaler;
_a = JSII_RTTI_SYMBOL_1;
AutoScaler[_a] = { fqn: "@smallcase/aws-cdk-microservice.AutoScaler", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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