import { CfnAutoScalingGroup } from '@aws-cdk/aws-autoscaling';
import { SubnetType } from '@aws-cdk/aws-ec2';
import { Construct } from '@aws-cdk/core';
import { IngressRule } from './autoScalingGroup';
/**
 * @stability stable
 */
export interface MicroServiceProps {
    /**
     * @stability stable
     */
    readonly env: string;
    /**
     * @stability stable
     */
    readonly instanceType?: string;
    /**
     * @stability stable
     */
    readonly appName: string;
    /**
     * @stability stable
     */
    readonly volumeSize?: number;
    /**
     * @stability stable
     */
    readonly asgMaxSize?: string;
    /**
     * @stability stable
     */
    readonly asgMinSize?: string;
    /**
     * @stability stable
     */
    readonly instanceLabels?: CfnAutoScalingGroup.TagPropertyProperty[];
    /**
     * @stability stable
     */
    readonly healthCheckPath?: string;
    /**
     * @stability stable
     */
    readonly port?: number;
    /**
     * @stability stable
     */
    readonly vpc: string;
    /**
     * @stability stable
     */
    readonly subnetClass?: SubnetType;
    /**
     * @stability stable
     */
    readonly subnets: string[];
    /**
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * @stability stable
     */
    readonly diskSize?: number;
    /**
     * @stability stable
     */
    readonly role?: string;
    /**
     * @stability stable
     */
    readonly tcpRules?: IngressRule[];
    /**
     * @stability stable
     */
    readonly sslEnabled?: boolean;
    /**
     * @stability stable
     */
    readonly host?: string;
    /**
     * @stability stable
     */
    readonly lbArn?: string;
    /**
     * @stability stable
     */
    readonly ami?: string;
    /**
     * @stability stable
     */
    readonly sshKey: string;
    /**
     * @stability stable
     */
    readonly createCodedeployApplication?: boolean;
}
/**
 * @stability stable
 */
export declare class MicroService extends Construct {
    /**
     * @stability stable
     */
    readonly instanceType?: string;
    /**
     * @stability stable
     */
    readonly appName?: string;
    /**
     * @stability stable
     */
    readonly volumeSize?: number;
    /**
     * @stability stable
     */
    readonly asgMaxSize?: string;
    /**
     * @stability stable
     */
    readonly asgMinSize?: string;
    /**
     * @stability stable
     */
    readonly env?: string;
    /**
     * @stability stable
     */
    readonly instanceLabels?: CfnAutoScalingGroup.TagPropertyProperty[];
    /**
     * @stability stable
     */
    readonly healthCheckPath?: string;
    /**
     * @stability stable
     */
    readonly port?: number;
    /**
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * @stability stable
     */
    readonly diskSize?: number;
    /**
     * @stability stable
     */
    readonly vpc: string;
    /**
     * @stability stable
     */
    readonly subnetType?: SubnetType;
    /**
     * @stability stable
     */
    readonly role?: string;
    /**
     * @stability stable
     */
    readonly tcpRules?: IngressRule[];
    /**
     * @stability stable
     */
    readonly subnets: string[];
    /**
     * @stability stable
     */
    readonly sslEnabled?: boolean;
    /**
     * @stability stable
     */
    readonly host?: string;
    /**
     * @stability stable
     */
    readonly lbArn?: string;
    /**
     * @stability stable
     */
    readonly sshKey: string;
    /**
     * @stability stable
     */
    readonly createCodedeployApplication?: boolean;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: MicroServiceProps);
    private getDeploymentGroupRole;
}
