# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cythereal_magic.api_client import ApiClient


class AlphaApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_binary(self, binary_id, **kwargs):  # noqa: E501
        """Add public binaries to your account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_binary(binary_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] binary_id: The SHA1 of the binary to add to your collection. Specify parameter multiple times to add multiple binaries.  Only public binaries will be added. The list of successfully added binaries will be in the 'data' key  (required)
        :return: FilesAddedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_binary_with_http_info(binary_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_binary_with_http_info(binary_id, **kwargs)  # noqa: E501
            return data

    def add_binary_with_http_info(self, binary_id, **kwargs):  # noqa: E501
        """Add public binaries to your account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_binary_with_http_info(binary_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] binary_id: The SHA1 of the binary to add to your collection. Specify parameter multiple times to add multiple binaries.  Only public binaries will be added. The list of successfully added binaries will be in the 'data' key  (required)
        :return: FilesAddedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['binary_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_binary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'binary_id' is set
        if ('binary_id' not in params or
                params['binary_id'] is None):
            raise ValueError("Missing the required parameter `binary_id` when calling `add_binary`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'binary_id' in params:
            query_params.append(('binary_id', params['binary_id']))  # noqa: E501
            collection_formats['binary_id'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/add/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilesAddedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def check_access(self, file_hash, **kwargs):  # noqa: E501
        """Returns a success if the user has access to this file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_access(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.check_access_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.check_access_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def check_access_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Returns a success if the user has access to this file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_access_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method check_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `check_access`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `check_access`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/{file_hash}/check_access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_campaign_info(self, campaign_id, **kwargs):  # noqa: E501
        """List available information for the campaign id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_campaign_info(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str campaign_id: The ID of a campaign. Equal to the binary_id of a random binary in the campaign. (required)
        :return: CampaignInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_campaign_info_with_http_info(campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_campaign_info_with_http_info(campaign_id, **kwargs)  # noqa: E501
            return data

    def get_campaign_info_with_http_info(self, campaign_id, **kwargs):  # noqa: E501
        """List available information for the campaign id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_campaign_info_with_http_info(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str campaign_id: The ID of a campaign. Equal to the binary_id of a random binary in the campaign. (required)
        :return: CampaignInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_campaign_info`")  # noqa: E501

        if 'campaign_id' in params and not re.search(r'[a-fA-F0-9]{40}', params['campaign_id']):  # noqa: E501
            raise ValueError("Invalid value for parameter `campaign_id` when calling `get_campaign_info`, must conform to the pattern `/[a-fA-F0-9]{40}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaign_id'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/campaigns/{campaign_id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CampaignInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_campaign_members(self, campaign_id, **kwargs):  # noqa: E501
        """Members of the campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_campaign_members(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str campaign_id: The ID of a campaign. Equal to the binary_id of a random binary in the campaign. (required)
        :return: CampaignMembersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_campaign_members_with_http_info(campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_campaign_members_with_http_info(campaign_id, **kwargs)  # noqa: E501
            return data

    def get_campaign_members_with_http_info(self, campaign_id, **kwargs):  # noqa: E501
        """Members of the campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_campaign_members_with_http_info(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str campaign_id: The ID of a campaign. Equal to the binary_id of a random binary in the campaign. (required)
        :return: CampaignMembersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_campaign_members`")  # noqa: E501

        if 'campaign_id' in params and not re.search(r'[a-fA-F0-9]{40}', params['campaign_id']):  # noqa: E501
            raise ValueError("Invalid value for parameter `campaign_id` when calling `get_campaign_members`, must conform to the pattern `/[a-fA-F0-9]{40}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaign_id'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/campaigns/{campaign_id}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CampaignMembersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email(self, email_id, **kwargs):  # noqa: E501
        """Returns a specific email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email(email_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email_id: A hash id for email objects (required)
        :return: EmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_with_http_info(email_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_with_http_info(email_id, **kwargs)  # noqa: E501
            return data

    def get_email_with_http_info(self, email_id, **kwargs):  # noqa: E501
        """Returns a specific email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_with_http_info(email_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email_id: A hash id for email objects (required)
        :return: EmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_id' is set
        if ('email_id' not in params or
                params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `get_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email_id' in params:
            path_params['email_id'] = params['email_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/iocs/emails/{email_id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_emails(self, **kwargs):  # noqa: E501
        """Returns all emails connected to the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_emails(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EmailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_emails_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_emails_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_emails_with_http_info(self, **kwargs):  # noqa: E501
        """Returns all emails connected to the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_emails_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EmailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_emails" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/iocs/emails/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_iocs(self, file_hash, **kwargs):  # noqa: E501
        """Returns iocs extracted from an uploaded csv/txt/xml file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_iocs(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: IocFileResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_iocs_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_iocs_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def get_file_iocs_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Returns iocs extracted from an uploaded csv/txt/xml file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_iocs_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: IocFileResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_iocs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_file_iocs`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_file_iocs`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/iocs/files/{file_hash}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IocFileResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_status(self, file_hash, **kwargs):  # noqa: E501
        """Get processing status of the file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_status(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: FileStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_status_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_status_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def get_file_status_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Get processing status of the file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_status_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: FileStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_file_status`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_file_status`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/{file_hash}/status/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ioc_files(self, **kwargs):  # noqa: E501
        """Returns all uploaded csv/txt/xml ioc files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ioc_files(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: IocFilesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ioc_files_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ioc_files_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ioc_files_with_http_info(self, **kwargs):  # noqa: E501
        """Returns all uploaded csv/txt/xml ioc files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ioc_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: IocFilesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ioc_files" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/iocs/files/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IocFilesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_iocs(self, **kwargs):  # noqa: E501
        """List iocs owned by the authenticated user.  # noqa: E501

        List IoCs owned by the authenticated user.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_iocs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: OwnedIoCsListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_iocs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_iocs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_iocs_with_http_info(self, **kwargs):  # noqa: E501
        """List iocs owned by the authenticated user.  # noqa: E501

        List IoCs owned by the authenticated user.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_iocs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: OwnedIoCsListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_iocs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/iocs/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OwnedIoCsListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_magic_yara(self, binary_id, **kwargs):  # noqa: E501
        """\"Generate a yara rule, and campaign information for  the provided binaries.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_magic_yara(binary_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] binary_id: The SHA1 of the binary to get yara for.  Specify parameter multiple  times to include multiple binaries in the rule.  The generated rule  will attempt to cover all included binaries.  (required)
        :param str name: The custom name to give the yara rule. The rule name will always take the form of:   CythMAGIC_\\<name>_\\<config> 
        :param str config: The name of the config file to use when creating the yara rule. The config files will determine what criteria to use when creating the rule, and are predefined at this time. 
        :param bool unpacked: If true, return the yara rule for the unpacked binaries.
        :param bool debug: If true, add rejected signatures as yara rule metadata. 
        :return: MagicYaraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_magic_yara_with_http_info(binary_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_magic_yara_with_http_info(binary_id, **kwargs)  # noqa: E501
            return data

    def get_magic_yara_with_http_info(self, binary_id, **kwargs):  # noqa: E501
        """\"Generate a yara rule, and campaign information for  the provided binaries.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_magic_yara_with_http_info(binary_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] binary_id: The SHA1 of the binary to get yara for.  Specify parameter multiple  times to include multiple binaries in the rule.  The generated rule  will attempt to cover all included binaries.  (required)
        :param str name: The custom name to give the yara rule. The rule name will always take the form of:   CythMAGIC_\\<name>_\\<config> 
        :param str config: The name of the config file to use when creating the yara rule. The config files will determine what criteria to use when creating the rule, and are predefined at this time. 
        :param bool unpacked: If true, return the yara rule for the unpacked binaries.
        :param bool debug: If true, add rejected signatures as yara rule metadata. 
        :return: MagicYaraResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['binary_id', 'name', 'config', 'unpacked', 'debug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_magic_yara" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'binary_id' is set
        if ('binary_id' not in params or
                params['binary_id'] is None):
            raise ValueError("Missing the required parameter `binary_id` when calling `get_magic_yara`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'binary_id' in params:
            query_params.append(('binary_id', params['binary_id']))  # noqa: E501
            collection_formats['binary_id'] = 'multi'  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'config' in params:
            query_params.append(('config', params['config']))  # noqa: E501
        if 'unpacked' in params:
            query_params.append(('unpacked', params['unpacked']))  # noqa: E501
        if 'debug' in params:
            query_params.append(('debug', params['debug']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/signatures/magic_yara/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MagicYaraResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_procedure_signatures(self, binary_id, **kwargs):  # noqa: E501
        """Generate procedure signatures for provided binaries.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_procedure_signatures(binary_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] binary_id: The SHA1 of the binary to get yara for.  Specify parameter multiple  times to include multiple binaries in the rule.  The generated rule  will attempt to cover all included binaries.  (required)
        :param bool unpacked: If true, return the procedures for the unpacked binaries.
        :return: ProcedureSignaturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_procedure_signatures_with_http_info(binary_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_procedure_signatures_with_http_info(binary_id, **kwargs)  # noqa: E501
            return data

    def get_procedure_signatures_with_http_info(self, binary_id, **kwargs):  # noqa: E501
        """Generate procedure signatures for provided binaries.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_procedure_signatures_with_http_info(binary_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] binary_id: The SHA1 of the binary to get yara for.  Specify parameter multiple  times to include multiple binaries in the rule.  The generated rule  will attempt to cover all included binaries.  (required)
        :param bool unpacked: If true, return the procedures for the unpacked binaries.
        :return: ProcedureSignaturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['binary_id', 'unpacked']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_procedure_signatures" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'binary_id' is set
        if ('binary_id' not in params or
                params['binary_id'] is None):
            raise ValueError("Missing the required parameter `binary_id` when calling `get_procedure_signatures`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'binary_id' in params:
            query_params.append(('binary_id', params['binary_id']))  # noqa: E501
            collection_formats['binary_id'] = 'multi'  # noqa: E501
        if 'unpacked' in params:
            query_params.append(('unpacked', params['unpacked']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/signatures/procedures/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProcedureSignaturesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_procedures_report(self, proc_hash, **kwargs):  # noqa: E501
        """Generate the report for the given procedures  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_procedures_report(proc_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str proc_hash: A cryptographic hash of an individual procedure. Hash is an MD5. (required)
        :param int limit: Number of procedures to return per call
        :param int page: Number of pages per (limit) to skip
        :return: ProcedureReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_procedures_report_with_http_info(proc_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_procedures_report_with_http_info(proc_hash, **kwargs)  # noqa: E501
            return data

    def get_procedures_report_with_http_info(self, proc_hash, **kwargs):  # noqa: E501
        """Generate the report for the given procedures  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_procedures_report_with_http_info(proc_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str proc_hash: A cryptographic hash of an individual procedure. Hash is an MD5. (required)
        :param int limit: Number of procedures to return per call
        :param int page: Number of pages per (limit) to skip
        :return: ProcedureReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['proc_hash', 'limit', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_procedures_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'proc_hash' is set
        if ('proc_hash' not in params or
                params['proc_hash'] is None):
            raise ValueError("Missing the required parameter `proc_hash` when calling `get_procedures_report`")  # noqa: E501

        if 'proc_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['proc_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `proc_hash` when calling `get_procedures_report`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'proc_hash' in params:
            path_params['proc_hash'] = params['proc_hash']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/procedures/{proc_hash}/report', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProcedureReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_yara_rule(self, binary_id, **kwargs):  # noqa: E501
        """Generate a yara rule for the provided binaries.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_yara_rule(binary_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] binary_id: The SHA1 of the binary to get yara for.  Specify parameter multiple  times to include multiple binaries in the rule.  The generated rule  will attempt to cover all included binaries.  (required)
        :param str name: The custom name to give the yara rule. The rule name will always take the form of:   CythMAGIC_\\<name>_\\<config> 
        :param str config: The name of the config file to use when creating the yara rule. The config files will determine what criteria to use when creating the rule, and are predefined at this time. 
        :param bool unpacked: If true, return the yara rule for the unpacked binaries.
        :param bool debug: If true, add rejected signatures as yara rule metadata. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_yara_rule_with_http_info(binary_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_yara_rule_with_http_info(binary_id, **kwargs)  # noqa: E501
            return data

    def get_yara_rule_with_http_info(self, binary_id, **kwargs):  # noqa: E501
        """Generate a yara rule for the provided binaries.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_yara_rule_with_http_info(binary_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] binary_id: The SHA1 of the binary to get yara for.  Specify parameter multiple  times to include multiple binaries in the rule.  The generated rule  will attempt to cover all included binaries.  (required)
        :param str name: The custom name to give the yara rule. The rule name will always take the form of:   CythMAGIC_\\<name>_\\<config> 
        :param str config: The name of the config file to use when creating the yara rule. The config files will determine what criteria to use when creating the rule, and are predefined at this time. 
        :param bool unpacked: If true, return the yara rule for the unpacked binaries.
        :param bool debug: If true, add rejected signatures as yara rule metadata. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['binary_id', 'name', 'config', 'unpacked', 'debug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_yara_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'binary_id' is set
        if ('binary_id' not in params or
                params['binary_id'] is None):
            raise ValueError("Missing the required parameter `binary_id` when calling `get_yara_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'binary_id' in params:
            query_params.append(('binary_id', params['binary_id']))  # noqa: E501
            collection_formats['binary_id'] = 'multi'  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'config' in params:
            query_params.append(('config', params['config']))  # noqa: E501
        if 'unpacked' in params:
            query_params.append(('unpacked', params['unpacked']))  # noqa: E501
        if 'debug' in params:
            query_params.append(('debug', params['debug']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/signatures/yara/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def make_file_public(self, file_hash, **kwargs):  # noqa: E501
        """Allows a user to make their file public  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.make_file_public(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.make_file_public_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.make_file_public_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def make_file_public_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Allows a user to make their file public  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.make_file_public_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method make_file_public" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `make_file_public`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `make_file_public`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/{file_hash}/make_public', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_iocs_file(self, filedata, **kwargs):  # noqa: E501
        """Upload a text or csv file for IoC Extraction  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_iocs_file(filedata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file filedata: CSV or text file containing IoCs (required)
        :return: IoCUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_iocs_file_with_http_info(filedata, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_iocs_file_with_http_info(filedata, **kwargs)  # noqa: E501
            return data

    def upload_iocs_file_with_http_info(self, filedata, **kwargs):  # noqa: E501
        """Upload a text or csv file for IoC Extraction  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_iocs_file_with_http_info(filedata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file filedata: CSV or text file containing IoCs (required)
        :return: IoCUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filedata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_iocs_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'filedata' is set
        if ('filedata' not in params or
                params['filedata'] is None):
            raise ValueError("Missing the required parameter `filedata` when calling `upload_iocs_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'filedata' in params:
            local_var_files['filedata'] = params['filedata']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/iocs/files/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoCUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
