# gooddata-afm-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0
- Package version: 1.3.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import gooddata_afm_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import gooddata_afm_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import gooddata_afm_client
from pprint import pprint
from gooddata_afm_client.api import computation_api
from gooddata_afm_client.model.afm_execution import AfmExecution
from gooddata_afm_client.model.afm_execution_response import AfmExecutionResponse
from gooddata_afm_client.model.afm_valid_objects_query import AfmValidObjectsQuery
from gooddata_afm_client.model.afm_valid_objects_response import AfmValidObjectsResponse
from gooddata_afm_client.model.elements_request import ElementsRequest
from gooddata_afm_client.model.elements_response import ElementsResponse
from gooddata_afm_client.model.execution_result import ExecutionResult
from gooddata_afm_client.model.result_cache_metadata import ResultCacheMetadata
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = gooddata_afm_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with gooddata_afm_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = computation_api.ComputationApi(api_client)
    workspace_id = "/6bUUGjjNSwg0_bs" # str | Workspace identifier
    elements_request = ElementsRequest(
        complement_filter=False,
        data_sampling_percentage=100,
        exact_filter=[
            "exact_filter_example",
        ],
        exclude_primary_label=False,
        filter_by=FilterBy(
            label_type="REQUESTED",
        ),
        label="label_example",
        pattern_filter="pattern_filter_example",
        sort_order="ASC",
    ) # ElementsRequest | 
    offset = 0 # int | Request page with this offset. Must be positive integer. The API is limited to the maximum of 10000 items. Therefore this parameter is limited to this number as well. (optional) (default to 0)
    limit = 1000 # int | Return only this number of items. Must be positive integer. The API is limited to the maximum of 10000 items. Therefore this parameter is limited to this number as well. (optional) (default to 1000)
    skip_cache = False # bool | Ignore all caches during execution of current request. (optional) (default to False)

    try:
        # Listing of label values. The resulting data are limited by the static platform limit to the maximum of 10000 rows.
        api_response = api_instance.compute_label_elements_post(workspace_id, elements_request, offset=offset, limit=limit, skip_cache=skip_cache)
        pprint(api_response)
    except gooddata_afm_client.ApiException as e:
        print("Exception when calling ComputationApi->compute_label_elements_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ComputationApi* | [**compute_label_elements_post**](docs/ComputationApi.md#compute_label_elements_post) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/collectLabelElements | Listing of label values. The resulting data are limited by the static platform limit to the maximum of 10000 rows.
*ComputationApi* | [**compute_report**](docs/ComputationApi.md#compute_report) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute | Executes analytical request and returns link to the result
*ComputationApi* | [**compute_valid_objects**](docs/ComputationApi.md#compute_valid_objects) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/computeValidObjects | Valid objects
*ComputationApi* | [**explain_afm**](docs/ComputationApi.md#explain_afm) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/explain | AFM explain resource.
*ComputationApi* | [**retrieve_execution_metadata**](docs/ComputationApi.md#retrieve_execution_metadata) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute/result/{resultId}/metadata | Get a single execution result&#39;s metadata.
*ComputationApi* | [**retrieve_result**](docs/ComputationApi.md#retrieve_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute/result/{resultId} | Get a single execution result
*ActionsApi* | [**compute_label_elements_post**](docs/ActionsApi.md#compute_label_elements_post) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/collectLabelElements | Listing of label values. The resulting data are limited by the static platform limit to the maximum of 10000 rows.
*ActionsApi* | [**compute_report**](docs/ActionsApi.md#compute_report) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute | Executes analytical request and returns link to the result
*ActionsApi* | [**compute_valid_objects**](docs/ActionsApi.md#compute_valid_objects) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/computeValidObjects | Valid objects
*ActionsApi* | [**explain_afm**](docs/ActionsApi.md#explain_afm) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/explain | AFM explain resource.
*ActionsApi* | [**retrieve_execution_metadata**](docs/ActionsApi.md#retrieve_execution_metadata) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute/result/{resultId}/metadata | Get a single execution result&#39;s metadata.
*ActionsApi* | [**retrieve_result**](docs/ActionsApi.md#retrieve_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute/result/{resultId} | Get a single execution result


## Documentation For Models

 - [AFM](docs/AFM.md)
 - [AbsoluteDateFilter](docs/AbsoluteDateFilter.md)
 - [AbsoluteDateFilterAbsoluteDateFilter](docs/AbsoluteDateFilterAbsoluteDateFilter.md)
 - [AbstractMeasureValueFilter](docs/AbstractMeasureValueFilter.md)
 - [AfmExecution](docs/AfmExecution.md)
 - [AfmExecutionResponse](docs/AfmExecutionResponse.md)
 - [AfmIdentifier](docs/AfmIdentifier.md)
 - [AfmLocalIdentifier](docs/AfmLocalIdentifier.md)
 - [AfmObjectIdentifier](docs/AfmObjectIdentifier.md)
 - [AfmObjectIdentifierAttribute](docs/AfmObjectIdentifierAttribute.md)
 - [AfmObjectIdentifierAttributeIdentifier](docs/AfmObjectIdentifierAttributeIdentifier.md)
 - [AfmObjectIdentifierCore](docs/AfmObjectIdentifierCore.md)
 - [AfmObjectIdentifierCoreIdentifier](docs/AfmObjectIdentifierCoreIdentifier.md)
 - [AfmObjectIdentifierDataset](docs/AfmObjectIdentifierDataset.md)
 - [AfmObjectIdentifierDatasetIdentifier](docs/AfmObjectIdentifierDatasetIdentifier.md)
 - [AfmObjectIdentifierIdentifier](docs/AfmObjectIdentifierIdentifier.md)
 - [AfmObjectIdentifierLabel](docs/AfmObjectIdentifierLabel.md)
 - [AfmObjectIdentifierLabelIdentifier](docs/AfmObjectIdentifierLabelIdentifier.md)
 - [AfmValidObjectsQuery](docs/AfmValidObjectsQuery.md)
 - [AfmValidObjectsResponse](docs/AfmValidObjectsResponse.md)
 - [ArithmeticMeasureDefinition](docs/ArithmeticMeasureDefinition.md)
 - [ArithmeticMeasureDefinitionArithmeticMeasure](docs/ArithmeticMeasureDefinitionArithmeticMeasure.md)
 - [AttributeExecutionResultHeader](docs/AttributeExecutionResultHeader.md)
 - [AttributeFilter](docs/AttributeFilter.md)
 - [AttributeFilterElements](docs/AttributeFilterElements.md)
 - [AttributeFormat](docs/AttributeFormat.md)
 - [AttributeHeaderOut](docs/AttributeHeaderOut.md)
 - [AttributeHeaderOutAttributeHeader](docs/AttributeHeaderOutAttributeHeader.md)
 - [AttributeItem](docs/AttributeItem.md)
 - [AttributeResultHeader](docs/AttributeResultHeader.md)
 - [ComparisonMeasureValueFilter](docs/ComparisonMeasureValueFilter.md)
 - [ComparisonMeasureValueFilterComparisonMeasureValueFilter](docs/ComparisonMeasureValueFilterComparisonMeasureValueFilter.md)
 - [DataColumnLocator](docs/DataColumnLocator.md)
 - [DataColumnLocators](docs/DataColumnLocators.md)
 - [DateFilter](docs/DateFilter.md)
 - [Dimension](docs/Dimension.md)
 - [DimensionHeader](docs/DimensionHeader.md)
 - [Element](docs/Element.md)
 - [ElementsRequest](docs/ElementsRequest.md)
 - [ElementsResponse](docs/ElementsResponse.md)
 - [ExecutionLinks](docs/ExecutionLinks.md)
 - [ExecutionResponse](docs/ExecutionResponse.md)
 - [ExecutionResult](docs/ExecutionResult.md)
 - [ExecutionResultGrandTotal](docs/ExecutionResultGrandTotal.md)
 - [ExecutionResultHeader](docs/ExecutionResultHeader.md)
 - [ExecutionResultPaging](docs/ExecutionResultPaging.md)
 - [ExecutionSettings](docs/ExecutionSettings.md)
 - [FilterBy](docs/FilterBy.md)
 - [FilterDefinition](docs/FilterDefinition.md)
 - [FilterDefinitionForSimpleMeasure](docs/FilterDefinitionForSimpleMeasure.md)
 - [HeaderGroup](docs/HeaderGroup.md)
 - [InlineFilterDefinition](docs/InlineFilterDefinition.md)
 - [InlineFilterDefinitionInline](docs/InlineFilterDefinitionInline.md)
 - [InlineMeasureDefinition](docs/InlineMeasureDefinition.md)
 - [InlineMeasureDefinitionInline](docs/InlineMeasureDefinitionInline.md)
 - [MeasureDefinition](docs/MeasureDefinition.md)
 - [MeasureExecutionResultHeader](docs/MeasureExecutionResultHeader.md)
 - [MeasureGroupHeaders](docs/MeasureGroupHeaders.md)
 - [MeasureHeaderOut](docs/MeasureHeaderOut.md)
 - [MeasureItem](docs/MeasureItem.md)
 - [MeasureResultHeader](docs/MeasureResultHeader.md)
 - [MeasureValueFilter](docs/MeasureValueFilter.md)
 - [NegativeAttributeFilter](docs/NegativeAttributeFilter.md)
 - [NegativeAttributeFilterNegativeAttributeFilter](docs/NegativeAttributeFilterNegativeAttributeFilter.md)
 - [Paging](docs/Paging.md)
 - [PopDataset](docs/PopDataset.md)
 - [PopDatasetMeasureDefinition](docs/PopDatasetMeasureDefinition.md)
 - [PopDatasetMeasureDefinitionPreviousPeriodMeasure](docs/PopDatasetMeasureDefinitionPreviousPeriodMeasure.md)
 - [PopDate](docs/PopDate.md)
 - [PopDateMeasureDefinition](docs/PopDateMeasureDefinition.md)
 - [PopDateMeasureDefinitionOverPeriodMeasure](docs/PopDateMeasureDefinitionOverPeriodMeasure.md)
 - [PopMeasureDefinition](docs/PopMeasureDefinition.md)
 - [PositiveAttributeFilter](docs/PositiveAttributeFilter.md)
 - [PositiveAttributeFilterPositiveAttributeFilter](docs/PositiveAttributeFilterPositiveAttributeFilter.md)
 - [RangeMeasureValueFilter](docs/RangeMeasureValueFilter.md)
 - [RangeMeasureValueFilterRangeMeasureValueFilter](docs/RangeMeasureValueFilterRangeMeasureValueFilter.md)
 - [RankingFilter](docs/RankingFilter.md)
 - [RankingFilterRankingFilter](docs/RankingFilterRankingFilter.md)
 - [RelativeDateFilter](docs/RelativeDateFilter.md)
 - [RelativeDateFilterRelativeDateFilter](docs/RelativeDateFilterRelativeDateFilter.md)
 - [RestApiIdentifier](docs/RestApiIdentifier.md)
 - [ResultCacheMetadata](docs/ResultCacheMetadata.md)
 - [ResultDimension](docs/ResultDimension.md)
 - [ResultDimensionHeader](docs/ResultDimensionHeader.md)
 - [ResultSpec](docs/ResultSpec.md)
 - [SimpleMeasureDefinition](docs/SimpleMeasureDefinition.md)
 - [SimpleMeasureDefinitionMeasure](docs/SimpleMeasureDefinitionMeasure.md)
 - [SortKey](docs/SortKey.md)
 - [SortKeyAttribute](docs/SortKeyAttribute.md)
 - [SortKeyAttributeAttribute](docs/SortKeyAttributeAttribute.md)
 - [SortKeyTotal](docs/SortKeyTotal.md)
 - [SortKeyTotalTotal](docs/SortKeyTotalTotal.md)
 - [SortKeyValue](docs/SortKeyValue.md)
 - [SortKeyValueValue](docs/SortKeyValueValue.md)
 - [Total](docs/Total.md)
 - [TotalDimension](docs/TotalDimension.md)
 - [TotalExecutionResultHeader](docs/TotalExecutionResultHeader.md)
 - [TotalResultHeader](docs/TotalResultHeader.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

support@gooddata.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in gooddata_afm_client.apis and gooddata_afm_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from gooddata_afm_client.api.default_api import DefaultApi`
- `from gooddata_afm_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import gooddata_afm_client
from gooddata_afm_client.apis import *
from gooddata_afm_client.models import *
```

