# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['guvicorn_logger']

package_data = \
{'': ['*']}

install_requires = \
['asgi-correlation-id', 'gunicorn', 'uvicorn']

setup_kwargs = {
    'name': 'guvicorn-logger',
    'version': '0.1.14',
    'description': 'Colored, normalizes and joins logs between Uvicorn and Gunicorn.',
    'long_description': '## Guvicorn_logger\n\nThis lib colored, normalizes and joins logs between Uvicorn and Gunicorn.\nThere is a common problem when using Uvicorn for Dev and Gunicorn for Prod, \nnormally the logs generated by Uvicorn wokers are not captured by Gunicorn.\n\nThis lib facilitates this configuration...\n\n#### Easy config\n```python\nfrom guvicorn_logger import Logger\n\nlogger = Logger().configure()\n```\n\n#### Example\n\n```python\nlogger.info("Message - Info")\nlogger.error("Message - Error")\nlogger.warning("Message - Warning")\nlogger.critical("Message - Critical")\n```\n#### Output\n\n- Framework (Uvicorn, Gunicorn, Fastapi)\n![alt text](https://raw.githubusercontent.com/carlos-rian/guvicorn_logger/main/docs/img/framework-web.JPG)\n\n\n\n### FastAPI | asgi-correlation-id\n\n```python\nfrom asgi_correlation_id import CorrelationIdMiddleware\nfrom fastapi import FastAPI\n\nfrom guvicorn_logger import Logger\n\napp = FastAPI()\n\n\napp.add_middleware(CorrelationIdMiddleware)\n\n\nlogger = Logger(correlation_id=True).configure()\n\n\n@app.get("/")\ndef main():\n    logger.info("Message - Info")\n    logger.error("Message - Error")\n    logger.warning("Message - Warning")\n    logger.critical("Message - Critical")\n\n```\n\n#### Output\n\n![alt text](https://raw.githubusercontent.com/carlos-rian/guvicorn_logger/main/docs/img/fastapi.png)',
    'author': 'carlos.rian',
    'author_email': 'crian.rian@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/carlos-rian/guvicorn_logger',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
