# This file is part of Octopus Sensing <https://octopus-sensing.nastaran-saffar.me/>
# Copyright © Nastaran Saffaryazdi 2020
#
# Octopus Sensing is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software Foundation,
#  either version 3 of the License, or (at your option) any later version.
#
# Octopus Sensing is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with Octopus Sensing.
# If not, see <https://www.gnu.org/licenses/>.

import os
from octopus_sensing.stimuli.stimulus import Stimulus

class VideoStimulus(Stimulus):
    '''
    Creates video stimulus

    Attributes
    -----------


    Parameters
    ----------
    id: str
        The id of stimulus

    path: str
        The path of video
    '''

    def __init__(self, id, path):
        super().__init__(id, path)

    def show(self):
        '''
        Displays video stimulus using VLC
        '''
        os.system("vlc --fullscreen --play-and-exit {0}".format(self.path))