<?xml version="1.0"?>
<VOTABLE version="1.1" xsi:schemaLocation="http://www.ivoa.net/xml/VOTable/v1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
  <INFO name="QUERY_STATUS" value="OK"/>
  <RESOURCE type="results">
    <TABLE utype="photdm:PhotometryFilter.transmissionCurve.spectrum">
    <PARAM name="FilterProfileService" value="ivo://svo/fps" ucd="meta.ref.ivorn" utype="PhotometryFilter.fpsIdentifier" datatype="char" arraysize="*"/>
    <PARAM name="filterID" value="MKO/NSFCam.J" ucd="meta.id" utype="photdm:PhotometryFilter.identifier" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthUnit" value="Angstrom" ucd="meta.unit" utype="PhotometryFilter.SpectralAxis.unit" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthUCD" value="em.wl" ucd="meta.ucd" utype="PhotometryFilter.SpectralAxis.UCD" datatype="char" arraysize="*"/>
    <PARAM name="Description" value="Mauna kea Obsevatory. NSFCam J filter" ucd="meta.note" utype="photdm:PhotometryFilter.description" datatype="char" arraysize="*"/>
    <PARAM name="PhotSystem" value="NSFCam" utype="photdm:PhotometricSystem.description" datatype="char" arraysize="*">
       <DESCRIPTION>Photometric system</DESCRIPTION>
    </PARAM>
    <PARAM name="Instrument" value="NSFCam" ucd="instr" datatype="char" arraysize="*">
       <DESCRIPTION>Instrument</DESCRIPTION>
    </PARAM>
    <PARAM name="Facility" value="MKO" ucd="instr.obsty" datatype="char" arraysize="*">
       <DESCRIPTION>Observational facility</DESCRIPTION>
    </PARAM>
    <PARAM name="ProfileReference" value="http://irtfweb.ifa.hawaii.edu/~nsfcam2/Filter_Profiles.html" datatype="char" arraysize="*"/>
    <PARAM name="Description" value="Mauna kea Obsevatory. NSFCam J filter" ucd="meta.note" utype="photdm:PhotometryFilter.description" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthMean" value="12484.138483946" unit="Angstrom" ucd="em.wl" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Location.Value" datatype="float" >
       <DESCRIPTION>Mean wavelength. Defined as integ[x*filter(x) dx]/integ[filter(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthEff" value="12417.39647777" unit="Angstrom" ucd="em.wl.effective" datatype="float" >
       <DESCRIPTION>Effective wavelength. Defined as integ[x*filter(x)*vega(x) dx]/integ[filter(x)*vega(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthMin" value="11481.781489882" unit="Angstrom" ucd="em.wl;stat.min" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Start" datatype="float" >
       <DESCRIPTION>Minimum filter wavelength. Defined as the first lambda value with a transmission at least 1% of maximum transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthMax" value="13494.412027885" unit="Angstrom" ucd="em.wl;stat.max" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Stop" datatype="float" >
       <DESCRIPTION>Maximum filter wavelength. Defined as the last lambda value with a transmission at least 1% of maximum transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WidthEff" value="1516.7778896441" unit="Angstrom" ucd="instr.bandwidth" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Extent" datatype="float" >
       <DESCRIPTION>Effective width. Defined as integ[x*filter(x) dx].\nEquivalent to the horizontal size of a rectangle with height equal to maximum transmission and with the same area that the one covered by the filter transmission curve.</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthCen" value="12471.667749223" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Central wavelength. Defined as the central wavelength between the two points defining FWMH</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPivot" value="12475.067927727" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Peak wavelength. Defined as sqrt{integ[x*filter(x) dx]/integ[filter(x) dx/x]}</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPeak" value="12738" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Peak wavelength. Defined as the lambda value with larger transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPhot" value="12435.54694586" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Photon distribution based effective wavelength. Defined as integ[x^2*filter(x)*vega(x) dx]/integ[x*filter(x)*vega(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="FWHM" value="1616.812023496" unit="Angstrom" ucd="instr.bandwidth" datatype="float" >
       <DESCRIPTION>Full width at half maximum. Defined as the difference between the two wavelengths for which filter transmission is half maximum</DESCRIPTION>
    </PARAM>
    <PARAM name="PhotCalID" value="MKO/NSFCam.J/Vega" ucd="meta.id" utype="photdm:PhotCal.identifier" datatype="char" arraysize="*"/>
    <PARAM name="MagSys" value="Vega" ucd="meta.code" utype="photdm:PhotCal.MagnitudeSystem.type" datatype="char" arraysize="*"/>
    <PARAM name="ZeroPoint" value="1562.2293774432" unit="Jy" ucd="phot.flux.density" utype="photdm:PhotCal.ZeroPoint.Flux.value" datatype="float" />
    <PARAM name="ZeroPointUnit" value="Jy" ucd="meta.unit" utype="photdm:PhotCal.ZeroPoint.Flux.unit" datatype="char" arraysize="*"/>
    <PARAM name="ZeroPointType" value="Pogson" ucd="meta.code" utype="photdm:PhotCal.ZeroPoint.type" datatype="char" arraysize="*"/>
      <FIELD name="Wavelength" utype="spec:Data.SpectralAxis.Value" ucd="em.wl" unit="Angstrom" datatype="float"/>
      <FIELD name="Transmission" utype="spec:Data.FluxAxis.Value" ucd="phys.transmission" unit="" datatype="float"/>
      <DATA>
        <TABLEDATA>
          <TR>
            <TD>11308.000</TD>
            <TD>0.00044548</TD>
          </TR>
          <TR>
            <TD>11310.000</TD>
            <TD>0.00044496</TD>
          </TR>
          <TR>
            <TD>11312.000</TD>
            <TD>0.00033742</TD>
          </TR>
          <TR>
            <TD>11314.000</TD>
            <TD>0.00021497</TD>
          </TR>
          <TR>
            <TD>11316.000</TD>
            <TD>0.00019988</TD>
          </TR>
          <TR>
            <TD>11318.000</TD>
            <TD>9.221e-05</TD>
          </TR>
          <TR>
            <TD>11320.000</TD>
            <TD>0.00019963</TD>
          </TR>
          <TR>
            <TD>11322.000</TD>
            <TD>0.00066001</TD>
          </TR>
          <TR>
            <TD>11324.000</TD>
            <TD>0.00030714</TD>
          </TR>
          <TR>
            <TD>11326.000</TD>
            <TD>0.00043002</TD>
          </TR>
          <TR>
            <TD>11328.000</TD>
            <TD>0.00112149</TD>
          </TR>
          <TR>
            <TD>11330.000</TD>
            <TD>0.00100042</TD>
          </TR>
          <TR>
            <TD>11332.000</TD>
            <TD>0.00064727</TD>
          </TR>
          <TR>
            <TD>11334.000</TD>
            <TD>0.00018489</TD>
          </TR>
          <TR>
            <TD>11336.000</TD>
            <TD>9.244e-05</TD>
          </TR>
          <TR>
            <TD>11338.000</TD>
            <TD>9.242e-05</TD>
          </TR>
          <TR>
            <TD>11340.000</TD>
            <TD>9.25e-05</TD>
          </TR>
          <TR>
            <TD>11342.000</TD>
            <TD>9.252e-05</TD>
          </TR>
          <TR>
            <TD>11344.000</TD>
            <TD>0.00064709</TD>
          </TR>
          <TR>
            <TD>11346.000</TD>
            <TD>0.00098721</TD>
          </TR>
          <TR>
            <TD>11348.000</TD>
            <TD>0.00089455</TD>
          </TR>
          <TR>
            <TD>11350.000</TD>
            <TD>0.0008009</TD>
          </TR>
          <TR>
            <TD>11352.000</TD>
            <TD>0.00055425</TD>
          </TR>
          <TR>
            <TD>11354.000</TD>
            <TD>0.00121564</TD>
          </TR>
          <TR>
            <TD>11356.000</TD>
            <TD>0.00099979</TD>
          </TR>
          <TR>
            <TD>11358.000</TD>
            <TD>0.00039986</TD>
          </TR>
          <TR>
            <TD>11360.000</TD>
            <TD>0.00124435</TD>
          </TR>
          <TR>
            <TD>11362.000</TD>
            <TD>0.0016889</TD>
          </TR>
          <TR>
            <TD>11364.000</TD>
            <TD>0.00155178</TD>
          </TR>
          <TR>
            <TD>11366.000</TD>
            <TD>0.00145995</TD>
          </TR>
          <TR>
            <TD>11368.000</TD>
            <TD>0.00142802</TD>
          </TR>
          <TR>
            <TD>11370.000</TD>
            <TD>0.00153457</TD>
          </TR>
          <TR>
            <TD>11372.000</TD>
            <TD>0.00095195</TD>
          </TR>
          <TR>
            <TD>11374.000</TD>
            <TD>0.00083028</TD>
          </TR>
          <TR>
            <TD>11376.000</TD>
            <TD>0.00155293</TD>
          </TR>
          <TR>
            <TD>11378.000</TD>
            <TD>0.00178295</TD>
          </TR>
          <TR>
            <TD>11380.000</TD>
            <TD>0.00098365</TD>
          </TR>
          <TR>
            <TD>11382.000</TD>
            <TD>0.0005379</TD>
          </TR>
          <TR>
            <TD>11384.000</TD>
            <TD>0.00120036</TD>
          </TR>
          <TR>
            <TD>11386.000</TD>
            <TD>0.00143089</TD>
          </TR>
          <TR>
            <TD>11388.000</TD>
            <TD>0.00189022</TD>
          </TR>
          <TR>
            <TD>11390.000</TD>
            <TD>0.00189226</TD>
          </TR>
          <TR>
            <TD>11392.000</TD>
            <TD>0.00175763</TD>
          </TR>
          <TR>
            <TD>11394.000</TD>
            <TD>0.001633</TD>
          </TR>
          <TR>
            <TD>11396.000</TD>
            <TD>0.00130956</TD>
          </TR>
          <TR>
            <TD>11398.000</TD>
            <TD>0.00120175</TD>
          </TR>
          <TR>
            <TD>11400.000</TD>
            <TD>0.00118488</TD>
          </TR>
          <TR>
            <TD>11402.000</TD>
            <TD>0.0017552</TD>
          </TR>
          <TR>
            <TD>11404.000</TD>
            <TD>0.00207758</TD>
          </TR>
          <TR>
            <TD>11406.000</TD>
            <TD>0.00185999</TD>
          </TR>
          <TR>
            <TD>11408.000</TD>
            <TD>0.0011845</TD>
          </TR>
          <TR>
            <TD>11410.000</TD>
            <TD>0.00207602</TD>
          </TR>
          <TR>
            <TD>11412.000</TD>
            <TD>0.00285808</TD>
          </TR>
          <TR>
            <TD>11414.000</TD>
            <TD>0.00264291</TD>
          </TR>
          <TR>
            <TD>11416.000</TD>
            <TD>0.00285604</TD>
          </TR>
          <TR>
            <TD>11418.000</TD>
            <TD>0.00318968</TD>
          </TR>
          <TR>
            <TD>11420.000</TD>
            <TD>0.00329636</TD>
          </TR>
          <TR>
            <TD>11422.000</TD>
            <TD>0.00271569</TD>
          </TR>
          <TR>
            <TD>11424.000</TD>
            <TD>0.00250271</TD>
          </TR>
          <TR>
            <TD>11426.000</TD>
            <TD>0.00272202</TD>
          </TR>
          <TR>
            <TD>11428.000</TD>
            <TD>0.00247374</TD>
          </TR>
          <TR>
            <TD>11430.000</TD>
            <TD>0.0029479</TD>
          </TR>
          <TR>
            <TD>11432.000</TD>
            <TD>0.00327311</TD>
          </TR>
          <TR>
            <TD>11434.000</TD>
            <TD>0.00316357</TD>
          </TR>
          <TR>
            <TD>11436.000</TD>
            <TD>0.00362026</TD>
          </TR>
          <TR>
            <TD>11438.000</TD>
            <TD>0.00406488</TD>
          </TR>
          <TR>
            <TD>11440.000</TD>
            <TD>0.00395081</TD>
          </TR>
          <TR>
            <TD>11442.000</TD>
            <TD>0.00383214</TD>
          </TR>
          <TR>
            <TD>11444.000</TD>
            <TD>0.00476042</TD>
          </TR>
          <TR>
            <TD>11446.000</TD>
            <TD>0.00441045</TD>
          </TR>
          <TR>
            <TD>11448.000</TD>
            <TD>0.00414832</TD>
          </TR>
          <TR>
            <TD>11450.000</TD>
            <TD>0.0048386</TD>
          </TR>
          <TR>
            <TD>11452.000</TD>
            <TD>0.00496451</TD>
          </TR>
          <TR>
            <TD>11454.000</TD>
            <TD>0.0050558</TD>
          </TR>
          <TR>
            <TD>11456.000</TD>
            <TD>0.0059621</TD>
          </TR>
          <TR>
            <TD>11458.000</TD>
            <TD>0.00616731</TD>
          </TR>
          <TR>
            <TD>11460.000</TD>
            <TD>0.00559765</TD>
          </TR>
          <TR>
            <TD>11462.000</TD>
            <TD>0.00616102</TD>
          </TR>
          <TR>
            <TD>11464.000</TD>
            <TD>0.00625539</TD>
          </TR>
          <TR>
            <TD>11466.000</TD>
            <TD>0.00634462</TD>
          </TR>
          <TR>
            <TD>11468.000</TD>
            <TD>0.0064612</TD>
          </TR>
          <TR>
            <TD>11470.000</TD>
            <TD>0.00714657</TD>
          </TR>
          <TR>
            <TD>11472.000</TD>
            <TD>0.00814734</TD>
          </TR>
          <TR>
            <TD>11474.000</TD>
            <TD>0.00813243</TD>
          </TR>
          <TR>
            <TD>11476.000</TD>
            <TD>0.00858651</TD>
          </TR>
          <TR>
            <TD>11478.000</TD>
            <TD>0.00879297</TD>
          </TR>
          <TR>
            <TD>11480.000</TD>
            <TD>0.00855456</TD>
          </TR>
          <TR>
            <TD>11482.000</TD>
            <TD>0.00944953</TD>
          </TR>
          <TR>
            <TD>11484.000</TD>
            <TD>0.0100089</TD>
          </TR>
          <TR>
            <TD>11486.000</TD>
            <TD>0.0100366</TD>
          </TR>
          <TR>
            <TD>11488.000</TD>
            <TD>0.0103737</TD>
          </TR>
          <TR>
            <TD>11490.000</TD>
            <TD>0.0106697</TD>
          </TR>
          <TR>
            <TD>11492.000</TD>
            <TD>0.0112411</TD>
          </TR>
          <TR>
            <TD>11494.000</TD>
            <TD>0.011212</TD>
          </TR>
          <TR>
            <TD>11496.000</TD>
            <TD>0.0117504</TD>
          </TR>
          <TR>
            <TD>11498.000</TD>
            <TD>0.0131844</TD>
          </TR>
          <TR>
            <TD>11500.000</TD>
            <TD>0.01342</TD>
          </TR>
          <TR>
            <TD>11502.000</TD>
            <TD>0.0134104</TD>
          </TR>
          <TR>
            <TD>11504.000</TD>
            <TD>0.0144195</TD>
          </TR>
          <TR>
            <TD>11506.000</TD>
            <TD>0.0153222</TD>
          </TR>
          <TR>
            <TD>11508.000</TD>
            <TD>0.0156643</TD>
          </TR>
          <TR>
            <TD>11510.000</TD>
            <TD>0.0162456</TD>
          </TR>
          <TR>
            <TD>11512.000</TD>
            <TD>0.0170341</TD>
          </TR>
          <TR>
            <TD>11514.000</TD>
            <TD>0.0175617</TD>
          </TR>
          <TR>
            <TD>11516.000</TD>
            <TD>0.0180553</TD>
          </TR>
          <TR>
            <TD>11518.000</TD>
            <TD>0.0187389</TD>
          </TR>
          <TR>
            <TD>11520.000</TD>
            <TD>0.0196864</TD>
          </TR>
          <TR>
            <TD>11522.000</TD>
            <TD>0.0206654</TD>
          </TR>
          <TR>
            <TD>11524.000</TD>
            <TD>0.0212152</TD>
          </TR>
          <TR>
            <TD>11526.000</TD>
            <TD>0.0217003</TD>
          </TR>
          <TR>
            <TD>11528.000</TD>
            <TD>0.02357</TD>
          </TR>
          <TR>
            <TD>11530.000</TD>
            <TD>0.0247003</TD>
          </TR>
          <TR>
            <TD>11532.000</TD>
            <TD>0.0250186</TD>
          </TR>
          <TR>
            <TD>11534.000</TD>
            <TD>0.0257018</TD>
          </TR>
          <TR>
            <TD>11536.000</TD>
            <TD>0.0266059</TD>
          </TR>
          <TR>
            <TD>11538.000</TD>
            <TD>0.0282252</TD>
          </TR>
          <TR>
            <TD>11540.000</TD>
            <TD>0.0295612</TD>
          </TR>
          <TR>
            <TD>11542.000</TD>
            <TD>0.0308294</TD>
          </TR>
          <TR>
            <TD>11544.000</TD>
            <TD>0.0323054</TD>
          </TR>
          <TR>
            <TD>11546.000</TD>
            <TD>0.0336956</TD>
          </TR>
          <TR>
            <TD>11548.000</TD>
            <TD>0.0350907</TD>
          </TR>
          <TR>
            <TD>11550.000</TD>
            <TD>0.0360007</TD>
          </TR>
          <TR>
            <TD>11552.000</TD>
            <TD>0.0373061</TD>
          </TR>
          <TR>
            <TD>11554.000</TD>
            <TD>0.0394917</TD>
          </TR>
          <TR>
            <TD>11556.000</TD>
            <TD>0.0409398</TD>
          </TR>
          <TR>
            <TD>11558.000</TD>
            <TD>0.0421708</TD>
          </TR>
          <TR>
            <TD>11560.000</TD>
            <TD>0.044117</TD>
          </TR>
          <TR>
            <TD>11562.000</TD>
            <TD>0.0460787</TD>
          </TR>
          <TR>
            <TD>11564.000</TD>
            <TD>0.0478204</TD>
          </TR>
          <TR>
            <TD>11566.000</TD>
            <TD>0.0497364</TD>
          </TR>
          <TR>
            <TD>11568.000</TD>
            <TD>0.0523972</TD>
          </TR>
          <TR>
            <TD>11570.000</TD>
            <TD>0.0546208</TD>
          </TR>
          <TR>
            <TD>11572.000</TD>
            <TD>0.0566471</TD>
          </TR>
          <TR>
            <TD>11574.000</TD>
            <TD>0.0594113</TD>
          </TR>
          <TR>
            <TD>11576.000</TD>
            <TD>0.0620834</TD>
          </TR>
          <TR>
            <TD>11578.000</TD>
            <TD>0.0658918</TD>
          </TR>
          <TR>
            <TD>11580.000</TD>
            <TD>0.0687127</TD>
          </TR>
          <TR>
            <TD>11582.000</TD>
            <TD>0.0711182</TD>
          </TR>
          <TR>
            <TD>11584.000</TD>
            <TD>0.0751343</TD>
          </TR>
          <TR>
            <TD>11586.000</TD>
            <TD>0.0776362</TD>
          </TR>
          <TR>
            <TD>11588.000</TD>
            <TD>0.0808897</TD>
          </TR>
          <TR>
            <TD>11590.000</TD>
            <TD>0.085807</TD>
          </TR>
          <TR>
            <TD>11592.000</TD>
            <TD>0.0889883</TD>
          </TR>
          <TR>
            <TD>11594.000</TD>
            <TD>0.0927834</TD>
          </TR>
          <TR>
            <TD>11596.000</TD>
            <TD>0.0983743</TD>
          </TR>
          <TR>
            <TD>11598.000</TD>
            <TD>0.102811</TD>
          </TR>
          <TR>
            <TD>11600.000</TD>
            <TD>0.107165</TD>
          </TR>
          <TR>
            <TD>11602.000</TD>
            <TD>0.113473</TD>
          </TR>
          <TR>
            <TD>11604.000</TD>
            <TD>0.118683</TD>
          </TR>
          <TR>
            <TD>11606.000</TD>
            <TD>0.123147</TD>
          </TR>
          <TR>
            <TD>11608.000</TD>
            <TD>0.130165</TD>
          </TR>
          <TR>
            <TD>11610.000</TD>
            <TD>0.136527</TD>
          </TR>
          <TR>
            <TD>11612.000</TD>
            <TD>0.14193</TD>
          </TR>
          <TR>
            <TD>11614.000</TD>
            <TD>0.150202</TD>
          </TR>
          <TR>
            <TD>11616.000</TD>
            <TD>0.157794</TD>
          </TR>
          <TR>
            <TD>11618.000</TD>
            <TD>0.165266</TD>
          </TR>
          <TR>
            <TD>11620.000</TD>
            <TD>0.174978</TD>
          </TR>
          <TR>
            <TD>11622.000</TD>
            <TD>0.182515</TD>
          </TR>
          <TR>
            <TD>11624.000</TD>
            <TD>0.19054</TD>
          </TR>
          <TR>
            <TD>11626.000</TD>
            <TD>0.200925</TD>
          </TR>
          <TR>
            <TD>11628.000</TD>
            <TD>0.210394</TD>
          </TR>
          <TR>
            <TD>11630.000</TD>
            <TD>0.21963</TD>
          </TR>
          <TR>
            <TD>11632.000</TD>
            <TD>0.230656</TD>
          </TR>
          <TR>
            <TD>11634.000</TD>
            <TD>0.241692</TD>
          </TR>
          <TR>
            <TD>11636.000</TD>
            <TD>0.254804</TD>
          </TR>
          <TR>
            <TD>11638.000</TD>
            <TD>0.268726</TD>
          </TR>
          <TR>
            <TD>11640.000</TD>
            <TD>0.280951</TD>
          </TR>
          <TR>
            <TD>11642.000</TD>
            <TD>0.293732</TD>
          </TR>
          <TR>
            <TD>11644.000</TD>
            <TD>0.306815</TD>
          </TR>
          <TR>
            <TD>11646.000</TD>
            <TD>0.323266</TD>
          </TR>
          <TR>
            <TD>11648.000</TD>
            <TD>0.338124</TD>
          </TR>
          <TR>
            <TD>11650.000</TD>
            <TD>0.354057</TD>
          </TR>
          <TR>
            <TD>11652.000</TD>
            <TD>0.372375</TD>
          </TR>
          <TR>
            <TD>11654.000</TD>
            <TD>0.386052</TD>
          </TR>
          <TR>
            <TD>11656.000</TD>
            <TD>0.4042</TD>
          </TR>
          <TR>
            <TD>11658.000</TD>
            <TD>0.42126</TD>
          </TR>
          <TR>
            <TD>11660.000</TD>
            <TD>0.437186</TD>
          </TR>
          <TR>
            <TD>11662.000</TD>
            <TD>0.45798</TD>
          </TR>
          <TR>
            <TD>11664.000</TD>
            <TD>0.473209</TD>
          </TR>
          <TR>
            <TD>11666.000</TD>
            <TD>0.490555</TD>
          </TR>
          <TR>
            <TD>11668.000</TD>
            <TD>0.510926</TD>
          </TR>
          <TR>
            <TD>11670.000</TD>
            <TD>0.530948</TD>
          </TR>
          <TR>
            <TD>11672.000</TD>
            <TD>0.551418</TD>
          </TR>
          <TR>
            <TD>11674.000</TD>
            <TD>0.567954</TD>
          </TR>
          <TR>
            <TD>11676.000</TD>
            <TD>0.587747</TD>
          </TR>
          <TR>
            <TD>11678.000</TD>
            <TD>0.605254</TD>
          </TR>
          <TR>
            <TD>11680.000</TD>
            <TD>0.620486</TD>
          </TR>
          <TR>
            <TD>11682.000</TD>
            <TD>0.639837</TD>
          </TR>
          <TR>
            <TD>11684.000</TD>
            <TD>0.655371</TD>
          </TR>
          <TR>
            <TD>11686.000</TD>
            <TD>0.67237</TD>
          </TR>
          <TR>
            <TD>11688.000</TD>
            <TD>0.692703</TD>
          </TR>
          <TR>
            <TD>11690.000</TD>
            <TD>0.706343</TD>
          </TR>
          <TR>
            <TD>11692.000</TD>
            <TD>0.718613</TD>
          </TR>
          <TR>
            <TD>11694.000</TD>
            <TD>0.73191</TD>
          </TR>
          <TR>
            <TD>11696.000</TD>
            <TD>0.743513</TD>
          </TR>
          <TR>
            <TD>11698.000</TD>
            <TD>0.755702</TD>
          </TR>
          <TR>
            <TD>11700.000</TD>
            <TD>0.766848</TD>
          </TR>
          <TR>
            <TD>11702.000</TD>
            <TD>0.776602</TD>
          </TR>
          <TR>
            <TD>11704.000</TD>
            <TD>0.787031</TD>
          </TR>
          <TR>
            <TD>11706.000</TD>
            <TD>0.796401</TD>
          </TR>
          <TR>
            <TD>11708.000</TD>
            <TD>0.80457</TD>
          </TR>
          <TR>
            <TD>11710.000</TD>
            <TD>0.809894</TD>
          </TR>
          <TR>
            <TD>11712.000</TD>
            <TD>0.812978</TD>
          </TR>
          <TR>
            <TD>11714.000</TD>
            <TD>0.816357</TD>
          </TR>
          <TR>
            <TD>11716.000</TD>
            <TD>0.82087</TD>
          </TR>
          <TR>
            <TD>11718.000</TD>
            <TD>0.825682</TD>
          </TR>
          <TR>
            <TD>11720.000</TD>
            <TD>0.828245</TD>
          </TR>
          <TR>
            <TD>11722.000</TD>
            <TD>0.829974</TD>
          </TR>
          <TR>
            <TD>11724.000</TD>
            <TD>0.831301</TD>
          </TR>
          <TR>
            <TD>11726.000</TD>
            <TD>0.831955</TD>
          </TR>
          <TR>
            <TD>11728.000</TD>
            <TD>0.83136</TD>
          </TR>
          <TR>
            <TD>11730.000</TD>
            <TD>0.832028</TD>
          </TR>
          <TR>
            <TD>11732.000</TD>
            <TD>0.831691</TD>
          </TR>
          <TR>
            <TD>11734.000</TD>
            <TD>0.830248</TD>
          </TR>
          <TR>
            <TD>11736.000</TD>
            <TD>0.829586</TD>
          </TR>
          <TR>
            <TD>11738.000</TD>
            <TD>0.828771</TD>
          </TR>
          <TR>
            <TD>11740.000</TD>
            <TD>0.827101</TD>
          </TR>
          <TR>
            <TD>11742.000</TD>
            <TD>0.825071</TD>
          </TR>
          <TR>
            <TD>11744.000</TD>
            <TD>0.821628</TD>
          </TR>
          <TR>
            <TD>11746.000</TD>
            <TD>0.818939</TD>
          </TR>
          <TR>
            <TD>11748.000</TD>
            <TD>0.819408</TD>
          </TR>
          <TR>
            <TD>11750.000</TD>
            <TD>0.817037</TD>
          </TR>
          <TR>
            <TD>11752.000</TD>
            <TD>0.814276</TD>
          </TR>
          <TR>
            <TD>11754.000</TD>
            <TD>0.813231</TD>
          </TR>
          <TR>
            <TD>11756.000</TD>
            <TD>0.810057</TD>
          </TR>
          <TR>
            <TD>11758.000</TD>
            <TD>0.806574</TD>
          </TR>
          <TR>
            <TD>11760.000</TD>
            <TD>0.804713</TD>
          </TR>
          <TR>
            <TD>11762.000</TD>
            <TD>0.802651</TD>
          </TR>
          <TR>
            <TD>11764.000</TD>
            <TD>0.801727</TD>
          </TR>
          <TR>
            <TD>11766.000</TD>
            <TD>0.799866</TD>
          </TR>
          <TR>
            <TD>11768.000</TD>
            <TD>0.796568</TD>
          </TR>
          <TR>
            <TD>11770.000</TD>
            <TD>0.794974</TD>
          </TR>
          <TR>
            <TD>11772.000</TD>
            <TD>0.794249</TD>
          </TR>
          <TR>
            <TD>11774.000</TD>
            <TD>0.79256</TD>
          </TR>
          <TR>
            <TD>11776.000</TD>
            <TD>0.789977</TD>
          </TR>
          <TR>
            <TD>11778.000</TD>
            <TD>0.790171</TD>
          </TR>
          <TR>
            <TD>11780.000</TD>
            <TD>0.789868</TD>
          </TR>
          <TR>
            <TD>11782.000</TD>
            <TD>0.78842</TD>
          </TR>
          <TR>
            <TD>11784.000</TD>
            <TD>0.788196</TD>
          </TR>
          <TR>
            <TD>11786.000</TD>
            <TD>0.787391</TD>
          </TR>
          <TR>
            <TD>11788.000</TD>
            <TD>0.786348</TD>
          </TR>
          <TR>
            <TD>11790.000</TD>
            <TD>0.786008</TD>
          </TR>
          <TR>
            <TD>11792.000</TD>
            <TD>0.785177</TD>
          </TR>
          <TR>
            <TD>11794.000</TD>
            <TD>0.784135</TD>
          </TR>
          <TR>
            <TD>11796.000</TD>
            <TD>0.785985</TD>
          </TR>
          <TR>
            <TD>11798.000</TD>
            <TD>0.787348</TD>
          </TR>
          <TR>
            <TD>11800.000</TD>
            <TD>0.787526</TD>
          </TR>
          <TR>
            <TD>11802.000</TD>
            <TD>0.788289</TD>
          </TR>
          <TR>
            <TD>11804.000</TD>
            <TD>0.787971</TD>
          </TR>
          <TR>
            <TD>11806.000</TD>
            <TD>0.787141</TD>
          </TR>
          <TR>
            <TD>11808.000</TD>
            <TD>0.788165</TD>
          </TR>
          <TR>
            <TD>11810.000</TD>
            <TD>0.789307</TD>
          </TR>
          <TR>
            <TD>11812.000</TD>
            <TD>0.789083</TD>
          </TR>
          <TR>
            <TD>11814.000</TD>
            <TD>0.790595</TD>
          </TR>
          <TR>
            <TD>11816.000</TD>
            <TD>0.791765</TD>
          </TR>
          <TR>
            <TD>11818.000</TD>
            <TD>0.791515</TD>
          </TR>
          <TR>
            <TD>11820.000</TD>
            <TD>0.792675</TD>
          </TR>
          <TR>
            <TD>11822.000</TD>
            <TD>0.793223</TD>
          </TR>
          <TR>
            <TD>11824.000</TD>
            <TD>0.793451</TD>
          </TR>
          <TR>
            <TD>11826.000</TD>
            <TD>0.79607</TD>
          </TR>
          <TR>
            <TD>11828.000</TD>
            <TD>0.797933</TD>
          </TR>
          <TR>
            <TD>11830.000</TD>
            <TD>0.799014</TD>
          </TR>
          <TR>
            <TD>11832.000</TD>
            <TD>0.801538</TD>
          </TR>
          <TR>
            <TD>11834.000</TD>
            <TD>0.802409</TD>
          </TR>
          <TR>
            <TD>11836.000</TD>
            <TD>0.801924</TD>
          </TR>
          <TR>
            <TD>11838.000</TD>
            <TD>0.801405</TD>
          </TR>
          <TR>
            <TD>11840.000</TD>
            <TD>0.801806</TD>
          </TR>
          <TR>
            <TD>11842.000</TD>
            <TD>0.801596</TD>
          </TR>
          <TR>
            <TD>11844.000</TD>
            <TD>0.803105</TD>
          </TR>
          <TR>
            <TD>11846.000</TD>
            <TD>0.806271</TD>
          </TR>
          <TR>
            <TD>11848.000</TD>
            <TD>0.807932</TD>
          </TR>
          <TR>
            <TD>11850.000</TD>
            <TD>0.808015</TD>
          </TR>
          <TR>
            <TD>11852.000</TD>
            <TD>0.808172</TD>
          </TR>
          <TR>
            <TD>11854.000</TD>
            <TD>0.80938</TD>
          </TR>
          <TR>
            <TD>11856.000</TD>
            <TD>0.809854</TD>
          </TR>
          <TR>
            <TD>11858.000</TD>
            <TD>0.811786</TD>
          </TR>
          <TR>
            <TD>11860.000</TD>
            <TD>0.812629</TD>
          </TR>
          <TR>
            <TD>11862.000</TD>
            <TD>0.813423</TD>
          </TR>
          <TR>
            <TD>11864.000</TD>
            <TD>0.816356</TD>
          </TR>
          <TR>
            <TD>11866.000</TD>
            <TD>0.816118</TD>
          </TR>
          <TR>
            <TD>11868.000</TD>
            <TD>0.813539</TD>
          </TR>
          <TR>
            <TD>11870.000</TD>
            <TD>0.81528</TD>
          </TR>
          <TR>
            <TD>11872.000</TD>
            <TD>0.817636</TD>
          </TR>
          <TR>
            <TD>11874.000</TD>
            <TD>0.818511</TD>
          </TR>
          <TR>
            <TD>11876.000</TD>
            <TD>0.820743</TD>
          </TR>
          <TR>
            <TD>11878.000</TD>
            <TD>0.820521</TD>
          </TR>
          <TR>
            <TD>11880.000</TD>
            <TD>0.819332</TD>
          </TR>
          <TR>
            <TD>11882.000</TD>
            <TD>0.821205</TD>
          </TR>
          <TR>
            <TD>11884.000</TD>
            <TD>0.820146</TD>
          </TR>
          <TR>
            <TD>11886.000</TD>
            <TD>0.817429</TD>
          </TR>
          <TR>
            <TD>11888.000</TD>
            <TD>0.819171</TD>
          </TR>
          <TR>
            <TD>11890.000</TD>
            <TD>0.820204</TD>
          </TR>
          <TR>
            <TD>11892.000</TD>
            <TD>0.819929</TD>
          </TR>
          <TR>
            <TD>11894.000</TD>
            <TD>0.821845</TD>
          </TR>
          <TR>
            <TD>11896.000</TD>
            <TD>0.8224</TD>
          </TR>
          <TR>
            <TD>11898.000</TD>
            <TD>0.820584</TD>
          </TR>
          <TR>
            <TD>11900.000</TD>
            <TD>0.820751</TD>
          </TR>
          <TR>
            <TD>11902.000</TD>
            <TD>0.820615</TD>
          </TR>
          <TR>
            <TD>11904.000</TD>
            <TD>0.819069</TD>
          </TR>
          <TR>
            <TD>11906.000</TD>
            <TD>0.819464</TD>
          </TR>
          <TR>
            <TD>11908.000</TD>
            <TD>0.820742</TD>
          </TR>
          <TR>
            <TD>11910.000</TD>
            <TD>0.820968</TD>
          </TR>
          <TR>
            <TD>11912.000</TD>
            <TD>0.820667</TD>
          </TR>
          <TR>
            <TD>11914.000</TD>
            <TD>0.820029</TD>
          </TR>
          <TR>
            <TD>11916.000</TD>
            <TD>0.819092</TD>
          </TR>
          <TR>
            <TD>11918.000</TD>
            <TD>0.819013</TD>
          </TR>
          <TR>
            <TD>11920.000</TD>
            <TD>0.818549</TD>
          </TR>
          <TR>
            <TD>11922.000</TD>
            <TD>0.817939</TD>
          </TR>
          <TR>
            <TD>11924.000</TD>
            <TD>0.820375</TD>
          </TR>
          <TR>
            <TD>11926.000</TD>
            <TD>0.820751</TD>
          </TR>
          <TR>
            <TD>11928.000</TD>
            <TD>0.818032</TD>
          </TR>
          <TR>
            <TD>11930.000</TD>
            <TD>0.817586</TD>
          </TR>
          <TR>
            <TD>11932.000</TD>
            <TD>0.818466</TD>
          </TR>
          <TR>
            <TD>11934.000</TD>
            <TD>0.817395</TD>
          </TR>
          <TR>
            <TD>11936.000</TD>
            <TD>0.818101</TD>
          </TR>
          <TR>
            <TD>11938.000</TD>
            <TD>0.818933</TD>
          </TR>
          <TR>
            <TD>11940.000</TD>
            <TD>0.817862</TD>
          </TR>
          <TR>
            <TD>11942.000</TD>
            <TD>0.81829</TD>
          </TR>
          <TR>
            <TD>11944.000</TD>
            <TD>0.818723</TD>
          </TR>
          <TR>
            <TD>11946.000</TD>
            <TD>0.817337</TD>
          </TR>
          <TR>
            <TD>11948.000</TD>
            <TD>0.81808</TD>
          </TR>
          <TR>
            <TD>11950.000</TD>
            <TD>0.819381</TD>
          </TR>
          <TR>
            <TD>11952.000</TD>
            <TD>0.818327</TD>
          </TR>
          <TR>
            <TD>11954.000</TD>
            <TD>0.818231</TD>
          </TR>
          <TR>
            <TD>11956.000</TD>
            <TD>0.819652</TD>
          </TR>
          <TR>
            <TD>11958.000</TD>
            <TD>0.821515</TD>
          </TR>
          <TR>
            <TD>11960.000</TD>
            <TD>0.821748</TD>
          </TR>
          <TR>
            <TD>11962.000</TD>
            <TD>0.82243</TD>
          </TR>
          <TR>
            <TD>11964.000</TD>
            <TD>0.820881</TD>
          </TR>
          <TR>
            <TD>11966.000</TD>
            <TD>0.820256</TD>
          </TR>
          <TR>
            <TD>11968.000</TD>
            <TD>0.822119</TD>
          </TR>
          <TR>
            <TD>11970.000</TD>
            <TD>0.822875</TD>
          </TR>
          <TR>
            <TD>11972.000</TD>
            <TD>0.823472</TD>
          </TR>
          <TR>
            <TD>11974.000</TD>
            <TD>0.825257</TD>
          </TR>
          <TR>
            <TD>11976.000</TD>
            <TD>0.825514</TD>
          </TR>
          <TR>
            <TD>11978.000</TD>
            <TD>0.824039</TD>
          </TR>
          <TR>
            <TD>11980.000</TD>
            <TD>0.826067</TD>
          </TR>
          <TR>
            <TD>11982.000</TD>
            <TD>0.827111</TD>
          </TR>
          <TR>
            <TD>11984.000</TD>
            <TD>0.826843</TD>
          </TR>
          <TR>
            <TD>11986.000</TD>
            <TD>0.8287</TD>
          </TR>
          <TR>
            <TD>11988.000</TD>
            <TD>0.830149</TD>
          </TR>
          <TR>
            <TD>11990.000</TD>
            <TD>0.830873</TD>
          </TR>
          <TR>
            <TD>11992.000</TD>
            <TD>0.833409</TD>
          </TR>
          <TR>
            <TD>11994.000</TD>
            <TD>0.833997</TD>
          </TR>
          <TR>
            <TD>11996.000</TD>
            <TD>0.833111</TD>
          </TR>
          <TR>
            <TD>11998.000</TD>
            <TD>0.835315</TD>
          </TR>
          <TR>
            <TD>12000.000</TD>
            <TD>0.836008</TD>
          </TR>
          <TR>
            <TD>12002.000</TD>
            <TD>0.836882</TD>
          </TR>
          <TR>
            <TD>12004.000</TD>
            <TD>0.840233</TD>
          </TR>
          <TR>
            <TD>12006.000</TD>
            <TD>0.84082</TD>
          </TR>
          <TR>
            <TD>12008.000</TD>
            <TD>0.840472</TD>
          </TR>
          <TR>
            <TD>12010.000</TD>
            <TD>0.84303</TD>
          </TR>
          <TR>
            <TD>12012.000</TD>
            <TD>0.84419</TD>
          </TR>
          <TR>
            <TD>12014.000</TD>
            <TD>0.843891</TD>
          </TR>
          <TR>
            <TD>12016.000</TD>
            <TD>0.846345</TD>
          </TR>
          <TR>
            <TD>12018.000</TD>
            <TD>0.848825</TD>
          </TR>
          <TR>
            <TD>12020.000</TD>
            <TD>0.849893</TD>
          </TR>
          <TR>
            <TD>12022.000</TD>
            <TD>0.852287</TD>
          </TR>
          <TR>
            <TD>12024.000</TD>
            <TD>0.852636</TD>
          </TR>
          <TR>
            <TD>12026.000</TD>
            <TD>0.852026</TD>
          </TR>
          <TR>
            <TD>12028.000</TD>
            <TD>0.856132</TD>
          </TR>
          <TR>
            <TD>12030.000</TD>
            <TD>0.857392</TD>
          </TR>
          <TR>
            <TD>12032.000</TD>
            <TD>0.856555</TD>
          </TR>
          <TR>
            <TD>12034.000</TD>
            <TD>0.860778</TD>
          </TR>
          <TR>
            <TD>12036.000</TD>
            <TD>0.862338</TD>
          </TR>
          <TR>
            <TD>12038.000</TD>
            <TD>0.859949</TD>
          </TR>
          <TR>
            <TD>12040.000</TD>
            <TD>0.861308</TD>
          </TR>
          <TR>
            <TD>12042.000</TD>
            <TD>0.864118</TD>
          </TR>
          <TR>
            <TD>12044.000</TD>
            <TD>0.864163</TD>
          </TR>
          <TR>
            <TD>12046.000</TD>
            <TD>0.865613</TD>
          </TR>
          <TR>
            <TD>12048.000</TD>
            <TD>0.867831</TD>
          </TR>
          <TR>
            <TD>12050.000</TD>
            <TD>0.868038</TD>
          </TR>
          <TR>
            <TD>12052.000</TD>
            <TD>0.87019</TD>
          </TR>
          <TR>
            <TD>12054.000</TD>
            <TD>0.871647</TD>
          </TR>
          <TR>
            <TD>12056.000</TD>
            <TD>0.869529</TD>
          </TR>
          <TR>
            <TD>12058.000</TD>
            <TD>0.872056</TD>
          </TR>
          <TR>
            <TD>12060.000</TD>
            <TD>0.875283</TD>
          </TR>
          <TR>
            <TD>12062.000</TD>
            <TD>0.873113</TD>
          </TR>
          <TR>
            <TD>12064.000</TD>
            <TD>0.873787</TD>
          </TR>
          <TR>
            <TD>12066.000</TD>
            <TD>0.87673</TD>
          </TR>
          <TR>
            <TD>12068.000</TD>
            <TD>0.877119</TD>
          </TR>
          <TR>
            <TD>12070.000</TD>
            <TD>0.875672</TD>
          </TR>
          <TR>
            <TD>12072.000</TD>
            <TD>0.875736</TD>
          </TR>
          <TR>
            <TD>12074.000</TD>
            <TD>0.876703</TD>
          </TR>
          <TR>
            <TD>12076.000</TD>
            <TD>0.877726</TD>
          </TR>
          <TR>
            <TD>12078.000</TD>
            <TD>0.877975</TD>
          </TR>
          <TR>
            <TD>12080.000</TD>
            <TD>0.877328</TD>
          </TR>
          <TR>
            <TD>12082.000</TD>
            <TD>0.877206</TD>
          </TR>
          <TR>
            <TD>12084.000</TD>
            <TD>0.878009</TD>
          </TR>
          <TR>
            <TD>12086.000</TD>
            <TD>0.877927</TD>
          </TR>
          <TR>
            <TD>12088.000</TD>
            <TD>0.876833</TD>
          </TR>
          <TR>
            <TD>12090.000</TD>
            <TD>0.878426</TD>
          </TR>
          <TR>
            <TD>12092.000</TD>
            <TD>0.879375</TD>
          </TR>
          <TR>
            <TD>12094.000</TD>
            <TD>0.878844</TD>
          </TR>
          <TR>
            <TD>12096.000</TD>
            <TD>0.878915</TD>
          </TR>
          <TR>
            <TD>12098.000</TD>
            <TD>0.878498</TD>
          </TR>
          <TR>
            <TD>12100.000</TD>
            <TD>0.876465</TD>
          </TR>
          <TR>
            <TD>12102.000</TD>
            <TD>0.876396</TD>
          </TR>
          <TR>
            <TD>12104.000</TD>
            <TD>0.875412</TD>
          </TR>
          <TR>
            <TD>12106.000</TD>
            <TD>0.873495</TD>
          </TR>
          <TR>
            <TD>12108.000</TD>
            <TD>0.875034</TD>
          </TR>
          <TR>
            <TD>12110.000</TD>
            <TD>0.874296</TD>
          </TR>
          <TR>
            <TD>12112.000</TD>
            <TD>0.870992</TD>
          </TR>
          <TR>
            <TD>12114.000</TD>
            <TD>0.871589</TD>
          </TR>
          <TR>
            <TD>12116.000</TD>
            <TD>0.871163</TD>
          </TR>
          <TR>
            <TD>12118.000</TD>
            <TD>0.86836</TD>
          </TR>
          <TR>
            <TD>12120.000</TD>
            <TD>0.869746</TD>
          </TR>
          <TR>
            <TD>12122.000</TD>
            <TD>0.869336</TD>
          </TR>
          <TR>
            <TD>12124.000</TD>
            <TD>0.865943</TD>
          </TR>
          <TR>
            <TD>12126.000</TD>
            <TD>0.866126</TD>
          </TR>
          <TR>
            <TD>12128.000</TD>
            <TD>0.864262</TD>
          </TR>
          <TR>
            <TD>12130.000</TD>
            <TD>0.860283</TD>
          </TR>
          <TR>
            <TD>12132.000</TD>
            <TD>0.860149</TD>
          </TR>
          <TR>
            <TD>12134.000</TD>
            <TD>0.860091</TD>
          </TR>
          <TR>
            <TD>12136.000</TD>
            <TD>0.858275</TD>
          </TR>
          <TR>
            <TD>12138.000</TD>
            <TD>0.858459</TD>
          </TR>
          <TR>
            <TD>12140.000</TD>
            <TD>0.857394</TD>
          </TR>
          <TR>
            <TD>12142.000</TD>
            <TD>0.854107</TD>
          </TR>
          <TR>
            <TD>12144.000</TD>
            <TD>0.852464</TD>
          </TR>
          <TR>
            <TD>12146.000</TD>
            <TD>0.852223</TD>
          </TR>
          <TR>
            <TD>12148.000</TD>
            <TD>0.850078</TD>
          </TR>
          <TR>
            <TD>12150.000</TD>
            <TD>0.849831</TD>
          </TR>
          <TR>
            <TD>12152.000</TD>
            <TD>0.850654</TD>
          </TR>
          <TR>
            <TD>12154.000</TD>
            <TD>0.848021</TD>
          </TR>
          <TR>
            <TD>12156.000</TD>
            <TD>0.846976</TD>
          </TR>
          <TR>
            <TD>12158.000</TD>
            <TD>0.845688</TD>
          </TR>
          <TR>
            <TD>12160.000</TD>
            <TD>0.842149</TD>
          </TR>
          <TR>
            <TD>12162.000</TD>
            <TD>0.840481</TD>
          </TR>
          <TR>
            <TD>12164.000</TD>
            <TD>0.840966</TD>
          </TR>
          <TR>
            <TD>12166.000</TD>
            <TD>0.840079</TD>
          </TR>
          <TR>
            <TD>12168.000</TD>
            <TD>0.839474</TD>
          </TR>
          <TR>
            <TD>12170.000</TD>
            <TD>0.837945</TD>
          </TR>
          <TR>
            <TD>12172.000</TD>
            <TD>0.835428</TD>
          </TR>
          <TR>
            <TD>12174.000</TD>
            <TD>0.833924</TD>
          </TR>
          <TR>
            <TD>12176.000</TD>
            <TD>0.833174</TD>
          </TR>
          <TR>
            <TD>12178.000</TD>
            <TD>0.832157</TD>
          </TR>
          <TR>
            <TD>12180.000</TD>
            <TD>0.832233</TD>
          </TR>
          <TR>
            <TD>12182.000</TD>
            <TD>0.830375</TD>
          </TR>
          <TR>
            <TD>12184.000</TD>
            <TD>0.827777</TD>
          </TR>
          <TR>
            <TD>12186.000</TD>
            <TD>0.829249</TD>
          </TR>
          <TR>
            <TD>12188.000</TD>
            <TD>0.828246</TD>
          </TR>
          <TR>
            <TD>12190.000</TD>
            <TD>0.824525</TD>
          </TR>
          <TR>
            <TD>12192.000</TD>
            <TD>0.823141</TD>
          </TR>
          <TR>
            <TD>12194.000</TD>
            <TD>0.824536</TD>
          </TR>
          <TR>
            <TD>12196.000</TD>
            <TD>0.824458</TD>
          </TR>
          <TR>
            <TD>12198.000</TD>
            <TD>0.824606</TD>
          </TR>
          <TR>
            <TD>12200.000</TD>
            <TD>0.824782</TD>
          </TR>
          <TR>
            <TD>12202.000</TD>
            <TD>0.822712</TD>
          </TR>
          <TR>
            <TD>12204.000</TD>
            <TD>0.821649</TD>
          </TR>
          <TR>
            <TD>12206.000</TD>
            <TD>0.821137</TD>
          </TR>
          <TR>
            <TD>12208.000</TD>
            <TD>0.821203</TD>
          </TR>
          <TR>
            <TD>12210.000</TD>
            <TD>0.820925</TD>
          </TR>
          <TR>
            <TD>12212.000</TD>
            <TD>0.820921</TD>
          </TR>
          <TR>
            <TD>12214.000</TD>
            <TD>0.820652</TD>
          </TR>
          <TR>
            <TD>12216.000</TD>
            <TD>0.82058</TD>
          </TR>
          <TR>
            <TD>12218.000</TD>
            <TD>0.82023</TD>
          </TR>
          <TR>
            <TD>12220.000</TD>
            <TD>0.818945</TD>
          </TR>
          <TR>
            <TD>12222.000</TD>
            <TD>0.817584</TD>
          </TR>
          <TR>
            <TD>12224.000</TD>
            <TD>0.818325</TD>
          </TR>
          <TR>
            <TD>12226.000</TD>
            <TD>0.819715</TD>
          </TR>
          <TR>
            <TD>12228.000</TD>
            <TD>0.820139</TD>
          </TR>
          <TR>
            <TD>12230.000</TD>
            <TD>0.819315</TD>
          </TR>
          <TR>
            <TD>12232.000</TD>
            <TD>0.817283</TD>
          </TR>
          <TR>
            <TD>12234.000</TD>
            <TD>0.816442</TD>
          </TR>
          <TR>
            <TD>12236.000</TD>
            <TD>0.818628</TD>
          </TR>
          <TR>
            <TD>12238.000</TD>
            <TD>0.820426</TD>
          </TR>
          <TR>
            <TD>12240.000</TD>
            <TD>0.818601</TD>
          </TR>
          <TR>
            <TD>12242.000</TD>
            <TD>0.819792</TD>
          </TR>
          <TR>
            <TD>12244.000</TD>
            <TD>0.820461</TD>
          </TR>
          <TR>
            <TD>12246.000</TD>
            <TD>0.819217</TD>
          </TR>
          <TR>
            <TD>12248.000</TD>
            <TD>0.820551</TD>
          </TR>
          <TR>
            <TD>12250.000</TD>
            <TD>0.821314</TD>
          </TR>
          <TR>
            <TD>12252.000</TD>
            <TD>0.821196</TD>
          </TR>
          <TR>
            <TD>12254.000</TD>
            <TD>0.822973</TD>
          </TR>
          <TR>
            <TD>12256.000</TD>
            <TD>0.824072</TD>
          </TR>
          <TR>
            <TD>12258.000</TD>
            <TD>0.824361</TD>
          </TR>
          <TR>
            <TD>12260.000</TD>
            <TD>0.827149</TD>
          </TR>
          <TR>
            <TD>12262.000</TD>
            <TD>0.826832</TD>
          </TR>
          <TR>
            <TD>12264.000</TD>
            <TD>0.824184</TD>
          </TR>
          <TR>
            <TD>12266.000</TD>
            <TD>0.825961</TD>
          </TR>
          <TR>
            <TD>12268.000</TD>
            <TD>0.827802</TD>
          </TR>
          <TR>
            <TD>12270.000</TD>
            <TD>0.828267</TD>
          </TR>
          <TR>
            <TD>12272.000</TD>
            <TD>0.830016</TD>
          </TR>
          <TR>
            <TD>12274.000</TD>
            <TD>0.830984</TD>
          </TR>
          <TR>
            <TD>12276.000</TD>
            <TD>0.829976</TD>
          </TR>
          <TR>
            <TD>12278.000</TD>
            <TD>0.831583</TD>
          </TR>
          <TR>
            <TD>12280.000</TD>
            <TD>0.830586</TD>
          </TR>
          <TR>
            <TD>12282.000</TD>
            <TD>0.829136</TD>
          </TR>
          <TR>
            <TD>12284.000</TD>
            <TD>0.832325</TD>
          </TR>
          <TR>
            <TD>12286.000</TD>
            <TD>0.834436</TD>
          </TR>
          <TR>
            <TD>12288.000</TD>
            <TD>0.8356</TD>
          </TR>
          <TR>
            <TD>12290.000</TD>
            <TD>0.836554</TD>
          </TR>
          <TR>
            <TD>12292.000</TD>
            <TD>0.836152</TD>
          </TR>
          <TR>
            <TD>12294.000</TD>
            <TD>0.83512</TD>
          </TR>
          <TR>
            <TD>12296.000</TD>
            <TD>0.836958</TD>
          </TR>
          <TR>
            <TD>12298.000</TD>
            <TD>0.839103</TD>
          </TR>
          <TR>
            <TD>12300.000</TD>
            <TD>0.839915</TD>
          </TR>
          <TR>
            <TD>12302.000</TD>
            <TD>0.842315</TD>
          </TR>
          <TR>
            <TD>12304.000</TD>
            <TD>0.844236</TD>
          </TR>
          <TR>
            <TD>12306.000</TD>
            <TD>0.842566</TD>
          </TR>
          <TR>
            <TD>12308.000</TD>
            <TD>0.842493</TD>
          </TR>
          <TR>
            <TD>12310.000</TD>
            <TD>0.843191</TD>
          </TR>
          <TR>
            <TD>12312.000</TD>
            <TD>0.842605</TD>
          </TR>
          <TR>
            <TD>12314.000</TD>
            <TD>0.845349</TD>
          </TR>
          <TR>
            <TD>12316.000</TD>
            <TD>0.847487</TD>
          </TR>
          <TR>
            <TD>12318.000</TD>
            <TD>0.847494</TD>
          </TR>
          <TR>
            <TD>12320.000</TD>
            <TD>0.849393</TD>
          </TR>
          <TR>
            <TD>12322.000</TD>
            <TD>0.850563</TD>
          </TR>
          <TR>
            <TD>12324.000</TD>
            <TD>0.849701</TD>
          </TR>
          <TR>
            <TD>12326.000</TD>
            <TD>0.849972</TD>
          </TR>
          <TR>
            <TD>12328.000</TD>
            <TD>0.851159</TD>
          </TR>
          <TR>
            <TD>12330.000</TD>
            <TD>0.852737</TD>
          </TR>
          <TR>
            <TD>12332.000</TD>
            <TD>0.854548</TD>
          </TR>
          <TR>
            <TD>12334.000</TD>
            <TD>0.85609</TD>
          </TR>
          <TR>
            <TD>12336.000</TD>
            <TD>0.855978</TD>
          </TR>
          <TR>
            <TD>12338.000</TD>
            <TD>0.855998</TD>
          </TR>
          <TR>
            <TD>12340.000</TD>
            <TD>0.857691</TD>
          </TR>
          <TR>
            <TD>12342.000</TD>
            <TD>0.856888</TD>
          </TR>
          <TR>
            <TD>12344.000</TD>
            <TD>0.856091</TD>
          </TR>
          <TR>
            <TD>12346.000</TD>
            <TD>0.858794</TD>
          </TR>
          <TR>
            <TD>12348.000</TD>
            <TD>0.860023</TD>
          </TR>
          <TR>
            <TD>12350.000</TD>
            <TD>0.859756</TD>
          </TR>
          <TR>
            <TD>12352.000</TD>
            <TD>0.861226</TD>
          </TR>
          <TR>
            <TD>12354.000</TD>
            <TD>0.85941</TD>
          </TR>
          <TR>
            <TD>12356.000</TD>
            <TD>0.856762</TD>
          </TR>
          <TR>
            <TD>12358.000</TD>
            <TD>0.860469</TD>
          </TR>
          <TR>
            <TD>12360.000</TD>
            <TD>0.862613</TD>
          </TR>
          <TR>
            <TD>12362.000</TD>
            <TD>0.859895</TD>
          </TR>
          <TR>
            <TD>12364.000</TD>
            <TD>0.86295</TD>
          </TR>
          <TR>
            <TD>12366.000</TD>
            <TD>0.865415</TD>
          </TR>
          <TR>
            <TD>12368.000</TD>
            <TD>0.862143</TD>
          </TR>
          <TR>
            <TD>12370.000</TD>
            <TD>0.862862</TD>
          </TR>
          <TR>
            <TD>12372.000</TD>
            <TD>0.862581</TD>
          </TR>
          <TR>
            <TD>12374.000</TD>
            <TD>0.86078</TD>
          </TR>
          <TR>
            <TD>12376.000</TD>
            <TD>0.863302</TD>
          </TR>
          <TR>
            <TD>12378.000</TD>
            <TD>0.864518</TD>
          </TR>
          <TR>
            <TD>12380.000</TD>
            <TD>0.863105</TD>
          </TR>
          <TR>
            <TD>12382.000</TD>
            <TD>0.864947</TD>
          </TR>
          <TR>
            <TD>12384.000</TD>
            <TD>0.86476</TD>
          </TR>
          <TR>
            <TD>12386.000</TD>
            <TD>0.860972</TD>
          </TR>
          <TR>
            <TD>12388.000</TD>
            <TD>0.862592</TD>
          </TR>
          <TR>
            <TD>12390.000</TD>
            <TD>0.863319</TD>
          </TR>
          <TR>
            <TD>12392.000</TD>
            <TD>0.862064</TD>
          </TR>
          <TR>
            <TD>12394.000</TD>
            <TD>0.864771</TD>
          </TR>
          <TR>
            <TD>12396.000</TD>
            <TD>0.866315</TD>
          </TR>
          <TR>
            <TD>12398.000</TD>
            <TD>0.864446</TD>
          </TR>
          <TR>
            <TD>12400.000</TD>
            <TD>0.864806</TD>
          </TR>
          <TR>
            <TD>12402.000</TD>
            <TD>0.863707</TD>
          </TR>
          <TR>
            <TD>12404.000</TD>
            <TD>0.861821</TD>
          </TR>
          <TR>
            <TD>12406.000</TD>
            <TD>0.864606</TD>
          </TR>
          <TR>
            <TD>12408.000</TD>
            <TD>0.865303</TD>
          </TR>
          <TR>
            <TD>12410.000</TD>
            <TD>0.863114</TD>
          </TR>
          <TR>
            <TD>12412.000</TD>
            <TD>0.864071</TD>
          </TR>
          <TR>
            <TD>12414.000</TD>
            <TD>0.864513</TD>
          </TR>
          <TR>
            <TD>12416.000</TD>
            <TD>0.862063</TD>
          </TR>
          <TR>
            <TD>12418.000</TD>
            <TD>0.86083</TD>
          </TR>
          <TR>
            <TD>12420.000</TD>
            <TD>0.861986</TD>
          </TR>
          <TR>
            <TD>12422.000</TD>
            <TD>0.863135</TD>
          </TR>
          <TR>
            <TD>12424.000</TD>
            <TD>0.863223</TD>
          </TR>
          <TR>
            <TD>12426.000</TD>
            <TD>0.862601</TD>
          </TR>
          <TR>
            <TD>12428.000</TD>
            <TD>0.861209</TD>
          </TR>
          <TR>
            <TD>12430.000</TD>
            <TD>0.861291</TD>
          </TR>
          <TR>
            <TD>12432.000</TD>
            <TD>0.861143</TD>
          </TR>
          <TR>
            <TD>12434.000</TD>
            <TD>0.859248</TD>
          </TR>
          <TR>
            <TD>12436.000</TD>
            <TD>0.858927</TD>
          </TR>
          <TR>
            <TD>12438.000</TD>
            <TD>0.860641</TD>
          </TR>
          <TR>
            <TD>12440.000</TD>
            <TD>0.86077</TD>
          </TR>
          <TR>
            <TD>12442.000</TD>
            <TD>0.860938</TD>
          </TR>
          <TR>
            <TD>12444.000</TD>
            <TD>0.861757</TD>
          </TR>
          <TR>
            <TD>12446.000</TD>
            <TD>0.8599</TD>
          </TR>
          <TR>
            <TD>12448.000</TD>
            <TD>0.857359</TD>
          </TR>
          <TR>
            <TD>12450.000</TD>
            <TD>0.857692</TD>
          </TR>
          <TR>
            <TD>12452.000</TD>
            <TD>0.859022</TD>
          </TR>
          <TR>
            <TD>12454.000</TD>
            <TD>0.859868</TD>
          </TR>
          <TR>
            <TD>12456.000</TD>
            <TD>0.860407</TD>
          </TR>
          <TR>
            <TD>12458.000</TD>
            <TD>0.860469</TD>
          </TR>
          <TR>
            <TD>12460.000</TD>
            <TD>0.859811</TD>
          </TR>
          <TR>
            <TD>12462.000</TD>
            <TD>0.859293</TD>
          </TR>
          <TR>
            <TD>12464.000</TD>
            <TD>0.859722</TD>
          </TR>
          <TR>
            <TD>12466.000</TD>
            <TD>0.858766</TD>
          </TR>
          <TR>
            <TD>12468.000</TD>
            <TD>0.860427</TD>
          </TR>
          <TR>
            <TD>12470.000</TD>
            <TD>0.862642</TD>
          </TR>
          <TR>
            <TD>12472.000</TD>
            <TD>0.860257</TD>
          </TR>
          <TR>
            <TD>12474.000</TD>
            <TD>0.860269</TD>
          </TR>
          <TR>
            <TD>12476.000</TD>
            <TD>0.859852</TD>
          </TR>
          <TR>
            <TD>12478.000</TD>
            <TD>0.85831</TD>
          </TR>
          <TR>
            <TD>12480.000</TD>
            <TD>0.860027</TD>
          </TR>
          <TR>
            <TD>12482.000</TD>
            <TD>0.860492</TD>
          </TR>
          <TR>
            <TD>12484.000</TD>
            <TD>0.859553</TD>
          </TR>
          <TR>
            <TD>12486.000</TD>
            <TD>0.860203</TD>
          </TR>
          <TR>
            <TD>12488.000</TD>
            <TD>0.860686</TD>
          </TR>
          <TR>
            <TD>12490.000</TD>
            <TD>0.85951</TD>
          </TR>
          <TR>
            <TD>12492.000</TD>
            <TD>0.861157</TD>
          </TR>
          <TR>
            <TD>12494.000</TD>
            <TD>0.862204</TD>
          </TR>
          <TR>
            <TD>12496.000</TD>
            <TD>0.859591</TD>
          </TR>
          <TR>
            <TD>12498.000</TD>
            <TD>0.861183</TD>
          </TR>
          <TR>
            <TD>12500.000</TD>
            <TD>0.862864</TD>
          </TR>
          <TR>
            <TD>12502.000</TD>
            <TD>0.860551</TD>
          </TR>
          <TR>
            <TD>12504.000</TD>
            <TD>0.862041</TD>
          </TR>
          <TR>
            <TD>12506.000</TD>
            <TD>0.863471</TD>
          </TR>
          <TR>
            <TD>12508.000</TD>
            <TD>0.862243</TD>
          </TR>
          <TR>
            <TD>12510.000</TD>
            <TD>0.863627</TD>
          </TR>
          <TR>
            <TD>12512.000</TD>
            <TD>0.864007</TD>
          </TR>
          <TR>
            <TD>12514.000</TD>
            <TD>0.863505</TD>
          </TR>
          <TR>
            <TD>12516.000</TD>
            <TD>0.865657</TD>
          </TR>
          <TR>
            <TD>12518.000</TD>
            <TD>0.866214</TD>
          </TR>
          <TR>
            <TD>12520.000</TD>
            <TD>0.864365</TD>
          </TR>
          <TR>
            <TD>12522.000</TD>
            <TD>0.865352</TD>
          </TR>
          <TR>
            <TD>12524.000</TD>
            <TD>0.866628</TD>
          </TR>
          <TR>
            <TD>12526.000</TD>
            <TD>0.867738</TD>
          </TR>
          <TR>
            <TD>12528.000</TD>
            <TD>0.868992</TD>
          </TR>
          <TR>
            <TD>12530.000</TD>
            <TD>0.870599</TD>
          </TR>
          <TR>
            <TD>12532.000</TD>
            <TD>0.870805</TD>
          </TR>
          <TR>
            <TD>12534.000</TD>
            <TD>0.870985</TD>
          </TR>
          <TR>
            <TD>12536.000</TD>
            <TD>0.871631</TD>
          </TR>
          <TR>
            <TD>12538.000</TD>
            <TD>0.869816</TD>
          </TR>
          <TR>
            <TD>12540.000</TD>
            <TD>0.871381</TD>
          </TR>
          <TR>
            <TD>12542.000</TD>
            <TD>0.872885</TD>
          </TR>
          <TR>
            <TD>12544.000</TD>
            <TD>0.872369</TD>
          </TR>
          <TR>
            <TD>12546.000</TD>
            <TD>0.873469</TD>
          </TR>
          <TR>
            <TD>12548.000</TD>
            <TD>0.875334</TD>
          </TR>
          <TR>
            <TD>12550.000</TD>
            <TD>0.876367</TD>
          </TR>
          <TR>
            <TD>12552.000</TD>
            <TD>0.876707</TD>
          </TR>
          <TR>
            <TD>12554.000</TD>
            <TD>0.877869</TD>
          </TR>
          <TR>
            <TD>12556.000</TD>
            <TD>0.878807</TD>
          </TR>
          <TR>
            <TD>12558.000</TD>
            <TD>0.877804</TD>
          </TR>
          <TR>
            <TD>12560.000</TD>
            <TD>0.877643</TD>
          </TR>
          <TR>
            <TD>12562.000</TD>
            <TD>0.878939</TD>
          </TR>
          <TR>
            <TD>12564.000</TD>
            <TD>0.880232</TD>
          </TR>
          <TR>
            <TD>12566.000</TD>
            <TD>0.881718</TD>
          </TR>
          <TR>
            <TD>12568.000</TD>
            <TD>0.881453</TD>
          </TR>
          <TR>
            <TD>12570.000</TD>
            <TD>0.881932</TD>
          </TR>
          <TR>
            <TD>12572.000</TD>
            <TD>0.883488</TD>
          </TR>
          <TR>
            <TD>12574.000</TD>
            <TD>0.883662</TD>
          </TR>
          <TR>
            <TD>12576.000</TD>
            <TD>0.88495</TD>
          </TR>
          <TR>
            <TD>12578.000</TD>
            <TD>0.887448</TD>
          </TR>
          <TR>
            <TD>12580.000</TD>
            <TD>0.888862</TD>
          </TR>
          <TR>
            <TD>12582.000</TD>
            <TD>0.888037</TD>
          </TR>
          <TR>
            <TD>12584.000</TD>
            <TD>0.88906</TD>
          </TR>
          <TR>
            <TD>12586.000</TD>
            <TD>0.891111</TD>
          </TR>
          <TR>
            <TD>12588.000</TD>
            <TD>0.89149</TD>
          </TR>
          <TR>
            <TD>12590.000</TD>
            <TD>0.892228</TD>
          </TR>
          <TR>
            <TD>12592.000</TD>
            <TD>0.8931</TD>
          </TR>
          <TR>
            <TD>12594.000</TD>
            <TD>0.893973</TD>
          </TR>
          <TR>
            <TD>12596.000</TD>
            <TD>0.896638</TD>
          </TR>
          <TR>
            <TD>12598.000</TD>
            <TD>0.897296</TD>
          </TR>
          <TR>
            <TD>12600.000</TD>
            <TD>0.89545</TD>
          </TR>
          <TR>
            <TD>12602.000</TD>
            <TD>0.896147</TD>
          </TR>
          <TR>
            <TD>12604.000</TD>
            <TD>0.897849</TD>
          </TR>
          <TR>
            <TD>12606.000</TD>
            <TD>0.897979</TD>
          </TR>
          <TR>
            <TD>12608.000</TD>
            <TD>0.899818</TD>
          </TR>
          <TR>
            <TD>12610.000</TD>
            <TD>0.902117</TD>
          </TR>
          <TR>
            <TD>12612.000</TD>
            <TD>0.900817</TD>
          </TR>
          <TR>
            <TD>12614.000</TD>
            <TD>0.902031</TD>
          </TR>
          <TR>
            <TD>12616.000</TD>
            <TD>0.903761</TD>
          </TR>
          <TR>
            <TD>12618.000</TD>
            <TD>0.901933</TD>
          </TR>
          <TR>
            <TD>12620.000</TD>
            <TD>0.904219</TD>
          </TR>
          <TR>
            <TD>12622.000</TD>
            <TD>0.90555</TD>
          </TR>
          <TR>
            <TD>12624.000</TD>
            <TD>0.904303</TD>
          </TR>
          <TR>
            <TD>12626.000</TD>
            <TD>0.908339</TD>
          </TR>
          <TR>
            <TD>12628.000</TD>
            <TD>0.909042</TD>
          </TR>
          <TR>
            <TD>12630.000</TD>
            <TD>0.906015</TD>
          </TR>
          <TR>
            <TD>12632.000</TD>
            <TD>0.909004</TD>
          </TR>
          <TR>
            <TD>12634.000</TD>
            <TD>0.910467</TD>
          </TR>
          <TR>
            <TD>12636.000</TD>
            <TD>0.908781</TD>
          </TR>
          <TR>
            <TD>12638.000</TD>
            <TD>0.911251</TD>
          </TR>
          <TR>
            <TD>12640.000</TD>
            <TD>0.913265</TD>
          </TR>
          <TR>
            <TD>12642.000</TD>
            <TD>0.912894</TD>
          </TR>
          <TR>
            <TD>12644.000</TD>
            <TD>0.914652</TD>
          </TR>
          <TR>
            <TD>12646.000</TD>
            <TD>0.915259</TD>
          </TR>
          <TR>
            <TD>12648.000</TD>
            <TD>0.912805</TD>
          </TR>
          <TR>
            <TD>12650.000</TD>
            <TD>0.914747</TD>
          </TR>
          <TR>
            <TD>12652.000</TD>
            <TD>0.916168</TD>
          </TR>
          <TR>
            <TD>12654.000</TD>
            <TD>0.91575</TD>
          </TR>
          <TR>
            <TD>12656.000</TD>
            <TD>0.918711</TD>
          </TR>
          <TR>
            <TD>12658.000</TD>
            <TD>0.920357</TD>
          </TR>
          <TR>
            <TD>12660.000</TD>
            <TD>0.917933</TD>
          </TR>
          <TR>
            <TD>12662.000</TD>
            <TD>0.918273</TD>
          </TR>
          <TR>
            <TD>12664.000</TD>
            <TD>0.919155</TD>
          </TR>
          <TR>
            <TD>12666.000</TD>
            <TD>0.918485</TD>
          </TR>
          <TR>
            <TD>12668.000</TD>
            <TD>0.919645</TD>
          </TR>
          <TR>
            <TD>12670.000</TD>
            <TD>0.920933</TD>
          </TR>
          <TR>
            <TD>12672.000</TD>
            <TD>0.921093</TD>
          </TR>
          <TR>
            <TD>12674.000</TD>
            <TD>0.921814</TD>
          </TR>
          <TR>
            <TD>12676.000</TD>
            <TD>0.923304</TD>
          </TR>
          <TR>
            <TD>12678.000</TD>
            <TD>0.923075</TD>
          </TR>
          <TR>
            <TD>12680.000</TD>
            <TD>0.923092</TD>
          </TR>
          <TR>
            <TD>12682.000</TD>
            <TD>0.924487</TD>
          </TR>
          <TR>
            <TD>12684.000</TD>
            <TD>0.92482</TD>
          </TR>
          <TR>
            <TD>12686.000</TD>
            <TD>0.924506</TD>
          </TR>
          <TR>
            <TD>12688.000</TD>
            <TD>0.92621</TD>
          </TR>
          <TR>
            <TD>12690.000</TD>
            <TD>0.926741</TD>
          </TR>
          <TR>
            <TD>12692.000</TD>
            <TD>0.927857</TD>
          </TR>
          <TR>
            <TD>12694.000</TD>
            <TD>0.927943</TD>
          </TR>
          <TR>
            <TD>12696.000</TD>
            <TD>0.926199</TD>
          </TR>
          <TR>
            <TD>12698.000</TD>
            <TD>0.92669</TD>
          </TR>
          <TR>
            <TD>12700.000</TD>
            <TD>0.928012</TD>
          </TR>
          <TR>
            <TD>12702.000</TD>
            <TD>0.928298</TD>
          </TR>
          <TR>
            <TD>12704.000</TD>
            <TD>0.927583</TD>
          </TR>
          <TR>
            <TD>12706.000</TD>
            <TD>0.928059</TD>
          </TR>
          <TR>
            <TD>12708.000</TD>
            <TD>0.929593</TD>
          </TR>
          <TR>
            <TD>12710.000</TD>
            <TD>0.92958</TD>
          </TR>
          <TR>
            <TD>12712.000</TD>
            <TD>0.929553</TD>
          </TR>
          <TR>
            <TD>12714.000</TD>
            <TD>0.930157</TD>
          </TR>
          <TR>
            <TD>12716.000</TD>
            <TD>0.929916</TD>
          </TR>
          <TR>
            <TD>12718.000</TD>
            <TD>0.930905</TD>
          </TR>
          <TR>
            <TD>12720.000</TD>
            <TD>0.932258</TD>
          </TR>
          <TR>
            <TD>12722.000</TD>
            <TD>0.931635</TD>
          </TR>
          <TR>
            <TD>12724.000</TD>
            <TD>0.932747</TD>
          </TR>
          <TR>
            <TD>12726.000</TD>
            <TD>0.933012</TD>
          </TR>
          <TR>
            <TD>12728.000</TD>
            <TD>0.929655</TD>
          </TR>
          <TR>
            <TD>12730.000</TD>
            <TD>0.929506</TD>
          </TR>
          <TR>
            <TD>12732.000</TD>
            <TD>0.93098</TD>
          </TR>
          <TR>
            <TD>12734.000</TD>
            <TD>0.930129</TD>
          </TR>
          <TR>
            <TD>12736.000</TD>
            <TD>0.932734</TD>
          </TR>
          <TR>
            <TD>12738.000</TD>
            <TD>0.935175</TD>
          </TR>
          <TR>
            <TD>12740.000</TD>
            <TD>0.932868</TD>
          </TR>
          <TR>
            <TD>12742.000</TD>
            <TD>0.932227</TD>
          </TR>
          <TR>
            <TD>12744.000</TD>
            <TD>0.931858</TD>
          </TR>
          <TR>
            <TD>12746.000</TD>
            <TD>0.929698</TD>
          </TR>
          <TR>
            <TD>12748.000</TD>
            <TD>0.930715</TD>
          </TR>
          <TR>
            <TD>12750.000</TD>
            <TD>0.933133</TD>
          </TR>
          <TR>
            <TD>12752.000</TD>
            <TD>0.931992</TD>
          </TR>
          <TR>
            <TD>12754.000</TD>
            <TD>0.932475</TD>
          </TR>
          <TR>
            <TD>12756.000</TD>
            <TD>0.931791</TD>
          </TR>
          <TR>
            <TD>12758.000</TD>
            <TD>0.928244</TD>
          </TR>
          <TR>
            <TD>12760.000</TD>
            <TD>0.929434</TD>
          </TR>
          <TR>
            <TD>12762.000</TD>
            <TD>0.929309</TD>
          </TR>
          <TR>
            <TD>12764.000</TD>
            <TD>0.927386</TD>
          </TR>
          <TR>
            <TD>12766.000</TD>
            <TD>0.92918</TD>
          </TR>
          <TR>
            <TD>12768.000</TD>
            <TD>0.930352</TD>
          </TR>
          <TR>
            <TD>12770.000</TD>
            <TD>0.929768</TD>
          </TR>
          <TR>
            <TD>12772.000</TD>
            <TD>0.9312</TD>
          </TR>
          <TR>
            <TD>12774.000</TD>
            <TD>0.930125</TD>
          </TR>
          <TR>
            <TD>12776.000</TD>
            <TD>0.927161</TD>
          </TR>
          <TR>
            <TD>12778.000</TD>
            <TD>0.928066</TD>
          </TR>
          <TR>
            <TD>12780.000</TD>
            <TD>0.928482</TD>
          </TR>
          <TR>
            <TD>12782.000</TD>
            <TD>0.927737</TD>
          </TR>
          <TR>
            <TD>12784.000</TD>
            <TD>0.929458</TD>
          </TR>
          <TR>
            <TD>12786.000</TD>
            <TD>0.928902</TD>
          </TR>
          <TR>
            <TD>12788.000</TD>
            <TD>0.925669</TD>
          </TR>
          <TR>
            <TD>12790.000</TD>
            <TD>0.925638</TD>
          </TR>
          <TR>
            <TD>12792.000</TD>
            <TD>0.925511</TD>
          </TR>
          <TR>
            <TD>12794.000</TD>
            <TD>0.924538</TD>
          </TR>
          <TR>
            <TD>12796.000</TD>
            <TD>0.92498</TD>
          </TR>
          <TR>
            <TD>12798.000</TD>
            <TD>0.925857</TD>
          </TR>
          <TR>
            <TD>12800.000</TD>
            <TD>0.925579</TD>
          </TR>
          <TR>
            <TD>12802.000</TD>
            <TD>0.923972</TD>
          </TR>
          <TR>
            <TD>12804.000</TD>
            <TD>0.921048</TD>
          </TR>
          <TR>
            <TD>12806.000</TD>
            <TD>0.919671</TD>
          </TR>
          <TR>
            <TD>12808.000</TD>
            <TD>0.920183</TD>
          </TR>
          <TR>
            <TD>12810.000</TD>
            <TD>0.921005</TD>
          </TR>
          <TR>
            <TD>12812.000</TD>
            <TD>0.921307</TD>
          </TR>
          <TR>
            <TD>12814.000</TD>
            <TD>0.920872</TD>
          </TR>
          <TR>
            <TD>12816.000</TD>
            <TD>0.920178</TD>
          </TR>
          <TR>
            <TD>12818.000</TD>
            <TD>0.917231</TD>
          </TR>
          <TR>
            <TD>12820.000</TD>
            <TD>0.914722</TD>
          </TR>
          <TR>
            <TD>12822.000</TD>
            <TD>0.914257</TD>
          </TR>
          <TR>
            <TD>12824.000</TD>
            <TD>0.913936</TD>
          </TR>
          <TR>
            <TD>12826.000</TD>
            <TD>0.915288</TD>
          </TR>
          <TR>
            <TD>12828.000</TD>
            <TD>0.915752</TD>
          </TR>
          <TR>
            <TD>12830.000</TD>
            <TD>0.914252</TD>
          </TR>
          <TR>
            <TD>12832.000</TD>
            <TD>0.913603</TD>
          </TR>
          <TR>
            <TD>12834.000</TD>
            <TD>0.911598</TD>
          </TR>
          <TR>
            <TD>12836.000</TD>
            <TD>0.910111</TD>
          </TR>
          <TR>
            <TD>12838.000</TD>
            <TD>0.911025</TD>
          </TR>
          <TR>
            <TD>12840.000</TD>
            <TD>0.911399</TD>
          </TR>
          <TR>
            <TD>12842.000</TD>
            <TD>0.911427</TD>
          </TR>
          <TR>
            <TD>12844.000</TD>
            <TD>0.910296</TD>
          </TR>
          <TR>
            <TD>12846.000</TD>
            <TD>0.908355</TD>
          </TR>
          <TR>
            <TD>12848.000</TD>
            <TD>0.907117</TD>
          </TR>
          <TR>
            <TD>12850.000</TD>
            <TD>0.905015</TD>
          </TR>
          <TR>
            <TD>12852.000</TD>
            <TD>0.903453</TD>
          </TR>
          <TR>
            <TD>12854.000</TD>
            <TD>0.904261</TD>
          </TR>
          <TR>
            <TD>12856.000</TD>
            <TD>0.905812</TD>
          </TR>
          <TR>
            <TD>12858.000</TD>
            <TD>0.905643</TD>
          </TR>
          <TR>
            <TD>12860.000</TD>
            <TD>0.903189</TD>
          </TR>
          <TR>
            <TD>12862.000</TD>
            <TD>0.900626</TD>
          </TR>
          <TR>
            <TD>12864.000</TD>
            <TD>0.900065</TD>
          </TR>
          <TR>
            <TD>12866.000</TD>
            <TD>0.898295</TD>
          </TR>
          <TR>
            <TD>12868.000</TD>
            <TD>0.897884</TD>
          </TR>
          <TR>
            <TD>12870.000</TD>
            <TD>0.901138</TD>
          </TR>
          <TR>
            <TD>12872.000</TD>
            <TD>0.900563</TD>
          </TR>
          <TR>
            <TD>12874.000</TD>
            <TD>0.896918</TD>
          </TR>
          <TR>
            <TD>12876.000</TD>
            <TD>0.895553</TD>
          </TR>
          <TR>
            <TD>12878.000</TD>
            <TD>0.894771</TD>
          </TR>
          <TR>
            <TD>12880.000</TD>
            <TD>0.893363</TD>
          </TR>
          <TR>
            <TD>12882.000</TD>
            <TD>0.893795</TD>
          </TR>
          <TR>
            <TD>12884.000</TD>
            <TD>0.894097</TD>
          </TR>
          <TR>
            <TD>12886.000</TD>
            <TD>0.891691</TD>
          </TR>
          <TR>
            <TD>12888.000</TD>
            <TD>0.891839</TD>
          </TR>
          <TR>
            <TD>12890.000</TD>
            <TD>0.891578</TD>
          </TR>
          <TR>
            <TD>12892.000</TD>
            <TD>0.887766</TD>
          </TR>
          <TR>
            <TD>12894.000</TD>
            <TD>0.887864</TD>
          </TR>
          <TR>
            <TD>12896.000</TD>
            <TD>0.889019</TD>
          </TR>
          <TR>
            <TD>12898.000</TD>
            <TD>0.887293</TD>
          </TR>
          <TR>
            <TD>12900.000</TD>
            <TD>0.887518</TD>
          </TR>
          <TR>
            <TD>12902.000</TD>
            <TD>0.887211</TD>
          </TR>
          <TR>
            <TD>12904.000</TD>
            <TD>0.885324</TD>
          </TR>
          <TR>
            <TD>12906.000</TD>
            <TD>0.885961</TD>
          </TR>
          <TR>
            <TD>12908.000</TD>
            <TD>0.885085</TD>
          </TR>
          <TR>
            <TD>12910.000</TD>
            <TD>0.883184</TD>
          </TR>
          <TR>
            <TD>12912.000</TD>
            <TD>0.88503</TD>
          </TR>
          <TR>
            <TD>12914.000</TD>
            <TD>0.884662</TD>
          </TR>
          <TR>
            <TD>12916.000</TD>
            <TD>0.882874</TD>
          </TR>
          <TR>
            <TD>12918.000</TD>
            <TD>0.883915</TD>
          </TR>
          <TR>
            <TD>12920.000</TD>
            <TD>0.884009</TD>
          </TR>
          <TR>
            <TD>12922.000</TD>
            <TD>0.881448</TD>
          </TR>
          <TR>
            <TD>12924.000</TD>
            <TD>0.880301</TD>
          </TR>
          <TR>
            <TD>12926.000</TD>
            <TD>0.880788</TD>
          </TR>
          <TR>
            <TD>12928.000</TD>
            <TD>0.881472</TD>
          </TR>
          <TR>
            <TD>12930.000</TD>
            <TD>0.881999</TD>
          </TR>
          <TR>
            <TD>12932.000</TD>
            <TD>0.881279</TD>
          </TR>
          <TR>
            <TD>12934.000</TD>
            <TD>0.880817</TD>
          </TR>
          <TR>
            <TD>12936.000</TD>
            <TD>0.879619</TD>
          </TR>
          <TR>
            <TD>12938.000</TD>
            <TD>0.877503</TD>
          </TR>
          <TR>
            <TD>12940.000</TD>
            <TD>0.876735</TD>
          </TR>
          <TR>
            <TD>12942.000</TD>
            <TD>0.877275</TD>
          </TR>
          <TR>
            <TD>12944.000</TD>
            <TD>0.87738</TD>
          </TR>
          <TR>
            <TD>12946.000</TD>
            <TD>0.875621</TD>
          </TR>
          <TR>
            <TD>12948.000</TD>
            <TD>0.875206</TD>
          </TR>
          <TR>
            <TD>12950.000</TD>
            <TD>0.875615</TD>
          </TR>
          <TR>
            <TD>12952.000</TD>
            <TD>0.87341</TD>
          </TR>
          <TR>
            <TD>12954.000</TD>
            <TD>0.872697</TD>
          </TR>
          <TR>
            <TD>12956.000</TD>
            <TD>0.873983</TD>
          </TR>
          <TR>
            <TD>12958.000</TD>
            <TD>0.874504</TD>
          </TR>
          <TR>
            <TD>12960.000</TD>
            <TD>0.875143</TD>
          </TR>
          <TR>
            <TD>12962.000</TD>
            <TD>0.874446</TD>
          </TR>
          <TR>
            <TD>12964.000</TD>
            <TD>0.873985</TD>
          </TR>
          <TR>
            <TD>12966.000</TD>
            <TD>0.874875</TD>
          </TR>
          <TR>
            <TD>12968.000</TD>
            <TD>0.874493</TD>
          </TR>
          <TR>
            <TD>12970.000</TD>
            <TD>0.874332</TD>
          </TR>
          <TR>
            <TD>12972.000</TD>
            <TD>0.873599</TD>
          </TR>
          <TR>
            <TD>12974.000</TD>
            <TD>0.873401</TD>
          </TR>
          <TR>
            <TD>12976.000</TD>
            <TD>0.873773</TD>
          </TR>
          <TR>
            <TD>12978.000</TD>
            <TD>0.87323</TD>
          </TR>
          <TR>
            <TD>12980.000</TD>
            <TD>0.872899</TD>
          </TR>
          <TR>
            <TD>12982.000</TD>
            <TD>0.873857</TD>
          </TR>
          <TR>
            <TD>12984.000</TD>
            <TD>0.872409</TD>
          </TR>
          <TR>
            <TD>12986.000</TD>
            <TD>0.869987</TD>
          </TR>
          <TR>
            <TD>12988.000</TD>
            <TD>0.869379</TD>
          </TR>
          <TR>
            <TD>12990.000</TD>
            <TD>0.869459</TD>
          </TR>
          <TR>
            <TD>12992.000</TD>
            <TD>0.870298</TD>
          </TR>
          <TR>
            <TD>12994.000</TD>
            <TD>0.869769</TD>
          </TR>
          <TR>
            <TD>12996.000</TD>
            <TD>0.869363</TD>
          </TR>
          <TR>
            <TD>12998.000</TD>
            <TD>0.869212</TD>
          </TR>
          <TR>
            <TD>13000.000</TD>
            <TD>0.867998</TD>
          </TR>
          <TR>
            <TD>13002.000</TD>
            <TD>0.867951</TD>
          </TR>
          <TR>
            <TD>13004.000</TD>
            <TD>0.868368</TD>
          </TR>
          <TR>
            <TD>13006.000</TD>
            <TD>0.869248</TD>
          </TR>
          <TR>
            <TD>13008.000</TD>
            <TD>0.868969</TD>
          </TR>
          <TR>
            <TD>13010.000</TD>
            <TD>0.867895</TD>
          </TR>
          <TR>
            <TD>13012.000</TD>
            <TD>0.867498</TD>
          </TR>
          <TR>
            <TD>13014.000</TD>
            <TD>0.865585</TD>
          </TR>
          <TR>
            <TD>13016.000</TD>
            <TD>0.864971</TD>
          </TR>
          <TR>
            <TD>13018.000</TD>
            <TD>0.864739</TD>
          </TR>
          <TR>
            <TD>13020.000</TD>
            <TD>0.865765</TD>
          </TR>
          <TR>
            <TD>13022.000</TD>
            <TD>0.866397</TD>
          </TR>
          <TR>
            <TD>13024.000</TD>
            <TD>0.864785</TD>
          </TR>
          <TR>
            <TD>13026.000</TD>
            <TD>0.863641</TD>
          </TR>
          <TR>
            <TD>13028.000</TD>
            <TD>0.861635</TD>
          </TR>
          <TR>
            <TD>13030.000</TD>
            <TD>0.86055</TD>
          </TR>
          <TR>
            <TD>13032.000</TD>
            <TD>0.860276</TD>
          </TR>
          <TR>
            <TD>13034.000</TD>
            <TD>0.859403</TD>
          </TR>
          <TR>
            <TD>13036.000</TD>
            <TD>0.859425</TD>
          </TR>
          <TR>
            <TD>13038.000</TD>
            <TD>0.859251</TD>
          </TR>
          <TR>
            <TD>13040.000</TD>
            <TD>0.858575</TD>
          </TR>
          <TR>
            <TD>13042.000</TD>
            <TD>0.858636</TD>
          </TR>
          <TR>
            <TD>13044.000</TD>
            <TD>0.857653</TD>
          </TR>
          <TR>
            <TD>13046.000</TD>
            <TD>0.855614</TD>
          </TR>
          <TR>
            <TD>13048.000</TD>
            <TD>0.855356</TD>
          </TR>
          <TR>
            <TD>13050.000</TD>
            <TD>0.855104</TD>
          </TR>
          <TR>
            <TD>13052.000</TD>
            <TD>0.853937</TD>
          </TR>
          <TR>
            <TD>13054.000</TD>
            <TD>0.853522</TD>
          </TR>
          <TR>
            <TD>13056.000</TD>
            <TD>0.852439</TD>
          </TR>
          <TR>
            <TD>13058.000</TD>
            <TD>0.850314</TD>
          </TR>
          <TR>
            <TD>13060.000</TD>
            <TD>0.848665</TD>
          </TR>
          <TR>
            <TD>13062.000</TD>
            <TD>0.84935</TD>
          </TR>
          <TR>
            <TD>13064.000</TD>
            <TD>0.847849</TD>
          </TR>
          <TR>
            <TD>13066.000</TD>
            <TD>0.846905</TD>
          </TR>
          <TR>
            <TD>13068.000</TD>
            <TD>0.847961</TD>
          </TR>
          <TR>
            <TD>13070.000</TD>
            <TD>0.845161</TD>
          </TR>
          <TR>
            <TD>13072.000</TD>
            <TD>0.844856</TD>
          </TR>
          <TR>
            <TD>13074.000</TD>
            <TD>0.843848</TD>
          </TR>
          <TR>
            <TD>13076.000</TD>
            <TD>0.842571</TD>
          </TR>
          <TR>
            <TD>13078.000</TD>
            <TD>0.843735</TD>
          </TR>
          <TR>
            <TD>13080.000</TD>
            <TD>0.842718</TD>
          </TR>
          <TR>
            <TD>13082.000</TD>
            <TD>0.841763</TD>
          </TR>
          <TR>
            <TD>13084.000</TD>
            <TD>0.841774</TD>
          </TR>
          <TR>
            <TD>13086.000</TD>
            <TD>0.840985</TD>
          </TR>
          <TR>
            <TD>13088.000</TD>
            <TD>0.838294</TD>
          </TR>
          <TR>
            <TD>13090.000</TD>
            <TD>0.837269</TD>
          </TR>
          <TR>
            <TD>13092.000</TD>
            <TD>0.837832</TD>
          </TR>
          <TR>
            <TD>13094.000</TD>
            <TD>0.838286</TD>
          </TR>
          <TR>
            <TD>13096.000</TD>
            <TD>0.838983</TD>
          </TR>
          <TR>
            <TD>13098.000</TD>
            <TD>0.839594</TD>
          </TR>
          <TR>
            <TD>13100.000</TD>
            <TD>0.838056</TD>
          </TR>
          <TR>
            <TD>13102.000</TD>
            <TD>0.837208</TD>
          </TR>
          <TR>
            <TD>13104.000</TD>
            <TD>0.837155</TD>
          </TR>
          <TR>
            <TD>13106.000</TD>
            <TD>0.834696</TD>
          </TR>
          <TR>
            <TD>13108.000</TD>
            <TD>0.833982</TD>
          </TR>
          <TR>
            <TD>13110.000</TD>
            <TD>0.835516</TD>
          </TR>
          <TR>
            <TD>13112.000</TD>
            <TD>0.834995</TD>
          </TR>
          <TR>
            <TD>13114.000</TD>
            <TD>0.834686</TD>
          </TR>
          <TR>
            <TD>13116.000</TD>
            <TD>0.835641</TD>
          </TR>
          <TR>
            <TD>13118.000</TD>
            <TD>0.834216</TD>
          </TR>
          <TR>
            <TD>13120.000</TD>
            <TD>0.83309</TD>
          </TR>
          <TR>
            <TD>13122.000</TD>
            <TD>0.833739</TD>
          </TR>
          <TR>
            <TD>13124.000</TD>
            <TD>0.835365</TD>
          </TR>
          <TR>
            <TD>13126.000</TD>
            <TD>0.835506</TD>
          </TR>
          <TR>
            <TD>13128.000</TD>
            <TD>0.835599</TD>
          </TR>
          <TR>
            <TD>13130.000</TD>
            <TD>0.837447</TD>
          </TR>
          <TR>
            <TD>13132.000</TD>
            <TD>0.837922</TD>
          </TR>
          <TR>
            <TD>13134.000</TD>
            <TD>0.838457</TD>
          </TR>
          <TR>
            <TD>13136.000</TD>
            <TD>0.838935</TD>
          </TR>
          <TR>
            <TD>13138.000</TD>
            <TD>0.840555</TD>
          </TR>
          <TR>
            <TD>13140.000</TD>
            <TD>0.842916</TD>
          </TR>
          <TR>
            <TD>13142.000</TD>
            <TD>0.843578</TD>
          </TR>
          <TR>
            <TD>13144.000</TD>
            <TD>0.844578</TD>
          </TR>
          <TR>
            <TD>13146.000</TD>
            <TD>0.847239</TD>
          </TR>
          <TR>
            <TD>13148.000</TD>
            <TD>0.847549</TD>
          </TR>
          <TR>
            <TD>13150.000</TD>
            <TD>0.848224</TD>
          </TR>
          <TR>
            <TD>13152.000</TD>
            <TD>0.850097</TD>
          </TR>
          <TR>
            <TD>13154.000</TD>
            <TD>0.850516</TD>
          </TR>
          <TR>
            <TD>13156.000</TD>
            <TD>0.853136</TD>
          </TR>
          <TR>
            <TD>13158.000</TD>
            <TD>0.856424</TD>
          </TR>
          <TR>
            <TD>13160.000</TD>
            <TD>0.857481</TD>
          </TR>
          <TR>
            <TD>13162.000</TD>
            <TD>0.859718</TD>
          </TR>
          <TR>
            <TD>13164.000</TD>
            <TD>0.86223</TD>
          </TR>
          <TR>
            <TD>13166.000</TD>
            <TD>0.863524</TD>
          </TR>
          <TR>
            <TD>13168.000</TD>
            <TD>0.865038</TD>
          </TR>
          <TR>
            <TD>13170.000</TD>
            <TD>0.867324</TD>
          </TR>
          <TR>
            <TD>13172.000</TD>
            <TD>0.869602</TD>
          </TR>
          <TR>
            <TD>13174.000</TD>
            <TD>0.87076</TD>
          </TR>
          <TR>
            <TD>13176.000</TD>
            <TD>0.873228</TD>
          </TR>
          <TR>
            <TD>13178.000</TD>
            <TD>0.87663</TD>
          </TR>
          <TR>
            <TD>13180.000</TD>
            <TD>0.879268</TD>
          </TR>
          <TR>
            <TD>13182.000</TD>
            <TD>0.881782</TD>
          </TR>
          <TR>
            <TD>13184.000</TD>
            <TD>0.881804</TD>
          </TR>
          <TR>
            <TD>13186.000</TD>
            <TD>0.882548</TD>
          </TR>
          <TR>
            <TD>13188.000</TD>
            <TD>0.88606</TD>
          </TR>
          <TR>
            <TD>13190.000</TD>
            <TD>0.888232</TD>
          </TR>
          <TR>
            <TD>13192.000</TD>
            <TD>0.888254</TD>
          </TR>
          <TR>
            <TD>13194.000</TD>
            <TD>0.891305</TD>
          </TR>
          <TR>
            <TD>13196.000</TD>
            <TD>0.89374</TD>
          </TR>
          <TR>
            <TD>13198.000</TD>
            <TD>0.892558</TD>
          </TR>
          <TR>
            <TD>13200.000</TD>
            <TD>0.893993</TD>
          </TR>
          <TR>
            <TD>13202.000</TD>
            <TD>0.89503</TD>
          </TR>
          <TR>
            <TD>13204.000</TD>
            <TD>0.895271</TD>
          </TR>
          <TR>
            <TD>13206.000</TD>
            <TD>0.895822</TD>
          </TR>
          <TR>
            <TD>13208.000</TD>
            <TD>0.895986</TD>
          </TR>
          <TR>
            <TD>13210.000</TD>
            <TD>0.893304</TD>
          </TR>
          <TR>
            <TD>13212.000</TD>
            <TD>0.891777</TD>
          </TR>
          <TR>
            <TD>13214.000</TD>
            <TD>0.889591</TD>
          </TR>
          <TR>
            <TD>13216.000</TD>
            <TD>0.885453</TD>
          </TR>
          <TR>
            <TD>13218.000</TD>
            <TD>0.882193</TD>
          </TR>
          <TR>
            <TD>13220.000</TD>
            <TD>0.879649</TD>
          </TR>
          <TR>
            <TD>13222.000</TD>
            <TD>0.87514</TD>
          </TR>
          <TR>
            <TD>13224.000</TD>
            <TD>0.870822</TD>
          </TR>
          <TR>
            <TD>13226.000</TD>
            <TD>0.865422</TD>
          </TR>
          <TR>
            <TD>13228.000</TD>
            <TD>0.856119</TD>
          </TR>
          <TR>
            <TD>13230.000</TD>
            <TD>0.849135</TD>
          </TR>
          <TR>
            <TD>13232.000</TD>
            <TD>0.842122</TD>
          </TR>
          <TR>
            <TD>13234.000</TD>
            <TD>0.832961</TD>
          </TR>
          <TR>
            <TD>13236.000</TD>
            <TD>0.823458</TD>
          </TR>
          <TR>
            <TD>13238.000</TD>
            <TD>0.812566</TD>
          </TR>
          <TR>
            <TD>13240.000</TD>
            <TD>0.799244</TD>
          </TR>
          <TR>
            <TD>13242.000</TD>
            <TD>0.786793</TD>
          </TR>
          <TR>
            <TD>13244.000</TD>
            <TD>0.777435</TD>
          </TR>
          <TR>
            <TD>13246.000</TD>
            <TD>0.764262</TD>
          </TR>
          <TR>
            <TD>13248.000</TD>
            <TD>0.747548</TD>
          </TR>
          <TR>
            <TD>13250.000</TD>
            <TD>0.734425</TD>
          </TR>
          <TR>
            <TD>13252.000</TD>
            <TD>0.718288</TD>
          </TR>
          <TR>
            <TD>13254.000</TD>
            <TD>0.701279</TD>
          </TR>
          <TR>
            <TD>13256.000</TD>
            <TD>0.685237</TD>
          </TR>
          <TR>
            <TD>13258.000</TD>
            <TD>0.666387</TD>
          </TR>
          <TR>
            <TD>13260.000</TD>
            <TD>0.648447</TD>
          </TR>
          <TR>
            <TD>13262.000</TD>
            <TD>0.631387</TD>
          </TR>
          <TR>
            <TD>13264.000</TD>
            <TD>0.616274</TD>
          </TR>
          <TR>
            <TD>13266.000</TD>
            <TD>0.600329</TD>
          </TR>
          <TR>
            <TD>13268.000</TD>
            <TD>0.57918</TD>
          </TR>
          <TR>
            <TD>13270.000</TD>
            <TD>0.56109</TD>
          </TR>
          <TR>
            <TD>13272.000</TD>
            <TD>0.543777</TD>
          </TR>
          <TR>
            <TD>13274.000</TD>
            <TD>0.523869</TD>
          </TR>
          <TR>
            <TD>13276.000</TD>
            <TD>0.505991</TD>
          </TR>
          <TR>
            <TD>13278.000</TD>
            <TD>0.486397</TD>
          </TR>
          <TR>
            <TD>13280.000</TD>
            <TD>0.468159</TD>
          </TR>
          <TR>
            <TD>13282.000</TD>
            <TD>0.452663</TD>
          </TR>
          <TR>
            <TD>13284.000</TD>
            <TD>0.436789</TD>
          </TR>
          <TR>
            <TD>13286.000</TD>
            <TD>0.418871</TD>
          </TR>
          <TR>
            <TD>13288.000</TD>
            <TD>0.400825</TD>
          </TR>
          <TR>
            <TD>13290.000</TD>
            <TD>0.385848</TD>
          </TR>
          <TR>
            <TD>13292.000</TD>
            <TD>0.368782</TD>
          </TR>
          <TR>
            <TD>13294.000</TD>
            <TD>0.353852</TD>
          </TR>
          <TR>
            <TD>13296.000</TD>
            <TD>0.341527</TD>
          </TR>
          <TR>
            <TD>13298.000</TD>
            <TD>0.32469</TD>
          </TR>
          <TR>
            <TD>13300.000</TD>
            <TD>0.31086</TD>
          </TR>
          <TR>
            <TD>13302.000</TD>
            <TD>0.299006</TD>
          </TR>
          <TR>
            <TD>13304.000</TD>
            <TD>0.284954</TD>
          </TR>
          <TR>
            <TD>13306.000</TD>
            <TD>0.274802</TD>
          </TR>
          <TR>
            <TD>13308.000</TD>
            <TD>0.263486</TD>
          </TR>
          <TR>
            <TD>13310.000</TD>
            <TD>0.249609</TD>
          </TR>
          <TR>
            <TD>13312.000</TD>
            <TD>0.238996</TD>
          </TR>
          <TR>
            <TD>13314.000</TD>
            <TD>0.229322</TD>
          </TR>
          <TR>
            <TD>13316.000</TD>
            <TD>0.218514</TD>
          </TR>
          <TR>
            <TD>13318.000</TD>
            <TD>0.208581</TD>
          </TR>
          <TR>
            <TD>13320.000</TD>
            <TD>0.200136</TD>
          </TR>
          <TR>
            <TD>13322.000</TD>
            <TD>0.191228</TD>
          </TR>
          <TR>
            <TD>13324.000</TD>
            <TD>0.182704</TD>
          </TR>
          <TR>
            <TD>13326.000</TD>
            <TD>0.175528</TD>
          </TR>
          <TR>
            <TD>13328.000</TD>
            <TD>0.167203</TD>
          </TR>
          <TR>
            <TD>13330.000</TD>
            <TD>0.159748</TD>
          </TR>
          <TR>
            <TD>13332.000</TD>
            <TD>0.153587</TD>
          </TR>
          <TR>
            <TD>13334.000</TD>
            <TD>0.146197</TD>
          </TR>
          <TR>
            <TD>13336.000</TD>
            <TD>0.14032</TD>
          </TR>
          <TR>
            <TD>13338.000</TD>
            <TD>0.134145</TD>
          </TR>
          <TR>
            <TD>13340.000</TD>
            <TD>0.127358</TD>
          </TR>
          <TR>
            <TD>13342.000</TD>
            <TD>0.122593</TD>
          </TR>
          <TR>
            <TD>13344.000</TD>
            <TD>0.118147</TD>
          </TR>
          <TR>
            <TD>13346.000</TD>
            <TD>0.112947</TD>
          </TR>
          <TR>
            <TD>13348.000</TD>
            <TD>0.108343</TD>
          </TR>
          <TR>
            <TD>13350.000</TD>
            <TD>0.103837</TD>
          </TR>
          <TR>
            <TD>13352.000</TD>
            <TD>0.0985753</TD>
          </TR>
          <TR>
            <TD>13354.000</TD>
            <TD>0.0947733</TD>
          </TR>
          <TR>
            <TD>13356.000</TD>
            <TD>0.0912243</TD>
          </TR>
          <TR>
            <TD>13358.000</TD>
            <TD>0.0855923</TD>
          </TR>
          <TR>
            <TD>13360.000</TD>
            <TD>0.0828014</TD>
          </TR>
          <TR>
            <TD>13362.000</TD>
            <TD>0.0814532</TD>
          </TR>
          <TR>
            <TD>13364.000</TD>
            <TD>0.0776551</TD>
          </TR>
          <TR>
            <TD>13366.000</TD>
            <TD>0.0745535</TD>
          </TR>
          <TR>
            <TD>13368.000</TD>
            <TD>0.0721236</TD>
          </TR>
          <TR>
            <TD>13370.000</TD>
            <TD>0.0694598</TD>
          </TR>
          <TR>
            <TD>13372.000</TD>
            <TD>0.0667024</TD>
          </TR>
          <TR>
            <TD>13374.000</TD>
            <TD>0.0638772</TD>
          </TR>
          <TR>
            <TD>13376.000</TD>
            <TD>0.061786</TD>
          </TR>
          <TR>
            <TD>13378.000</TD>
            <TD>0.0589555</TD>
          </TR>
          <TR>
            <TD>13380.000</TD>
            <TD>0.0567251</TD>
          </TR>
          <TR>
            <TD>13382.000</TD>
            <TD>0.0550247</TD>
          </TR>
          <TR>
            <TD>13384.000</TD>
            <TD>0.0525558</TD>
          </TR>
          <TR>
            <TD>13386.000</TD>
            <TD>0.0511276</TD>
          </TR>
          <TR>
            <TD>13388.000</TD>
            <TD>0.0487555</TD>
          </TR>
          <TR>
            <TD>13390.000</TD>
            <TD>0.0467642</TD>
          </TR>
          <TR>
            <TD>13392.000</TD>
            <TD>0.0453621</TD>
          </TR>
          <TR>
            <TD>13394.000</TD>
            <TD>0.0433435</TD>
          </TR>
          <TR>
            <TD>13396.000</TD>
            <TD>0.0414462</TD>
          </TR>
          <TR>
            <TD>13398.000</TD>
            <TD>0.039441</TD>
          </TR>
          <TR>
            <TD>13400.000</TD>
            <TD>0.0385455</TD>
          </TR>
          <TR>
            <TD>13402.000</TD>
            <TD>0.038232</TD>
          </TR>
          <TR>
            <TD>13404.000</TD>
            <TD>0.0366236</TD>
          </TR>
          <TR>
            <TD>13406.000</TD>
            <TD>0.0348687</TD>
          </TR>
          <TR>
            <TD>13408.000</TD>
            <TD>0.0337927</TD>
          </TR>
          <TR>
            <TD>13410.000</TD>
            <TD>0.032713</TD>
          </TR>
          <TR>
            <TD>13412.000</TD>
            <TD>0.0315594</TD>
          </TR>
          <TR>
            <TD>13414.000</TD>
            <TD>0.0301674</TD>
          </TR>
          <TR>
            <TD>13416.000</TD>
            <TD>0.0297219</TD>
          </TR>
          <TR>
            <TD>13418.000</TD>
            <TD>0.0286872</TD>
          </TR>
          <TR>
            <TD>13420.000</TD>
            <TD>0.0265735</TD>
          </TR>
          <TR>
            <TD>13422.000</TD>
            <TD>0.0262969</TD>
          </TR>
          <TR>
            <TD>13424.000</TD>
            <TD>0.0258582</TD>
          </TR>
          <TR>
            <TD>13426.000</TD>
            <TD>0.0243707</TD>
          </TR>
          <TR>
            <TD>13428.000</TD>
            <TD>0.0238462</TD>
          </TR>
          <TR>
            <TD>13430.000</TD>
            <TD>0.0230541</TD>
          </TR>
          <TR>
            <TD>13432.000</TD>
            <TD>0.021784</TD>
          </TR>
          <TR>
            <TD>13434.000</TD>
            <TD>0.0220801</TD>
          </TR>
          <TR>
            <TD>13436.000</TD>
            <TD>0.021963</TD>
          </TR>
          <TR>
            <TD>13438.000</TD>
            <TD>0.0208509</TD>
          </TR>
          <TR>
            <TD>13440.000</TD>
            <TD>0.0202911</TD>
          </TR>
          <TR>
            <TD>13442.000</TD>
            <TD>0.0195915</TD>
          </TR>
          <TR>
            <TD>13444.000</TD>
            <TD>0.0191708</TD>
          </TR>
          <TR>
            <TD>13446.000</TD>
            <TD>0.0188963</TD>
          </TR>
          <TR>
            <TD>13448.000</TD>
            <TD>0.0175242</TD>
          </TR>
          <TR>
            <TD>13450.000</TD>
            <TD>0.0161708</TD>
          </TR>
          <TR>
            <TD>13452.000</TD>
            <TD>0.0162012</TD>
          </TR>
          <TR>
            <TD>13454.000</TD>
            <TD>0.0159299</TD>
          </TR>
          <TR>
            <TD>13456.000</TD>
            <TD>0.0160054</TD>
          </TR>
          <TR>
            <TD>13458.000</TD>
            <TD>0.0160553</TD>
          </TR>
          <TR>
            <TD>13460.000</TD>
            <TD>0.0149416</TD>
          </TR>
          <TR>
            <TD>13462.000</TD>
            <TD>0.01446</TD>
          </TR>
          <TR>
            <TD>13464.000</TD>
            <TD>0.0142226</TD>
          </TR>
          <TR>
            <TD>13466.000</TD>
            <TD>0.013821</TD>
          </TR>
          <TR>
            <TD>13468.000</TD>
            <TD>0.0133048</TD>
          </TR>
          <TR>
            <TD>13470.000</TD>
            <TD>0.0125941</TD>
          </TR>
          <TR>
            <TD>13472.000</TD>
            <TD>0.0128347</TD>
          </TR>
          <TR>
            <TD>13474.000</TD>
            <TD>0.0124207</TD>
          </TR>
          <TR>
            <TD>13476.000</TD>
            <TD>0.0119807</TD>
          </TR>
          <TR>
            <TD>13478.000</TD>
            <TD>0.0119633</TD>
          </TR>
          <TR>
            <TD>13480.000</TD>
            <TD>0.0115582</TD>
          </TR>
          <TR>
            <TD>13482.000</TD>
            <TD>0.0112797</TD>
          </TR>
          <TR>
            <TD>13484.000</TD>
            <TD>0.0114327</TD>
          </TR>
          <TR>
            <TD>13486.000</TD>
            <TD>0.0114513</TD>
          </TR>
          <TR>
            <TD>13488.000</TD>
            <TD>0.0104669</TD>
          </TR>
          <TR>
            <TD>13490.000</TD>
            <TD>0.0100334</TD>
          </TR>
          <TR>
            <TD>13492.000</TD>
            <TD>0.00976209</TD>
          </TR>
          <TR>
            <TD>13494.000</TD>
            <TD>0.00937155</TD>
          </TR>
          <TR>
            <TD>13496.000</TD>
            <TD>0.00927544</TD>
          </TR>
          <TR>
            <TD>13498.000</TD>
            <TD>0.00895855</TD>
          </TR>
          <TR>
            <TD>13500.000</TD>
            <TD>0.00883905</TD>
          </TR>
          <TR>
            <TD>13502.000</TD>
            <TD>0.00916034</TD>
          </TR>
          <TR>
            <TD>13504.000</TD>
            <TD>0.00877048</TD>
          </TR>
          <TR>
            <TD>13506.000</TD>
            <TD>0.00778387</TD>
          </TR>
          <TR>
            <TD>13508.000</TD>
            <TD>0.00776977</TD>
          </TR>
          <TR>
            <TD>13510.000</TD>
            <TD>0.00808018</TD>
          </TR>
          <TR>
            <TD>13512.000</TD>
            <TD>0.00810228</TD>
          </TR>
          <TR>
            <TD>13514.000</TD>
            <TD>0.00770249</TD>
          </TR>
          <TR>
            <TD>13516.000</TD>
            <TD>0.00697468</TD>
          </TR>
          <TR>
            <TD>13518.000</TD>
            <TD>0.00655249</TD>
          </TR>
          <TR>
            <TD>13520.000</TD>
            <TD>0.00671842</TD>
          </TR>
          <TR>
            <TD>13522.000</TD>
            <TD>0.00718401</TD>
          </TR>
          <TR>
            <TD>13524.000</TD>
            <TD>0.00690182</TD>
          </TR>
          <TR>
            <TD>13526.000</TD>
            <TD>0.00708885</TD>
          </TR>
          <TR>
            <TD>13528.000</TD>
            <TD>0.00727278</TD>
          </TR>
          <TR>
            <TD>13530.000</TD>
            <TD>0.00746919</TD>
          </TR>
          <TR>
            <TD>13532.000</TD>
            <TD>0.00706116</TD>
          </TR>
          <TR>
            <TD>13534.000</TD>
            <TD>0.00636732</TD>
          </TR>
          <TR>
            <TD>13536.000</TD>
            <TD>0.00611649</TD>
          </TR>
          <TR>
            <TD>13538.000</TD>
            <TD>0.00552994</TD>
          </TR>
          <TR>
            <TD>13540.000</TD>
            <TD>0.00538187</TD>
          </TR>
          <TR>
            <TD>13542.000</TD>
            <TD>0.00567791</TD>
          </TR>
          <TR>
            <TD>13544.000</TD>
            <TD>0.00599079</TD>
          </TR>
          <TR>
            <TD>13546.000</TD>
            <TD>0.00583118</TD>
          </TR>
          <TR>
            <TD>13548.000</TD>
            <TD>0.00563521</TD>
          </TR>
          <TR>
            <TD>13550.000</TD>
            <TD>0.00529692</TD>
          </TR>
          <TR>
            <TD>13552.000</TD>
            <TD>0.0051629</TD>
          </TR>
          <TR>
            <TD>13554.000</TD>
            <TD>0.00467838</TD>
          </TR>
          <TR>
            <TD>13556.000</TD>
            <TD>0.00467845</TD>
          </TR>
          <TR>
            <TD>13558.000</TD>
            <TD>0.00484634</TD>
          </TR>
          <TR>
            <TD>13560.000</TD>
            <TD>0.00498902</TD>
          </TR>
          <TR>
            <TD>13562.000</TD>
            <TD>0.00591239</TD>
          </TR>
          <TR>
            <TD>13564.000</TD>
            <TD>0.0063942</TD>
          </TR>
          <TR>
            <TD>13566.000</TD>
            <TD>0.0049856</TD>
          </TR>
          <TR>
            <TD>13568.000</TD>
            <TD>0.00343722</TD>
          </TR>
          <TR>
            <TD>13570.000</TD>
            <TD>0.00360843</TD>
          </TR>
          <TR>
            <TD>13572.000</TD>
            <TD>0.00392197</TD>
          </TR>
          <TR>
            <TD>13574.000</TD>
            <TD>0.0042643</TD>
          </TR>
          <TR>
            <TD>13576.000</TD>
            <TD>0.00442804</TD>
          </TR>
          <TR>
            <TD>13578.000</TD>
            <TD>0.00383314</TD>
          </TR>
          <TR>
            <TD>13580.000</TD>
            <TD>0.00432911</TD>
          </TR>
          <TR>
            <TD>13582.000</TD>
            <TD>0.00549469</TD>
          </TR>
          <TR>
            <TD>13584.000</TD>
            <TD>0.00536303</TD>
          </TR>
          <TR>
            <TD>13586.000</TD>
            <TD>0.00487644</TD>
          </TR>
          <TR>
            <TD>13588.000</TD>
            <TD>0.00393544</TD>
          </TR>
          <TR>
            <TD>13590.000</TD>
            <TD>0.00282358</TD>
          </TR>
          <TR>
            <TD>13592.000</TD>
            <TD>0.00311436</TD>
          </TR>
          <TR>
            <TD>13594.000</TD>
            <TD>0.00425767</TD>
          </TR>
          <TR>
            <TD>13596.000</TD>
            <TD>0.00499369</TD>
          </TR>
          <TR>
            <TD>13598.000</TD>
            <TD>0.00423607</TD>
          </TR>
          <TR>
            <TD>13600.000</TD>
            <TD>0.00314461</TD>
          </TR>
          <TR>
            <TD>13602.000</TD>
            <TD>0.00372697</TD>
          </TR>
          <TR>
            <TD>13604.000</TD>
            <TD>0.00428184</TD>
          </TR>
          <TR>
            <TD>13606.000</TD>
            <TD>0.00394331</TD>
          </TR>
          <TR>
            <TD>13608.000</TD>
            <TD>0.00322647</TD>
          </TR>
          <TR>
            <TD>13610.000</TD>
            <TD>0.00374324</TD>
          </TR>
          <TR>
            <TD>13612.000</TD>
            <TD>0.00317407</TD>
          </TR>
          <TR>
            <TD>13614.000</TD>
            <TD>0.00310532</TD>
          </TR>
          <TR>
            <TD>13616.000</TD>
            <TD>0.00393816</TD>
          </TR>
          <TR>
            <TD>13618.000</TD>
            <TD>0.00336201</TD>
          </TR>
          <TR>
            <TD>13620.000</TD>
            <TD>0.00346284</TD>
          </TR>
          <TR>
            <TD>13622.000</TD>
            <TD>0.00344196</TD>
          </TR>
          <TR>
            <TD>13624.000</TD>
            <TD>0.00347476</TD>
          </TR>
          <TR>
            <TD>13626.000</TD>
            <TD>0.00318025</TD>
          </TR>
          <TR>
            <TD>13628.000</TD>
            <TD>0.0032408</TD>
          </TR>
          <TR>
            <TD>13630.000</TD>
            <TD>0.00296413</TD>
          </TR>
          <TR>
            <TD>13632.000</TD>
            <TD>0.00212614</TD>
          </TR>
          <TR>
            <TD>13634.000</TD>
            <TD>0.00265466</TD>
          </TR>
          <TR>
            <TD>13636.000</TD>
            <TD>0.00301773</TD>
          </TR>
          <TR>
            <TD>13638.000</TD>
            <TD>0.00271947</TD>
          </TR>
          <TR>
            <TD>13640.000</TD>
            <TD>0.00321672</TD>
          </TR>
          <TR>
            <TD>13642.000</TD>
            <TD>0.00298648</TD>
          </TR>
          <TR>
            <TD>13644.000</TD>
            <TD>0.00313245</TD>
          </TR>
          <TR>
            <TD>13646.000</TD>
            <TD>0.00397605</TD>
          </TR>
          <TR>
            <TD>13648.000</TD>
            <TD>0.00325395</TD>
          </TR>
          <TR>
            <TD>13650.000</TD>
            <TD>0.00270339</TD>
          </TR>
          <TR>
            <TD>13652.000</TD>
            <TD>0.0030325</TD>
          </TR>
          <TR>
            <TD>13654.000</TD>
            <TD>0.00301844</TD>
          </TR>
          <TR>
            <TD>13656.000</TD>
            <TD>0.00370815</TD>
          </TR>
          <TR>
            <TD>13658.000</TD>
            <TD>0.00343941</TD>
          </TR>
          <TR>
            <TD>13660.000</TD>
            <TD>0.00328614</TD>
          </TR>
          <TR>
            <TD>13662.000</TD>
            <TD>0.00412229</TD>
          </TR>
          <TR>
            <TD>13664.000</TD>
            <TD>0.00351844</TD>
          </TR>
          <TR>
            <TD>13666.000</TD>
            <TD>0.00318915</TD>
          </TR>
          <TR>
            <TD>13668.000</TD>
            <TD>0.00213815</TD>
          </TR>
          <TR>
            <TD>13670.000</TD>
            <TD>0.00058381</TD>
          </TR>
          <TR>
            <TD>13672.000</TD>
            <TD>0.0020028</TD>
          </TR>
          <TR>
            <TD>13674.000</TD>
            <TD>0.00375757</TD>
          </TR>
          <TR>
            <TD>13676.000</TD>
            <TD>0.00338729</TD>
          </TR>
          <TR>
            <TD>13678.000</TD>
            <TD>0.00212046</TD>
          </TR>
          <TR>
            <TD>13680.000</TD>
            <TD>0.00177361</TD>
          </TR>
          <TR>
            <TD>13682.000</TD>
            <TD>0.00176352</TD>
          </TR>
          <TR>
            <TD>13684.000</TD>
            <TD>0.00121449</TD>
          </TR>
          <TR>
            <TD>13686.000</TD>
            <TD>0.00174214</TD>
          </TR>
          <TR>
            <TD>13688.000</TD>
            <TD>0.00193331</TD>
          </TR>
          <TR>
            <TD>13690.000</TD>
            <TD>0.00193497</TD>
          </TR>
          <TR>
            <TD>13692.000</TD>
            <TD>0.00194911</TD>
          </TR>
          <TR>
            <TD>13694.000</TD>
            <TD>0.0017753</TD>
          </TR>
          <TR>
            <TD>13696.000</TD>
            <TD>0.00212588</TD>
          </TR>
          <TR>
            <TD>13698.000</TD>
            <TD>0.0028169</TD>
          </TR>
          <TR>
            <TD>13700.000</TD>
            <TD>0.00266314</TD>
          </TR>
          <TR>
            <TD>13702.000</TD>
            <TD>0.00130629</TD>
          </TR>
          <TR>
            <TD>13704.000</TD>
            <TD>0.00059985</TD>
          </TR>
          <TR>
            <TD>13706.000</TD>
            <TD>0.00139898</TD>
          </TR>
          <TR>
            <TD>13708.000</TD>
            <TD>0.00254731</TD>
          </TR>
          <TR>
            <TD>13710.000</TD>
            <TD>0.00287169</TD>
          </TR>
          <TR>
            <TD>13712.000</TD>
            <TD>0.00187528</TD>
          </TR>
          <TR>
            <TD>13714.000</TD>
            <TD>0.00104658</TD>
          </TR>
          <TR>
            <TD>13716.000</TD>
            <TD>0.00183044</TD>
          </TR>
          <TR>
            <TD>13718.000</TD>
            <TD>0.00215261</TD>
          </TR>
          <TR>
            <TD>13720.000</TD>
            <TD>0.0020158</TD>
          </TR>
          <TR>
            <TD>13722.000</TD>
            <TD>0.00186153</TD>
          </TR>
          <TR>
            <TD>13724.000</TD>
            <TD>0.00198397</TD>
          </TR>
          <TR>
            <TD>13726.000</TD>
            <TD>0.00198487</TD>
          </TR>
          <TR>
            <TD>13728.000</TD>
            <TD>0.00152261</TD>
          </TR>
          <TR>
            <TD>13730.000</TD>
            <TD>0.00212336</TD>
          </TR>
          <TR>
            <TD>13732.000</TD>
            <TD>0.00133921</TD>
          </TR>
          <TR>
            <TD>13734.000</TD>
            <TD>0.00073838</TD>
          </TR>
          <TR>
            <TD>13736.000</TD>
            <TD>0.00169077</TD>
          </TR>
          <TR>
            <TD>13738.000</TD>
            <TD>0.00073752</TD>
          </TR>
          <TR>
            <TD>13740.000</TD>
            <TD>0.00010757</TD>
          </TR>
          <TR>
            <TD>13742.000</TD>
            <TD>0.00104493</TD>
          </TR>
          <TR>
            <TD>13744.000</TD>
            <TD>0.00227068</TD>
          </TR>
          <TR>
            <TD>13746.000</TD>
            <TD>0.00210188</TD>
          </TR>
          <TR>
            <TD>13748.000</TD>
            <TD>0.00130724</TD>
          </TR>
          <TR>
            <TD>13750.000</TD>
            <TD>0.00133813</TD>
          </TR>
          <TR>
            <TD>13752.000</TD>
            <TD>0.00150678</TD>
          </TR>
          <TR>
            <TD>13754.000</TD>
            <TD>0.00118324</TD>
          </TR>
          <TR>
            <TD>13756.000</TD>
            <TD>0.00154801</TD>
          </TR>
          <TR>
            <TD>13758.000</TD>
            <TD>0.00197716</TD>
          </TR>
          <TR>
            <TD>13760.000</TD>
            <TD>0.00164256</TD>
          </TR>
          <TR>
            <TD>13762.000</TD>
            <TD>0.0016586</TD>
          </TR>
          <TR>
            <TD>13764.000</TD>
            <TD>0.00104526</TD>
          </TR>
          <TR>
            <TD>13766.000</TD>
            <TD>0.00103188</TD>
          </TR>
          <TR>
            <TD>13768.000</TD>
            <TD>0.00151194</TD>
          </TR>
          <TR>
            <TD>13770.000</TD>
            <TD>0.00118721</TD>
          </TR>
          <TR>
            <TD>13772.000</TD>
            <TD>0.0007092</TD>
          </TR>
          <TR>
            <TD>13774.000</TD>
            <TD>0.00120116</TD>
          </TR>
          <TR>
            <TD>13776.000</TD>
            <TD>0.00167574</TD>
          </TR>
          <TR>
            <TD>13778.000</TD>
            <TD>0.00120114</TD>
          </TR>
          <TR>
            <TD>13780.000</TD>
            <TD>0.00046305</TD>
          </TR>
          <TR>
            <TD>13782.000</TD>
            <TD>0.00044903</TD>
          </TR>
          <TR>
            <TD>13784.000</TD>
            <TD>0.00118139</TD>
          </TR>
          <TR>
            <TD>13786.000</TD>
            <TD>0.00071747</TD>
          </TR>
          <TR>
            <TD>13788.000</TD>
            <TD>0.00088846</TD>
          </TR>
          <TR>
            <TD>13790.000</TD>
            <TD>0.00124291</TD>
          </TR>
          <TR>
            <TD>13792.000</TD>
            <TD>0.00128915</TD>
          </TR>
          <TR>
            <TD>13794.000</TD>
            <TD>0.00146955</TD>
          </TR>
          <TR>
            <TD>13796.000</TD>
            <TD>0.00199485</TD>
          </TR>
          <TR>
            <TD>13798.000</TD>
            <TD>0.00232111</TD>
          </TR>
          <TR>
            <TD>13800.000</TD>
            <TD>0.00128268</TD>
          </TR>
          <TR>
            <TD>13802.000</TD>
            <TD>0.00064207</TD>
          </TR>
          <TR>
            <TD>13804.000</TD>
            <TD>0.00098041</TD>
          </TR>
          <TR>
            <TD>13806.000</TD>
            <TD>0.00109294</TD>
          </TR>
          <TR>
            <TD>13808.000</TD>
            <TD>0.00060245</TD>
          </TR>
          <TR>
            <TD>13810.000</TD>
            <TD>0.00080278</TD>
          </TR>
          <TR>
            <TD>13812.000</TD>
            <TD>0.00029314</TD>
          </TR>
        </TABLEDATA>
      </DATA>
    </TABLE>
  </RESOURCE>
</VOTABLE>
