# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = [
    'GetProjectUserResult',
    'AwaitableGetProjectUserResult',
    'get_project_user',
]

@pulumi.output_type
class GetProjectUserResult:
    """
    A collection of values returned by getProjectUser.
    """
    def __init__(__self__, accepted=None, email=None, id=None, member_type=None, project=None):
        if accepted and not isinstance(accepted, bool):
            raise TypeError("Expected argument 'accepted' to be a bool")
        pulumi.set(__self__, "accepted", accepted)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if member_type and not isinstance(member_type, str):
            raise TypeError("Expected argument 'member_type' to be a str")
        pulumi.set(__self__, "member_type", member_type)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def accepted(self) -> bool:
        """
        is a computed property tells whether the user has accepted the request to join
        the project; adding user to a project sends an invitation to the target user and the
        actual membership is only created once the user accepts the invitation. This property
        cannot be set, only read.
        """
        return pulumi.get(self, "accepted")

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> Optional[str]:
        """
        (Required) defines the access level the user has to the project.
        """
        return pulumi.get(self, "member_type")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")


class AwaitableGetProjectUserResult(GetProjectUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectUserResult(
            accepted=self.accepted,
            email=self.email,
            id=self.id,
            member_type=self.member_type,
            project=self.project)


def get_project_user(accepted: Optional[bool] = None,
                     email: Optional[str] = None,
                     member_type: Optional[str] = None,
                     project: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectUserResult:
    """
    ## # Project User Data Source

    The Project User data source provides information about the existing Aiven Project User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    mytestuser = aiven.get_project_user(email="john.doe@example.com",
        project=aiven_project["myproject"]["project"])
    ```


    :param bool accepted: is a computed property tells whether the user has accepted the request to join
           the project; adding user to a project sends an invitation to the target user and the
           actual membership is only created once the user accepts the invitation. This property
           cannot be set, only read.
    :param str email: identifies the email address of the user.
    :param str member_type: (Required) defines the access level the user has to the project.
    :param str project: defines the project the user is a member of.
    """
    __args__ = dict()
    __args__['accepted'] = accepted
    __args__['email'] = email
    __args__['memberType'] = member_type
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getProjectUser:getProjectUser', __args__, opts=opts, typ=GetProjectUserResult).value

    return AwaitableGetProjectUserResult(
        accepted=__ret__.accepted,
        email=__ret__.email,
        id=__ret__.id,
        member_type=__ret__.member_type,
        project=__ret__.project)
