# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['ProjectUser']


class ProjectUser(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 member_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Project User Resource

        The Project User resource allows the creation and management of an Aiven Project Users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        mytestuser = aiven.ProjectUser("mytestuser",
            email="john.doe@example.com",
            member_type="admin",
            project=aiven_project["myproject"]["project"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: identifies the email address of the user.
        :param pulumi.Input[str] member_type: defines the access level the user has to the project.
        :param pulumi.Input[str] project: defines the project the user is a member of.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if email is None:
                raise TypeError("Missing required property 'email'")
            __props__['email'] = email
            if member_type is None:
                raise TypeError("Missing required property 'member_type'")
            __props__['member_type'] = member_type
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['accepted'] = None
        super(ProjectUser, __self__).__init__(
            'aiven:index/projectUser:ProjectUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accepted: Optional[pulumi.Input[bool]] = None,
            email: Optional[pulumi.Input[str]] = None,
            member_type: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'ProjectUser':
        """
        Get an existing ProjectUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accepted: is a computed property tells whether the user has accepted the request to join
               the project; adding user to a project sends an invitation to the target user and the
               actual membership is only created once the user accepts the invitation. This property
               cannot be set, only read.
        :param pulumi.Input[str] email: identifies the email address of the user.
        :param pulumi.Input[str] member_type: defines the access level the user has to the project.
        :param pulumi.Input[str] project: defines the project the user is a member of.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accepted"] = accepted
        __props__["email"] = email
        __props__["member_type"] = member_type
        __props__["project"] = project
        return ProjectUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accepted(self) -> pulumi.Output[bool]:
        """
        is a computed property tells whether the user has accepted the request to join
        the project; adding user to a project sends an invitation to the target user and the
        actual membership is only created once the user accepts the invitation. This property
        cannot be set, only read.
        """
        return pulumi.get(self, "accepted")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        identifies the email address of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> pulumi.Output[str]:
        """
        defines the access level the user has to the project.
        """
        return pulumi.get(self, "member_type")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        defines the project the user is a member of.
        """
        return pulumi.get(self, "project")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

