# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['AuthLoginApp']


class AuthLoginApp(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 credentials_scheme: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 preconfigured_app: Optional[pulumi.Input[str]] = None,
                 reveal_password: Optional[pulumi.Input[bool]] = None,
                 shared_password: Optional[pulumi.Input[str]] = None,
                 shared_username: Optional[pulumi.Input[str]] = None,
                 sign_on_redirect_url: Optional[pulumi.Input[str]] = None,
                 sign_on_url: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthLoginAppUserArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a AuthLoginApp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] credentials_scheme: Application credentials scheme
        :param pulumi.Input[List[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] preconfigured_app: Preconfigured app name
        :param pulumi.Input[bool] reveal_password: Allow user to reveal password
        :param pulumi.Input[str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[str] sign_on_redirect_url: Post login redirect URL
        :param pulumi.Input[str] sign_on_url: Login URL
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthLoginAppUserArgs']]]] users: Users associated with the application
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['accessibility_error_redirect_url'] = accessibility_error_redirect_url
            __props__['accessibility_self_service'] = accessibility_self_service
            __props__['auto_submit_toolbar'] = auto_submit_toolbar
            __props__['credentials_scheme'] = credentials_scheme
            __props__['groups'] = groups
            __props__['hide_ios'] = hide_ios
            __props__['hide_web'] = hide_web
            if label is None:
                raise TypeError("Missing required property 'label'")
            __props__['label'] = label
            __props__['preconfigured_app'] = preconfigured_app
            __props__['reveal_password'] = reveal_password
            __props__['shared_password'] = shared_password
            __props__['shared_username'] = shared_username
            __props__['sign_on_redirect_url'] = sign_on_redirect_url
            __props__['sign_on_url'] = sign_on_url
            __props__['status'] = status
            __props__['users'] = users
            __props__['name'] = None
            __props__['sign_on_mode'] = None
            __props__['user_name_template'] = None
            __props__['user_name_template_type'] = None
        super(AuthLoginApp, __self__).__init__(
            'okta:deprecated/authLoginApp:AuthLoginApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
            accessibility_self_service: Optional[pulumi.Input[bool]] = None,
            auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
            credentials_scheme: Optional[pulumi.Input[str]] = None,
            groups: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            hide_ios: Optional[pulumi.Input[bool]] = None,
            hide_web: Optional[pulumi.Input[bool]] = None,
            label: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            preconfigured_app: Optional[pulumi.Input[str]] = None,
            reveal_password: Optional[pulumi.Input[bool]] = None,
            shared_password: Optional[pulumi.Input[str]] = None,
            shared_username: Optional[pulumi.Input[str]] = None,
            sign_on_mode: Optional[pulumi.Input[str]] = None,
            sign_on_redirect_url: Optional[pulumi.Input[str]] = None,
            sign_on_url: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            user_name_template: Optional[pulumi.Input[str]] = None,
            user_name_template_type: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthLoginAppUserArgs']]]]] = None) -> 'AuthLoginApp':
        """
        Get an existing AuthLoginApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] credentials_scheme: Application credentials scheme
        :param pulumi.Input[List[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] name: name of app.
        :param pulumi.Input[str] preconfigured_app: Preconfigured app name
        :param pulumi.Input[bool] reveal_password: Allow user to reveal password
        :param pulumi.Input[str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[str] sign_on_redirect_url: Post login redirect URL
        :param pulumi.Input[str] sign_on_url: Login URL
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[str] user_name_template: Username template
        :param pulumi.Input[str] user_name_template_type: Username template type
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthLoginAppUserArgs']]]] users: Users associated with the application
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
        __props__["accessibility_self_service"] = accessibility_self_service
        __props__["auto_submit_toolbar"] = auto_submit_toolbar
        __props__["credentials_scheme"] = credentials_scheme
        __props__["groups"] = groups
        __props__["hide_ios"] = hide_ios
        __props__["hide_web"] = hide_web
        __props__["label"] = label
        __props__["name"] = name
        __props__["preconfigured_app"] = preconfigured_app
        __props__["reveal_password"] = reveal_password
        __props__["shared_password"] = shared_password
        __props__["shared_username"] = shared_username
        __props__["sign_on_mode"] = sign_on_mode
        __props__["sign_on_redirect_url"] = sign_on_redirect_url
        __props__["sign_on_url"] = sign_on_url
        __props__["status"] = status
        __props__["user_name_template"] = user_name_template
        __props__["user_name_template_type"] = user_name_template_type
        __props__["users"] = users
        return AuthLoginApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable self service
        """
        return pulumi.get(self, "accessibility_self_service")

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> pulumi.Output[Optional[bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> pulumi.Output[Optional[str]]:
        """
        Application credentials scheme
        """
        return pulumi.get(self, "credentials_scheme")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[List[str]]]:
        """
        Groups associated with the application
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        Pretty name of app.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        name of app.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preconfiguredApp")
    def preconfigured_app(self) -> pulumi.Output[Optional[str]]:
        """
        Preconfigured app name
        """
        return pulumi.get(self, "preconfigured_app")

    @property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> pulumi.Output[Optional[bool]]:
        """
        Allow user to reveal password
        """
        return pulumi.get(self, "reveal_password")

    @property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> pulumi.Output[Optional[str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> pulumi.Output[Optional[str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> pulumi.Output[str]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @property
    @pulumi.getter(name="signOnRedirectUrl")
    def sign_on_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Post login redirect URL
        """
        return pulumi.get(self, "sign_on_redirect_url")

    @property
    @pulumi.getter(name="signOnUrl")
    def sign_on_url(self) -> pulumi.Output[Optional[str]]:
        """
        Login URL
        """
        return pulumi.get(self, "sign_on_url")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Status of application.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> pulumi.Output[str]:
        """
        Username template
        """
        return pulumi.get(self, "user_name_template")

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> pulumi.Output[str]:
        """
        Username template type
        """
        return pulumi.get(self, "user_name_template_type")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[List['outputs.AuthLoginAppUser']]]:
        """
        Users associated with the application
        """
        return pulumi.get(self, "users")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

