# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['EventHook']


class EventHook(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth: Optional[pulumi.Input[pulumi.InputType['EventHookAuthArgs']]] = None,
                 channel: Optional[pulumi.Input[pulumi.InputType['EventHookChannelArgs']]] = None,
                 events: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 headers: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['EventHookHeaderArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an event hook.

        This resource allows you to create and configure an event hook.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.EventHook("example",
            auth=okta.EventHookAuthArgs(
                key="Authorization",
                type="HEADER",
                value="123",
            ),
            channel=okta.EventHookChannelArgs(
                type="HTTP",
                uri="https://example.com/test",
                version="1.0.0",
            ),
            events=[
                "user.lifecycle.create",
                "user.lifecycle.delete.initiated",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EventHookAuthArgs']] auth: Authentication required for event hook request.
        :param pulumi.Input[pulumi.InputType['EventHookChannelArgs']] channel: Details of the endpoint the event hook will hit.
        :param pulumi.Input[List[pulumi.Input[str]]] events: The events that will be delivered to this hook. [See here for a list of supported events](https://developer.okta.com/docs/reference/api/event-types/?q=event-hook-eligible).
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['EventHookHeaderArgs']]]] headers: Map of headers to send along in event hook request.
        :param pulumi.Input[str] name: The event hook display name.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['auth'] = auth
            if channel is None:
                raise TypeError("Missing required property 'channel'")
            __props__['channel'] = channel
            if events is None:
                raise TypeError("Missing required property 'events'")
            __props__['events'] = events
            __props__['headers'] = headers
            __props__['name'] = name
            __props__['status'] = status
        super(EventHook, __self__).__init__(
            'okta:index/eventHook:EventHook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth: Optional[pulumi.Input[pulumi.InputType['EventHookAuthArgs']]] = None,
            channel: Optional[pulumi.Input[pulumi.InputType['EventHookChannelArgs']]] = None,
            events: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            headers: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['EventHookHeaderArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'EventHook':
        """
        Get an existing EventHook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EventHookAuthArgs']] auth: Authentication required for event hook request.
        :param pulumi.Input[pulumi.InputType['EventHookChannelArgs']] channel: Details of the endpoint the event hook will hit.
        :param pulumi.Input[List[pulumi.Input[str]]] events: The events that will be delivered to this hook. [See here for a list of supported events](https://developer.okta.com/docs/reference/api/event-types/?q=event-hook-eligible).
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['EventHookHeaderArgs']]]] headers: Map of headers to send along in event hook request.
        :param pulumi.Input[str] name: The event hook display name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["auth"] = auth
        __props__["channel"] = channel
        __props__["events"] = events
        __props__["headers"] = headers
        __props__["name"] = name
        __props__["status"] = status
        return EventHook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def auth(self) -> pulumi.Output[Optional['outputs.EventHookAuth']]:
        """
        Authentication required for event hook request.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Output['outputs.EventHookChannel']:
        """
        Details of the endpoint the event hook will hit.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def events(self) -> pulumi.Output[List[str]]:
        """
        The events that will be delivered to this hook. [See here for a list of supported events](https://developer.okta.com/docs/reference/api/event-types/?q=event-hook-eligible).
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[List['outputs.EventHookHeader']]]:
        """
        Map of headers to send along in event hook request.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The event hook display name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "status")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

