# This code is part of Qiskit.
#
# (C) Copyright IBM 2021.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.

"""Excitation generator utilities.

.. currentmodule:: qiskit_nature.circuit.library.ansatzes.utils

.. autosummary::
   :toctree: ../stubs/
   :nosignatures:

   generate_fermionic_excitations
   generate_vibration_excitations
"""

from .fermionic_excitation_generator import generate_fermionic_excitations
from .vibration_excitation_generator import generate_vibration_excitations

__all__ = [
    'generate_fermionic_excitations',
    'generate_vibration_excitations',
]
