# This code is part of Qiskit.
#
# (C) Copyright IBM 2021.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.

"""The reference PauliSumOp for the DirectMapper."""

from qiskit.opflow import X, Y, Z, I

REFERENCE = \
    5077.236560625012 * (I ^ I ^ I ^ I ^ I ^ I ^ I ^ I) \
    - 472.28961593750034 * (Z ^ I ^ I ^ I ^ I ^ I ^ I ^ I) \
    - 157.22939093749991 * (I ^ Z ^ I ^ I ^ I ^ I ^ I ^ I) \
    - 467.5058515625001 * (I ^ I ^ Z ^ I ^ I ^ I ^ I ^ I) \
    - 1.2397992187500007 * (Z ^ I ^ Z ^ I ^ I ^ I ^ I ^ I) \
    - 0.4132664062500002 * (I ^ Z ^ Z ^ I ^ I ^ I ^ I ^ I) \
    - 155.20426031249983 * (I ^ I ^ I ^ Z ^ I ^ I ^ I ^ I) \
    - 0.4132664062500002 * (Z ^ I ^ I ^ Z ^ I ^ I ^ I ^ I) \
    - 0.13775546875000005 * (I ^ Z ^ I ^ Z ^ I ^ I ^ I ^ I) \
    - 1027.4430731249997 * (I ^ I ^ I ^ I ^ Z ^ I ^ I ^ I) \
    - 3.7889535937500023 * (Z ^ I ^ I ^ I ^ Z ^ I ^ I ^ I) \
    - 1.2629845312500008 * (I ^ Z ^ I ^ I ^ Z ^ I ^ I ^ I) \
    - 5.772877031250004 * (I ^ I ^ Z ^ I ^ Z ^ I ^ I ^ I) \
    - 1.9242923437500008 * (I ^ I ^ I ^ Z ^ Z ^ I ^ I ^ I) \
    - 342.04261812500033 * (I ^ I ^ I ^ I ^ I ^ Z ^ I ^ I) \
    - 1.2629845312500005 * (Z ^ I ^ I ^ I ^ I ^ Z ^ I ^ I) \
    - 0.42099484375000024 * (I ^ Z ^ I ^ I ^ I ^ Z ^ I ^ I) \
    - 1.924292343750001 * (I ^ I ^ Z ^ I ^ I ^ Z ^ I ^ I) \
    - 0.6414307812500002 * (I ^ I ^ I ^ Z ^ I ^ Z ^ I ^ I) \
    - 1810.6538965625004 * (I ^ I ^ I ^ I ^ I ^ I ^ Z ^ I) \
    - 10.340644218750004 * (Z ^ I ^ I ^ I ^ I ^ I ^ Z ^ I) \
    - 3.4468814062500015 * (I ^ Z ^ I ^ I ^ I ^ I ^ Z ^ I) \
    - 14.366345625000008 * (I ^ I ^ Z ^ I ^ I ^ I ^ Z ^ I) \
    - 4.788781875000002 * (I ^ I ^ I ^ Z ^ I ^ I ^ Z ^ I) \
    + 11.339220937500007 * (I ^ I ^ I ^ I ^ Z ^ I ^ Z ^ I) \
    + 3.779740312500002 * (I ^ I ^ I ^ I ^ I ^ Z ^ Z ^ I) \
    - 601.9000340624999 * (I ^ I ^ I ^ I ^ I ^ I ^ I ^ Z) \
    - 3.4468814062500015 * (Z ^ I ^ I ^ I ^ I ^ I ^ I ^ Z) \
    - 1.1489604687500004 * (I ^ Z ^ I ^ I ^ I ^ I ^ I ^ Z) \
    - 4.788781875000002 * (I ^ I ^ Z ^ I ^ I ^ I ^ I ^ Z) \
    - 1.5962606250000009 * (I ^ I ^ I ^ Z ^ I ^ I ^ I ^ Z) \
    + 3.779740312500002 * (I ^ I ^ I ^ I ^ Z ^ I ^ I ^ Z) \
    + 1.2599134375000005 * (I ^ I ^ I ^ I ^ I ^ Z ^ I ^ Z) \
    - 2.358922187500002 * (X ^ X ^ X ^ X ^ I ^ I ^ I ^ I) \
    - 2.358922187500002 * (Y ^ Y ^ X ^ X ^ I ^ I ^ I ^ I) \
    - 2.358922187500002 * (X ^ X ^ Y ^ Y ^ I ^ I ^ I ^ I) \
    - 2.358922187500002 * (Y ^ Y ^ Y ^ Y ^ I ^ I ^ I ^ I) \
    + 1.0759307812500005 * (X ^ X ^ X ^ X ^ Z ^ I ^ I ^ I) \
    + 1.0759307812500005 * (Y ^ Y ^ X ^ X ^ Z ^ I ^ I ^ I) \
    + 1.0759307812500005 * (X ^ X ^ Y ^ Y ^ Z ^ I ^ I ^ I) \
    + 1.0759307812500005 * (Y ^ Y ^ Y ^ Y ^ Z ^ I ^ I ^ I) \
    + 0.35864359375000016 * (X ^ X ^ X ^ X ^ I ^ Z ^ I ^ I) \
    + 0.35864359375000016 * (Y ^ Y ^ X ^ X ^ I ^ Z ^ I ^ I) \
    + 0.35864359375000016 * (X ^ X ^ Y ^ Y ^ I ^ Z ^ I ^ I) \
    + 0.35864359375000016 * (Y ^ Y ^ Y ^ Y ^ I ^ Z ^ I ^ I) \
    + 2.183239218750001 * (X ^ X ^ X ^ X ^ I ^ I ^ Z ^ I) \
    + 2.183239218750001 * (Y ^ Y ^ X ^ X ^ I ^ I ^ Z ^ I) \
    + 2.183239218750001 * (X ^ X ^ Y ^ Y ^ I ^ I ^ Z ^ I) \
    + 2.183239218750001 * (Y ^ Y ^ Y ^ Y ^ I ^ I ^ Z ^ I) \
    + 0.7277464062500004 * (X ^ X ^ X ^ X ^ I ^ I ^ I ^ Z) \
    + 0.7277464062500004 * (Y ^ Y ^ X ^ X ^ I ^ I ^ I ^ Z) \
    + 0.7277464062500004 * (X ^ X ^ Y ^ Y ^ I ^ I ^ I ^ Z) \
    + 0.7277464062500004 * (Y ^ Y ^ Y ^ Y ^ I ^ I ^ I ^ Z) \
    - 84.41897986727398 * (I ^ I ^ I ^ I ^ X ^ X ^ I ^ I) \
    - 4.809566200586032 * (Z ^ I ^ I ^ I ^ X ^ X ^ I ^ I) \
    - 1.6031887335286772 * (I ^ Z ^ I ^ I ^ X ^ X ^ I ^ I) \
    - 16.233724778792137 * (I ^ I ^ Z ^ I ^ X ^ X ^ I ^ I) \
    - 5.411241592930711 * (I ^ I ^ I ^ Z ^ X ^ X ^ I ^ I) \
    - 84.41897986727398 * (I ^ I ^ I ^ I ^ Y ^ Y ^ I ^ I) \
    - 4.809566200586032 * (Z ^ I ^ I ^ I ^ Y ^ Y ^ I ^ I) \
    - 1.6031887335286772 * (I ^ Z ^ I ^ I ^ Y ^ Y ^ I ^ I) \
    - 16.233724778792137 * (I ^ I ^ Z ^ I ^ Y ^ Y ^ I ^ I) \
    - 5.411241592930711 * (I ^ I ^ I ^ Z ^ Y ^ Y ^ I ^ I) \
    + 66.81814897987134 * (I ^ I ^ I ^ I ^ X ^ X ^ Z ^ I) \
    + 66.81814897987134 * (I ^ I ^ I ^ I ^ Y ^ Y ^ Z ^ I) \
    + 22.272716326623776 * (I ^ I ^ I ^ I ^ X ^ X ^ I ^ Z) \
    + 22.272716326623776 * (I ^ I ^ I ^ I ^ Y ^ Y ^ I ^ Z) \
    + 2.144411357441029 * (X ^ X ^ X ^ X ^ X ^ X ^ I ^ I) \
    + 2.144411357441029 * (Y ^ Y ^ X ^ X ^ X ^ X ^ I ^ I) \
    + 2.144411357441029 * (X ^ X ^ Y ^ Y ^ X ^ X ^ I ^ I) \
    + 2.144411357441029 * (Y ^ Y ^ Y ^ Y ^ X ^ X ^ I ^ I) \
    + 2.144411357441029 * (X ^ X ^ X ^ X ^ Y ^ Y ^ I ^ I) \
    + 2.144411357441029 * (Y ^ Y ^ X ^ X ^ Y ^ Y ^ I ^ I) \
    + 2.144411357441029 * (X ^ X ^ Y ^ Y ^ Y ^ Y ^ I ^ I) \
    + 2.144411357441029 * (Y ^ Y ^ Y ^ Y ^ Y ^ Y ^ I ^ I) \
    - 0.5313231250000003 * (X ^ X ^ I ^ I ^ I ^ I ^ X ^ X) \
    - 0.5313231250000003 * (Y ^ Y ^ I ^ I ^ I ^ I ^ X ^ X) \
    + 3.577026093750003 * (X ^ X ^ Z ^ I ^ I ^ I ^ X ^ X) \
    + 3.577026093750003 * (Y ^ Y ^ Z ^ I ^ I ^ I ^ X ^ X) \
    + 1.1923420312500006 * (X ^ X ^ I ^ Z ^ I ^ I ^ X ^ X) \
    + 1.1923420312500006 * (Y ^ Y ^ I ^ Z ^ I ^ I ^ X ^ X) \
    - 2.505002343750002 * (X ^ X ^ I ^ I ^ Z ^ I ^ X ^ X) \
    - 2.505002343750002 * (Y ^ Y ^ I ^ I ^ Z ^ I ^ X ^ X) \
    - 0.8350007812500007 * (X ^ X ^ I ^ I ^ I ^ Z ^ X ^ X) \
    - 0.8350007812500007 * (Y ^ Y ^ I ^ I ^ I ^ Z ^ X ^ X) \
    - 0.5313231250000003 * (X ^ X ^ I ^ I ^ I ^ I ^ Y ^ Y) \
    - 0.5313231250000003 * (Y ^ Y ^ I ^ I ^ I ^ I ^ Y ^ Y) \
    + 3.577026093750003 * (X ^ X ^ Z ^ I ^ I ^ I ^ Y ^ Y) \
    + 3.577026093750003 * (Y ^ Y ^ Z ^ I ^ I ^ I ^ Y ^ Y) \
    + 1.1923420312500006 * (X ^ X ^ I ^ Z ^ I ^ I ^ Y ^ Y) \
    + 1.1923420312500006 * (Y ^ Y ^ I ^ Z ^ I ^ I ^ Y ^ Y) \
    - 2.505002343750002 * (X ^ X ^ I ^ I ^ Z ^ I ^ Y ^ Y) \
    - 2.505002343750002 * (Y ^ Y ^ I ^ I ^ Z ^ I ^ Y ^ Y) \
    - 0.8350007812500007 * (X ^ X ^ I ^ I ^ I ^ Z ^ Y ^ Y) \
    - 0.8350007812500007 * (Y ^ Y ^ I ^ I ^ I ^ Z ^ Y ^ Y) \
    + 0.29708968750000064 * (I ^ I ^ X ^ X ^ I ^ I ^ X ^ X) \
    - 2.0000971875000015 * (Z ^ I ^ X ^ X ^ I ^ I ^ X ^ X) \
    - 0.6666990625000003 * (I ^ Z ^ X ^ X ^ I ^ I ^ X ^ X) \
    + 0.29708968750000064 * (I ^ I ^ Y ^ Y ^ I ^ I ^ X ^ X) \
    - 2.0000971875000015 * (Z ^ I ^ Y ^ Y ^ I ^ I ^ X ^ X) \
    - 0.6666990625000003 * (I ^ Z ^ Y ^ Y ^ I ^ I ^ X ^ X) \
    + 1.4006742187500012 * (I ^ I ^ X ^ X ^ Z ^ I ^ X ^ X) \
    + 1.4006742187500012 * (I ^ I ^ Y ^ Y ^ Z ^ I ^ X ^ X) \
    + 0.4668914062500003 * (I ^ I ^ X ^ X ^ I ^ Z ^ X ^ X) \
    + 0.4668914062500003 * (I ^ I ^ Y ^ Y ^ I ^ Z ^ X ^ X) \
    + 0.29708968750000064 * (I ^ I ^ X ^ X ^ I ^ I ^ Y ^ Y) \
    - 2.0000971875000015 * (Z ^ I ^ X ^ X ^ I ^ I ^ Y ^ Y) \
    - 0.6666990625000003 * (I ^ Z ^ X ^ X ^ I ^ I ^ Y ^ Y) \
    + 0.29708968750000064 * (I ^ I ^ Y ^ Y ^ I ^ I ^ Y ^ Y) \
    - 2.0000971875000015 * (Z ^ I ^ Y ^ Y ^ I ^ I ^ Y ^ Y) \
    - 0.6666990625000003 * (I ^ Z ^ Y ^ Y ^ I ^ I ^ Y ^ Y) \
    + 1.4006742187500012 * (I ^ I ^ X ^ X ^ Z ^ I ^ Y ^ Y) \
    + 1.4006742187500012 * (I ^ I ^ Y ^ Y ^ Z ^ I ^ Y ^ Y) \
    + 0.4668914062500003 * (I ^ I ^ X ^ X ^ I ^ Z ^ Y ^ Y) \
    + 0.4668914062500003 * (I ^ I ^ Y ^ Y ^ I ^ Z ^ Y ^ Y) \
    - 9.839626415157296 * (X ^ X ^ I ^ I ^ X ^ X ^ X ^ X) \
    - 9.839626415157296 * (Y ^ Y ^ I ^ I ^ X ^ X ^ X ^ X) \
    - 9.839626415157296 * (X ^ X ^ I ^ I ^ Y ^ Y ^ X ^ X) \
    - 9.839626415157296 * (Y ^ Y ^ I ^ I ^ Y ^ Y ^ X ^ X) \
    - 9.839626415157296 * (X ^ X ^ I ^ I ^ X ^ X ^ Y ^ Y) \
    - 9.839626415157296 * (Y ^ Y ^ I ^ I ^ X ^ X ^ Y ^ Y) \
    - 9.839626415157296 * (X ^ X ^ I ^ I ^ Y ^ Y ^ Y ^ Y) \
    - 9.839626415157296 * (Y ^ Y ^ I ^ I ^ Y ^ Y ^ Y ^ Y) \
    + 5.501835671794594 * (I ^ I ^ X ^ X ^ X ^ X ^ X ^ X) \
    + 5.501835671794594 * (I ^ I ^ Y ^ Y ^ X ^ X ^ X ^ X) \
    + 5.501835671794594 * (I ^ I ^ X ^ X ^ Y ^ Y ^ X ^ X) \
    + 5.501835671794594 * (I ^ I ^ Y ^ Y ^ Y ^ Y ^ X ^ X) \
    + 5.501835671794594 * (I ^ I ^ X ^ X ^ X ^ X ^ Y ^ Y) \
    + 5.501835671794594 * (I ^ I ^ Y ^ Y ^ X ^ X ^ Y ^ Y) \
    + 5.501835671794594 * (I ^ I ^ X ^ X ^ Y ^ Y ^ Y ^ Y) \
    + 5.501835671794594 * (I ^ I ^ Y ^ Y ^ Y ^ Y ^ Y ^ Y)
