# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nonebot_plugin_picstatus']

package_data = \
{'': ['*'], 'nonebot_plugin_picstatus': ['res/*']}

install_requires = \
['Pillow>=9.2.0,<10.0.0',
 'aiofiles>=22.1.0,<23.0.0',
 'aiohttp>=3.8.3,<4.0.0',
 'nonebot-adapter-onebot>=2.1.3,<3.0.0',
 'nonebot2>=2.0.0-beta.5,<3.0.0',
 'psutil>=5.9.2,<6.0.0']

setup_kwargs = {
    'name': 'nonebot-plugin-picstatus',
    'version': '0.1.0',
    'description': 'A NoneBot2 plugin generates a picture which shows the status of current device',
    'long_description': '<!-- markdownlint-disable MD033 MD036 MD041 -->\n\n<div align="center">\n  <a href="https://v2.nonebot.dev/store">\n    <img src="https://raw.githubusercontent.com/A-kirami/nonebot-plugin-template/resources/nbp_logo.png" width="180" height="180" alt="logo">\n  </a>\n  <br>\n  <p>\n    <img src="https://raw.githubusercontent.com/A-kirami/nonebot-plugin-template/resources/NoneBotPlugin.svg" width="240" alt="logo">\n  </p>\n</div>\n\n<div align="center">\n\n# NoneBot-Plugin-PicStatus\n\n_✨ 运行状态图片版 for NoneBot2 ✨_\n\n<a href="./LICENSE">\n  <img src="https://img.shields.io/github/license/lgc2333/nonebot-plugin-picstatus.svg" alt="license">\n</a>\n<a href="https://pypi.python.org/pypi/nonebot-plugin-picstatus">\n  <img src="https://img.shields.io/pypi/v/nonebot-plugin-picstatus.svg" alt="pypi">\n</a>\n<img src="https://img.shields.io/badge/python-3.8+-blue.svg" alt="python">\n<a href="https://pypi.python.org/pypi/nonebot-plugin-picstatus">\n  <img src="https://img.shields.io/pypi/dm/nonebot-plugin-picstatus" alt="pypi download">\n</a>\n<a href="https://wakatime.com/badge/user/b61b0f9a-f40b-4c82-bc51-0a75c67bfccf/project/bfec6993-aa9e-42fb-9f3e-53a5d4739373">\n  <img src="https://wakatime.com/badge/user/b61b0f9a-f40b-4c82-bc51-0a75c67bfccf/project/bfec6993-aa9e-42fb-9f3e-53a5d4739373.svg" alt="wakatime">\n</a>\n\n</div>\n\n## 📖 介绍\n\n不多说，直接看图！\n\n### 效果图\n\n![example](https://raw.githubusercontent.com/lgc2333/nonebot-plugin-picstatus/master/readme/example.png)\n\n## 💿 安装\n\n<details open>\n<summary>[推荐] 使用 nb-cli 安装</summary>\n在 nonebot2 项目的根目录下打开命令行, 输入以下指令即可安装\n\n    nb plugin install nonebot-plugin-picstatus\n\n</details>\n\n<details>\n<summary>使用包管理器安装</summary>\n在 nonebot2 项目的插件目录下, 打开命令行, 根据你使用的包管理器, 输入相应的安装命令\n\n<details>\n<summary>pip</summary>\n\n    pip install nonebot-plugin-picstatus\n\n</details>\n<details>\n<summary>pdm</summary>\n\n    pdm add nonebot-plugin-picstatus\n\n</details>\n<details>\n<summary>poetry</summary>\n\n    poetry add nonebot-plugin-picstatus\n\n</details>\n<details>\n<summary>conda</summary>\n\n    conda install nonebot-plugin-picstatus\n\n</details>\n\n打开 nonebot2 项目的 `bot.py` 文件, 在其中写入\n\n    nonebot.load_plugin(\'nonebot_plugin_picstatus\')\n\n</details>\n\n<details>\n<summary>从 github 安装</summary>\n在 nonebot2 项目的插件目录下, 打开命令行, 输入以下命令克隆此储存库\n\n    git clone https://github.com/lgc2333/nonebot-plugin-picstatus.git\n\n打开 nonebot2 项目的 `bot.py` 文件, 在其中写入\n\n    nonebot.load_plugin(\'src.plugins.nonebot_plugin_picstatus\')\n\n</details>\n\n## ⚙️ 配置\n\n在 nonebot2 项目的`.env`文件中添加下表中的必填配置\n\n|      配置项      |       类型       | 必填 | 默认值  |              说明              |\n| :--------------: | :--------------: | :--: | :-----: | :----------------------------: |\n|   `PS_ONLY_SU`   | 布尔值（`bool`） |  否  | `False` | 是否只能由`SuperUsers`触发指令 |\n| `PS_BLUR_RADIUS` |  整数（`int`）   |  否  |   `4`   |        背景高斯模糊半径        |\n|    `PS_FONT`     |  文本（`str`）   |  否  |   无    |         自定义字体路径         |\n\n## 🎉 使用\n\n使用指令`运行状态`（或者`状态`）来触发插件功能  \n可以在消息后面跟一张图片或者回复一张图片来自定义背景图，默认为随机背景图  \n可以配置`PS_ONLY_SU`配置项来仅允许超级用户（`SuperUsers`）触发插件功能（见[配置](#️-配置)）\n\n## 📞 联系\n\nQQ：3076823485  \nTelegram：[@lgc2333](https://t.me/lgc2333)  \n吹水群：[1105946125](https://jq.qq.com/?_wv=1027&k=Z3n1MpEp)  \n邮箱：<lgc2333@126.com>\n\n<!--\n## 💡 鸣谢\n-->\n\n## 💰 赞助\n\n感谢大家的赞助！你们的赞助将是我继续创作的动力！\n\n- [爱发电](https://afdian.net/@lgc2333)\n- <details>\n    <summary>赞助二维码（点击展开）</summary>\n\n  ![讨饭](https://raw.githubusercontent.com/lgc2333/ShigureBotMenu/master/src/imgs/sponsor.png)\n\n  </details>\n\n## 📝 更新日志\n\n### 暂无\n',
    'author': 'student_2333',
    'author_email': 'lgc2333@126.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
