import * as events from '@aws-cdk/aws-events';
import * as lambda from '@aws-cdk/aws-lambda';
import { Construct } from '@aws-cdk/core';
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 *
 * @stability stable
 */
export declare class EventBridgeDestination implements lambda.IDestination {
    private readonly eventBus?;
    /**
     * @default - use the default event bus
     * @stability stable
     */
    constructor(eventBus?: events.IEventBus | undefined);
    /**
     * Returns a destination configuration.
     *
     * @stability stable
     */
    bind(_scope: Construct, fn: lambda.IFunction, _options?: lambda.DestinationOptions): lambda.DestinationConfig;
}
