# rigoletto
API Description

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.1.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

```sh
pip install deutschland[rigoletto]
```

### poetry install

```sh
poetry add deutschland -E rigoletto
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

## Usage

Import the package:
```python
from deutschland import rigoletto
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
from deutschland import rigoletto
from pprint import pprint
from deutschland.rigoletto.api import default_api
from deutschland.rigoletto.model.http_validation_error import HTTPValidationError
# Defining the host is optional and defaults to https://rigoletto.herokuapp.com
# See configuration.py for a list of all supported configuration parameters.
configuration = rigoletto.Configuration(
    host = "https://rigoletto.herokuapp.com"
)



# Enter a context with an instance of the API client
with rigoletto.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    kennnummer = 1 # int |  (optional)
    kennnummer_greater_than = 1 # int |  (optional)
    kennnummer_greater_than_equal = 1 # int |  (optional)
    kennnummer_less_than = 1 # int |  (optional)
    kennnummer_less_than_equal = 1 # int |  (optional)
    einstufungsbezeichnung = "Einstufungsbezeichnung_example" # str |  (optional)
    einstufungsbezeichnung_contains = "Einstufungsbezeichnung_contains_example" # str |  (optional)
    einstufungsbezeichnung_englisch = "EinstufungsbezeichnungEnglisch_example" # str |  (optional)
    einstufungsbezeichnung_englisch_contains = "EinstufungsbezeichnungEnglisch_contains_example" # str |  (optional)
    stoffname = "Stoffname_example" # str |  (optional)
    stoffname_contains = "Stoffname_contains_example" # str |  (optional)
    gruppenname = "Gruppenname_example" # str |  (optional)
    gruppenname_contains = "Gruppenname_contains_example" # str |  (optional)
    cas_nr = "CAS_Nr_example" # str |  (optional)
    cas_nr_contains = "CAS_Nr_contains_example" # str |  (optional)
    eg_nr = "EG_Nr_example" # str |  (optional)
    eg_nr_contains = "EG_Nr_contains_example" # str |  (optional)
    m_faktor = "MFaktor_example" # str |  (optional)
    m_faktor_contains = "MFaktor_contains_example" # str |  (optional)
    synonym = "Synonym_example" # str |  (optional)
    synonym_contains = "Synonym_contains_example" # str |  (optional)
    verffentlichungsdatum = "Veröffentlichungsdatum_example" # str |  (optional)
    verffentlichungsdatum_contains = "Veröffentlichungsdatum_contains_example" # str |  (optional)
    wgk = "WGK_example" # str |  (optional)
    wgk_contains = "WGK_contains_example" # str |  (optional)
    fussnoten = 3.14 # float |  (optional)
    fussnoten_greater_than = 3.14 # float |  (optional)
    fussnoten_greater_than_equal = 3.14 # float |  (optional)
    fussnoten_less_than = 3.14 # float |  (optional)
    fussnoten_less_than_equal = 3.14 # float |  (optional)

    try:
        # Export Tabelle
        api_response = api_instance.export_tabelle_export_tabelle_get(kennnummer=kennnummer, kennnummer_greater_than=kennnummer_greater_than, kennnummer_greater_than_equal=kennnummer_greater_than_equal, kennnummer_less_than=kennnummer_less_than, kennnummer_less_than_equal=kennnummer_less_than_equal, einstufungsbezeichnung=einstufungsbezeichnung, einstufungsbezeichnung_contains=einstufungsbezeichnung_contains, einstufungsbezeichnung_englisch=einstufungsbezeichnung_englisch, einstufungsbezeichnung_englisch_contains=einstufungsbezeichnung_englisch_contains, stoffname=stoffname, stoffname_contains=stoffname_contains, gruppenname=gruppenname, gruppenname_contains=gruppenname_contains, cas_nr=cas_nr, cas_nr_contains=cas_nr_contains, eg_nr=eg_nr, eg_nr_contains=eg_nr_contains, m_faktor=m_faktor, m_faktor_contains=m_faktor_contains, synonym=synonym, synonym_contains=synonym_contains, verffentlichungsdatum=verffentlichungsdatum, verffentlichungsdatum_contains=verffentlichungsdatum_contains, wgk=wgk, wgk_contains=wgk_contains, fussnoten=fussnoten, fussnoten_greater_than=fussnoten_greater_than, fussnoten_greater_than_equal=fussnoten_greater_than_equal, fussnoten_less_than=fussnoten_less_than, fussnoten_less_than_equal=fussnoten_less_than_equal)
        pprint(api_response)
    except rigoletto.ApiException as e:
        print("Exception when calling DefaultApi->export_tabelle_export_tabelle_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://rigoletto.herokuapp.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**export_tabelle_export_tabelle_get**](docs/DefaultApi.md#export_tabelle_export_tabelle_get) | **GET** /Export_Tabelle | Export Tabelle


## Documentation For Models

 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [LocationInner](docs/LocationInner.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

kontakt@bund.dev


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in rigoletto.apis and rigoletto.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from deutschland.rigoletto.api.default_api import DefaultApi`
- `from deutschland.rigoletto.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
from deutschland import rigoletto
from deutschland.rigoletto.apis import *
from deutschland.rigoletto.models import *
```

