"""
    Umweltbundesamt: Rigoletto API

    API Description  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: kontakt@bund.dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from deutschland.rigoletto.api_client import ApiClient
from deutschland.rigoletto.api_client import Endpoint as _Endpoint
from deutschland.rigoletto.model.http_validation_error import HTTPValidationError
from deutschland.rigoletto.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.export_tabelle_export_tabelle_get_endpoint = _Endpoint(
            settings={
                "response_type": (
                    bool,
                    date,
                    datetime,
                    dict,
                    float,
                    int,
                    list,
                    str,
                    none_type,
                ),
                "auth": [],
                "endpoint_path": "/Export_Tabelle",
                "operation_id": "export_tabelle_export_tabelle_get",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "kennnummer",
                    "kennnummer_greater_than",
                    "kennnummer_greater_than_equal",
                    "kennnummer_less_than",
                    "kennnummer_less_than_equal",
                    "einstufungsbezeichnung",
                    "einstufungsbezeichnung_contains",
                    "einstufungsbezeichnung_englisch",
                    "einstufungsbezeichnung_englisch_contains",
                    "stoffname",
                    "stoffname_contains",
                    "gruppenname",
                    "gruppenname_contains",
                    "cas_nr",
                    "cas_nr_contains",
                    "eg_nr",
                    "eg_nr_contains",
                    "m_faktor",
                    "m_faktor_contains",
                    "synonym",
                    "synonym_contains",
                    "verffentlichungsdatum",
                    "verffentlichungsdatum_contains",
                    "wgk",
                    "wgk_contains",
                    "fussnoten",
                    "fussnoten_greater_than",
                    "fussnoten_greater_than_equal",
                    "fussnoten_less_than",
                    "fussnoten_less_than_equal",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "kennnummer": (int,),
                    "kennnummer_greater_than": (int,),
                    "kennnummer_greater_than_equal": (int,),
                    "kennnummer_less_than": (int,),
                    "kennnummer_less_than_equal": (int,),
                    "einstufungsbezeichnung": (str,),
                    "einstufungsbezeichnung_contains": (str,),
                    "einstufungsbezeichnung_englisch": (str,),
                    "einstufungsbezeichnung_englisch_contains": (str,),
                    "stoffname": (str,),
                    "stoffname_contains": (str,),
                    "gruppenname": (str,),
                    "gruppenname_contains": (str,),
                    "cas_nr": (str,),
                    "cas_nr_contains": (str,),
                    "eg_nr": (str,),
                    "eg_nr_contains": (str,),
                    "m_faktor": (str,),
                    "m_faktor_contains": (str,),
                    "synonym": (str,),
                    "synonym_contains": (str,),
                    "verffentlichungsdatum": (str,),
                    "verffentlichungsdatum_contains": (str,),
                    "wgk": (str,),
                    "wgk_contains": (str,),
                    "fussnoten": (float,),
                    "fussnoten_greater_than": (float,),
                    "fussnoten_greater_than_equal": (float,),
                    "fussnoten_less_than": (float,),
                    "fussnoten_less_than_equal": (float,),
                },
                "attribute_map": {
                    "kennnummer": "Kennnummer",
                    "kennnummer_greater_than": "Kennnummer_greaterThan",
                    "kennnummer_greater_than_equal": "Kennnummer_greaterThanEqual",
                    "kennnummer_less_than": "Kennnummer_lessThan",
                    "kennnummer_less_than_equal": "Kennnummer_lessThanEqual",
                    "einstufungsbezeichnung": "Einstufungsbezeichnung",
                    "einstufungsbezeichnung_contains": "Einstufungsbezeichnung_contains",
                    "einstufungsbezeichnung_englisch": "EinstufungsbezeichnungEnglisch",
                    "einstufungsbezeichnung_englisch_contains": "EinstufungsbezeichnungEnglisch_contains",
                    "stoffname": "Stoffname",
                    "stoffname_contains": "Stoffname_contains",
                    "gruppenname": "Gruppenname",
                    "gruppenname_contains": "Gruppenname_contains",
                    "cas_nr": "CAS_Nr",
                    "cas_nr_contains": "CAS_Nr_contains",
                    "eg_nr": "EG_Nr",
                    "eg_nr_contains": "EG_Nr_contains",
                    "m_faktor": "MFaktor",
                    "m_faktor_contains": "MFaktor_contains",
                    "synonym": "Synonym",
                    "synonym_contains": "Synonym_contains",
                    "verffentlichungsdatum": "Veröffentlichungsdatum",
                    "verffentlichungsdatum_contains": "Veröffentlichungsdatum_contains",
                    "wgk": "WGK",
                    "wgk_contains": "WGK_contains",
                    "fussnoten": "Fussnoten",
                    "fussnoten_greater_than": "Fussnoten_greaterThan",
                    "fussnoten_greater_than_equal": "Fussnoten_greaterThanEqual",
                    "fussnoten_less_than": "Fussnoten_lessThan",
                    "fussnoten_less_than_equal": "Fussnoten_lessThanEqual",
                },
                "location_map": {
                    "kennnummer": "query",
                    "kennnummer_greater_than": "query",
                    "kennnummer_greater_than_equal": "query",
                    "kennnummer_less_than": "query",
                    "kennnummer_less_than_equal": "query",
                    "einstufungsbezeichnung": "query",
                    "einstufungsbezeichnung_contains": "query",
                    "einstufungsbezeichnung_englisch": "query",
                    "einstufungsbezeichnung_englisch_contains": "query",
                    "stoffname": "query",
                    "stoffname_contains": "query",
                    "gruppenname": "query",
                    "gruppenname_contains": "query",
                    "cas_nr": "query",
                    "cas_nr_contains": "query",
                    "eg_nr": "query",
                    "eg_nr_contains": "query",
                    "m_faktor": "query",
                    "m_faktor_contains": "query",
                    "synonym": "query",
                    "synonym_contains": "query",
                    "verffentlichungsdatum": "query",
                    "verffentlichungsdatum_contains": "query",
                    "wgk": "query",
                    "wgk_contains": "query",
                    "fussnoten": "query",
                    "fussnoten_greater_than": "query",
                    "fussnoten_greater_than_equal": "query",
                    "fussnoten_less_than": "query",
                    "fussnoten_less_than_equal": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

    def export_tabelle_export_tabelle_get(self, **kwargs):
        """Export Tabelle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_tabelle_export_tabelle_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            kennnummer (int): [optional]
            kennnummer_greater_than (int): [optional]
            kennnummer_greater_than_equal (int): [optional]
            kennnummer_less_than (int): [optional]
            kennnummer_less_than_equal (int): [optional]
            einstufungsbezeichnung (str): [optional]
            einstufungsbezeichnung_contains (str): [optional]
            einstufungsbezeichnung_englisch (str): [optional]
            einstufungsbezeichnung_englisch_contains (str): [optional]
            stoffname (str): [optional]
            stoffname_contains (str): [optional]
            gruppenname (str): [optional]
            gruppenname_contains (str): [optional]
            cas_nr (str): [optional]
            cas_nr_contains (str): [optional]
            eg_nr (str): [optional]
            eg_nr_contains (str): [optional]
            m_faktor (str): [optional]
            m_faktor_contains (str): [optional]
            synonym (str): [optional]
            synonym_contains (str): [optional]
            verffentlichungsdatum (str): [optional]
            verffentlichungsdatum_contains (str): [optional]
            wgk (str): [optional]
            wgk_contains (str): [optional]
            fussnoten (float): [optional]
            fussnoten_greater_than (float): [optional]
            fussnoten_greater_than_equal (float): [optional]
            fussnoten_less_than (float): [optional]
            fussnoten_less_than_equal (float): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.export_tabelle_export_tabelle_get_endpoint.call_with_http_info(
            **kwargs
        )
