# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['deutschland',
 'deutschland.rigoletto',
 'deutschland.rigoletto.api',
 'deutschland.rigoletto.apis',
 'deutschland.rigoletto.model',
 'deutschland.rigoletto.models']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil', 'urllib3>=1.25.3']

setup_kwargs = {
    'name': 'de-rigoletto',
    'version': '0.1.0',
    'description': 'Umweltbundesamt: Rigoletto API',
    'long_description': '# rigoletto\nAPI Description\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: 1.0.0\n- Package version: 0.1.0\n- Build package: org.openapitools.codegen.languages.PythonClientCodegen\n\n## Requirements.\n\nPython >= 3.6\n\n## Installation & Usage\n### pip install\n\n```sh\npip install deutschland[rigoletto]\n```\n\n### poetry install\n\n```sh\npoetry add deutschland -E rigoletto\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\n## Usage\n\nImport the package:\n```python\nfrom deutschland import rigoletto\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\n\nimport time\nfrom deutschland import rigoletto\nfrom pprint import pprint\nfrom deutschland.rigoletto.api import default_api\nfrom deutschland.rigoletto.model.http_validation_error import HTTPValidationError\n# Defining the host is optional and defaults to https://rigoletto.herokuapp.com\n# See configuration.py for a list of all supported configuration parameters.\nconfiguration = rigoletto.Configuration(\n    host = "https://rigoletto.herokuapp.com"\n)\n\n\n\n# Enter a context with an instance of the API client\nwith rigoletto.ApiClient(configuration) as api_client:\n    # Create an instance of the API class\n    api_instance = default_api.DefaultApi(api_client)\n    kennnummer = 1 # int |  (optional)\n    kennnummer_greater_than = 1 # int |  (optional)\n    kennnummer_greater_than_equal = 1 # int |  (optional)\n    kennnummer_less_than = 1 # int |  (optional)\n    kennnummer_less_than_equal = 1 # int |  (optional)\n    einstufungsbezeichnung = "Einstufungsbezeichnung_example" # str |  (optional)\n    einstufungsbezeichnung_contains = "Einstufungsbezeichnung_contains_example" # str |  (optional)\n    einstufungsbezeichnung_englisch = "EinstufungsbezeichnungEnglisch_example" # str |  (optional)\n    einstufungsbezeichnung_englisch_contains = "EinstufungsbezeichnungEnglisch_contains_example" # str |  (optional)\n    stoffname = "Stoffname_example" # str |  (optional)\n    stoffname_contains = "Stoffname_contains_example" # str |  (optional)\n    gruppenname = "Gruppenname_example" # str |  (optional)\n    gruppenname_contains = "Gruppenname_contains_example" # str |  (optional)\n    cas_nr = "CAS_Nr_example" # str |  (optional)\n    cas_nr_contains = "CAS_Nr_contains_example" # str |  (optional)\n    eg_nr = "EG_Nr_example" # str |  (optional)\n    eg_nr_contains = "EG_Nr_contains_example" # str |  (optional)\n    m_faktor = "MFaktor_example" # str |  (optional)\n    m_faktor_contains = "MFaktor_contains_example" # str |  (optional)\n    synonym = "Synonym_example" # str |  (optional)\n    synonym_contains = "Synonym_contains_example" # str |  (optional)\n    verffentlichungsdatum = "Veröffentlichungsdatum_example" # str |  (optional)\n    verffentlichungsdatum_contains = "Veröffentlichungsdatum_contains_example" # str |  (optional)\n    wgk = "WGK_example" # str |  (optional)\n    wgk_contains = "WGK_contains_example" # str |  (optional)\n    fussnoten = 3.14 # float |  (optional)\n    fussnoten_greater_than = 3.14 # float |  (optional)\n    fussnoten_greater_than_equal = 3.14 # float |  (optional)\n    fussnoten_less_than = 3.14 # float |  (optional)\n    fussnoten_less_than_equal = 3.14 # float |  (optional)\n\n    try:\n        # Export Tabelle\n        api_response = api_instance.export_tabelle_export_tabelle_get(kennnummer=kennnummer, kennnummer_greater_than=kennnummer_greater_than, kennnummer_greater_than_equal=kennnummer_greater_than_equal, kennnummer_less_than=kennnummer_less_than, kennnummer_less_than_equal=kennnummer_less_than_equal, einstufungsbezeichnung=einstufungsbezeichnung, einstufungsbezeichnung_contains=einstufungsbezeichnung_contains, einstufungsbezeichnung_englisch=einstufungsbezeichnung_englisch, einstufungsbezeichnung_englisch_contains=einstufungsbezeichnung_englisch_contains, stoffname=stoffname, stoffname_contains=stoffname_contains, gruppenname=gruppenname, gruppenname_contains=gruppenname_contains, cas_nr=cas_nr, cas_nr_contains=cas_nr_contains, eg_nr=eg_nr, eg_nr_contains=eg_nr_contains, m_faktor=m_faktor, m_faktor_contains=m_faktor_contains, synonym=synonym, synonym_contains=synonym_contains, verffentlichungsdatum=verffentlichungsdatum, verffentlichungsdatum_contains=verffentlichungsdatum_contains, wgk=wgk, wgk_contains=wgk_contains, fussnoten=fussnoten, fussnoten_greater_than=fussnoten_greater_than, fussnoten_greater_than_equal=fussnoten_greater_than_equal, fussnoten_less_than=fussnoten_less_than, fussnoten_less_than_equal=fussnoten_less_than_equal)\n        pprint(api_response)\n    except rigoletto.ApiException as e:\n        print("Exception when calling DefaultApi->export_tabelle_export_tabelle_get: %s\\n" % e)\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *https://rigoletto.herokuapp.com*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*DefaultApi* | [**export_tabelle_export_tabelle_get**](docs/DefaultApi.md#export_tabelle_export_tabelle_get) | **GET** /Export_Tabelle | Export Tabelle\n\n\n## Documentation For Models\n\n - [HTTPValidationError](docs/HTTPValidationError.md)\n - [LocationInner](docs/LocationInner.md)\n - [ValidationError](docs/ValidationError.md)\n\n\n## Documentation For Authorization\n\n All endpoints do not require authorization.\n\n## Author\n\nkontakt@bund.dev\n\n\n## Notes for Large OpenAPI documents\nIf the OpenAPI document is large, imports in rigoletto.apis and rigoletto.models may fail with a\nRecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:\n\nSolution 1:\nUse specific imports for apis and models like:\n- `from deutschland.rigoletto.api.default_api import DefaultApi`\n- `from deutschland.rigoletto.model.pet import Pet`\n\nSolution 2:\nBefore importing the package, adjust the maximum recursion limit as shown below:\n```\nimport sys\nsys.setrecursionlimit(1500)\nfrom deutschland import rigoletto\nfrom deutschland.rigoletto.apis import *\nfrom deutschland.rigoletto.models import *\n```\n\n',
    'author': 'BundesAPI',
    'author_email': 'kontakt@bund.dev',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/bundesAPI/rigoletto-api.git',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
