/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as elb from "aws-cdk-lib/aws-elasticloadbalancingv2";
import { Construct } from "constructs";
import * as ec2 from "aws-cdk-lib/aws-ec2";
import * as s3 from "aws-cdk-lib/aws-s3";
import * as ecs from "aws-cdk-lib/aws-ecs";
import * as lambda from "aws-cdk-lib/aws-lambda";
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Returns the correct ALB Load Balancer to use in this construct, either an existing
 * one provided as an argument or create  new one otherwise.
 */
export declare function ObtainAlb(scope: Construct, id: string, vpc: ec2.IVpc, publicApi: boolean, existingLoadBalancerObj?: elb.ApplicationLoadBalancer, loadBalancerProps?: elb.ApplicationLoadBalancerProps | any, logAccessLogs?: boolean, loggingBucketProps?: s3.BucketProps): elb.ApplicationLoadBalancer;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function AddListener(scope: Construct, id: string, loadBalancer: elb.ApplicationLoadBalancer, listenerProps: elb.ApplicationListenerProps | any): elb.ApplicationListener;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Creates a Target Group for Lambda functions and adds the
 * provided functions as a target to that group. Then adds
 * the new Target Group to the provided Listener.
 */
export declare function AddLambdaTarget(scope: Construct, id: string, currentListener: elb.ApplicationListener, lambdaFunction: lambda.IFunction, ruleProps?: elb.AddRuleProps, targetProps?: elb.ApplicationTargetGroupProps): elb.ApplicationTargetGroup;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function AddFargateTarget(scope: Construct, id: string, currentListener: elb.ApplicationListener, fargateService: ecs.FargateService, ruleProps?: elb.AddRuleProps, targetProps?: elb.ApplicationTargetGroupProps): elb.ApplicationTargetGroup;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Looks for the listener associated with Target Groups
 * If there is a single listener, this returns it whether it is HTTP or HTTPS
 * If there are 2 listeners, it finds the HTTPS listener (we assume the HTTP listener redirects to HTTPS)
 */
export declare function GetActiveListener(listeners: elb.ApplicationListener[]): elb.ApplicationListener;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function CheckAlbProps(props: any): void;
