/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as logs from 'aws-cdk-lib/aws-logs';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as cdk from 'aws-cdk-lib';
import * as apigateway from 'aws-cdk-lib/aws-apigateway';
import * as iam from 'aws-cdk-lib/aws-iam';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
export interface GlobalLambdaRestApiResponse {
    readonly api: apigateway.RestApi;
    readonly role?: iam.Role;
    readonly group: logs.LogGroup;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Builds and returns a global api.RestApi designed to be used with an AWS Lambda function.
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _existingLambdaObj - an existing AWS Lambda function.
 * @param apiGatewayProps - (optional) user-specified properties to override the default properties.
 */
export declare function GlobalLambdaRestApi(scope: Construct, _existingLambdaObj: lambda.Function, apiGatewayProps?: apigateway.LambdaRestApiProps, logGroupProps?: logs.LogGroupProps): GlobalLambdaRestApiResponse;
export interface RegionalLambdaRestApiResponse {
    readonly api: apigateway.RestApi;
    readonly role?: iam.Role;
    readonly group: logs.LogGroup;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Builds and returns a regional api.RestApi designed to be used with an AWS Lambda function.
 * @param scope - the construct to which the RestApi should be attached to.
 * @param existingLambdaObj - an existing AWS Lambda function.
 * @param apiGatewayProps - (optional) user-specified properties to override the default properties.
 */
export declare function RegionalLambdaRestApi(scope: Construct, existingLambdaObj: lambda.Function, apiGatewayProps?: apigateway.LambdaRestApiProps, logGroupProps?: logs.LogGroupProps): RegionalLambdaRestApiResponse;
export interface GlobalRestApiResponse {
    readonly api: apigateway.RestApi;
    readonly role?: iam.Role;
    readonly logGroup: logs.LogGroup;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Builds and returns a standard api.RestApi.
 * @param scope - the construct to which the RestApi should be attached to.
 * @param apiGatewayProps - (optional) user-specified properties to override the default properties.
 */
export declare function GlobalRestApi(scope: Construct, apiGatewayProps?: apigateway.RestApiProps, logGroupProps?: logs.LogGroupProps): GlobalRestApiResponse;
export interface RegionalRestApiResponse {
    readonly api: apigateway.RestApi;
    readonly role?: iam.Role;
    readonly logGroup: logs.LogGroup;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Builds and returns a Regional api.RestApi.
 * @param scope - the construct to which the RestApi should be attached to.
 * @param apiGatewayProps - (optional) user-specified properties to override the default properties.
 */
export declare function RegionalRestApi(scope: Construct, apiGatewayProps?: apigateway.RestApiProps, logGroupProps?: logs.LogGroupProps): RegionalRestApiResponse;
export interface AddProxyMethodToApiResourceInputParams {
    readonly service: string;
    readonly action?: string;
    readonly path?: string;
    readonly apiResource: apigateway.IResource;
    readonly apiMethod: string;
    readonly apiGatewayRole: IRole;
    readonly requestTemplate: string;
    readonly additionalRequestTemplates?: {
        [contentType: string]: string;
    };
    readonly integrationResponses?: cdk.aws_apigateway.IntegrationResponse[];
    readonly contentType?: string;
    readonly requestValidator?: apigateway.IRequestValidator;
    readonly requestModel?: {
        [contentType: string]: apigateway.IModel;
    };
    readonly awsIntegrationProps?: apigateway.AwsIntegrationProps | any;
    readonly methodOptions?: apigateway.MethodOptions;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function addProxyMethodToApiResource(params: AddProxyMethodToApiResourceInputParams): apigateway.Method;
