/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cloudfront from 'aws-cdk-lib/aws-cloudfront';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as api from 'aws-cdk-lib/aws-apigateway';
import * as mediastore from 'aws-cdk-lib/aws-mediastore';
import { Construct } from 'constructs';
export interface CloudFrontDistributionForApiGatewayResponse {
    readonly distribution: cloudfront.Distribution;
    readonly cloudfrontFunction?: cloudfront.Function;
    readonly loggingBucket?: s3.Bucket;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function CloudFrontDistributionForApiGateway(scope: Construct, apiEndPoint: api.RestApi, cloudFrontDistributionProps?: cloudfront.DistributionProps | any, httpSecurityHeaders?: boolean, cloudFrontLoggingBucketProps?: s3.BucketProps, responseHeadersPolicyProps?: cloudfront.ResponseHeadersPolicyProps): CloudFrontDistributionForApiGatewayResponse;
export interface CloudFrontDistributionForS3Response {
    readonly distribution: cloudfront.Distribution;
    readonly loggingBucket?: s3.Bucket;
    readonly cloudfrontFunction?: cloudfront.Function;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function CloudFrontDistributionForS3(scope: Construct, sourceBucket: s3.IBucket, cloudFrontDistributionProps?: cloudfront.DistributionProps | any, httpSecurityHeaders?: boolean, originPath?: string, cloudFrontLoggingBucketProps?: s3.BucketProps, responseHeadersPolicyProps?: cloudfront.ResponseHeadersPolicyProps): CloudFrontDistributionForS3Response;
export interface CloudFrontDistributionForMediaStoreResponse {
    readonly distribution: cloudfront.Distribution;
    readonly loggingBucket?: s3.Bucket;
    readonly requestPolicy: cloudfront.OriginRequestPolicy;
    readonly cloudfrontFunction?: cloudfront.Function;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function CloudFrontDistributionForMediaStore(scope: Construct, mediaStoreContainer: mediastore.CfnContainer, cloudFrontDistributionProps?: cloudfront.DistributionProps | any, httpSecurityHeaders?: boolean, cloudFrontLoggingBucketProps?: s3.BucketProps, responseHeadersPolicyProps?: cloudfront.ResponseHeadersPolicyProps): CloudFrontDistributionForMediaStoreResponse;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function CloudFrontOriginAccessIdentity(scope: Construct, comment?: string): cloudfront.OriginAccessIdentity;
