"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultUserPoolProps = exports.DefaultUserPoolClientProps = exports.DefaultIdentityPoolProps = void 0;
const DefaultUserPoolProps = {};
exports.DefaultUserPoolProps = DefaultUserPoolProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultIdentityPoolProps(userPoolClientId, userPoolProviderName) {
    return {
        allowUnauthenticatedIdentities: false,
        cognitoIdentityProviders: [{
                clientId: userPoolClientId,
                providerName: userPoolProviderName,
                serverSideTokenCheck: true
            }]
    };
}
exports.DefaultIdentityPoolProps = DefaultIdentityPoolProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultUserPoolClientProps(userpool) {
    return {
        userPool: userpool
    };
}
exports.DefaultUserPoolClientProps = DefaultUserPoolClientProps;
//# sourceMappingURL=data:application/json;base64,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