/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cognito from 'aws-cdk-lib/aws-cognito';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
export interface CognitoOptions {
    readonly identitypool: cognito.CfnIdentityPool;
    readonly userpool: cognito.UserPool;
    readonly userpoolclient: cognito.UserPoolClient;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function buildUserPool(scope: Construct, userPoolProps?: cognito.UserPoolProps): cognito.UserPool;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function buildUserPoolClient(scope: Construct, userPool: cognito.UserPool, cognitoUserPoolClientProps?: cognito.UserPoolClientProps): cognito.UserPoolClient;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function buildIdentityPool(scope: Construct, userpool: cognito.UserPool, userpoolclient: cognito.UserPoolClient, identityPoolProps?: cognito.CfnIdentityPoolProps): cognito.CfnIdentityPool;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function setupCognitoForSearchService(scope: Construct, domainName: string, options: CognitoOptions): iam.Role;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function buildCognitoForSearchService(scope: Construct, domainName: string): [cognito.UserPool, cognito.UserPoolClient, cognito.CfnIdentityPool, iam.Role];
